/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.jdbc.SQLText;
import com.impossibl.postgres.jdbc.SQLTextEscapeFunctions;
import com.impossibl.postgres.jdbc.SQLTextTree;
import com.impossibl.postgres.system.Context;
import java.lang.reflect.Method;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class SQLTextEscapes {
    static void processEscapes(SQLText text, final Context context) throws SQLException {
        text.process(new SQLTextTree.Processor(){

            @Override
            public SQLTextTree.Node process(SQLTextTree.Node node) throws SQLException {
                if (!(node instanceof SQLTextTree.EscapeNode)) {
                    return node;
                }
                return SQLTextEscapes.processEscape((SQLTextTree.EscapeNode)node, context);
            }
        }, true);
    }

    static String getEscapeType(SQLTextTree.EscapeNode escape) throws SQLException {
        return SQLTextEscapes.getNodeNotOf(escape, 0, SQLTextTree.WhitespacePiece.class, SQLTextTree.PieceNode.class).getText().toLowerCase();
    }

    private static SQLTextTree.Node processEscape(SQLTextTree.EscapeNode escape, Context context) throws SQLException {
        SQLTextTree.Node result;
        switch (SQLTextEscapes.getEscapeType(escape)) {
            case "fn": {
                result = SQLTextEscapes.processFunctionEscape(escape);
                break;
            }
            case "d": {
                result = SQLTextEscapes.processDateEscape(escape, context);
                break;
            }
            case "t": {
                result = SQLTextEscapes.processTimeEscape(escape, context);
                break;
            }
            case "ts": {
                result = SQLTextEscapes.processTimestampEscape(escape, context);
                break;
            }
            case "oj": {
                result = SQLTextEscapes.processOuterJoinEscape(escape);
                break;
            }
            case "call": {
                result = SQLTextEscapes.processCallEscape(escape);
                break;
            }
            case "$1": {
                result = SQLTextEscapes.processCallAssignEscape(escape);
                break;
            }
            case "limit": {
                result = SQLTextEscapes.processLimitEscape(escape);
                break;
            }
            case "escape": {
                result = SQLTextEscapes.processLikeEscape(escape);
                break;
            }
            default: {
                throw new SQLException("Invalid escape (" + escape.getStartPos() + ")", "Syntax Error");
            }
        }
        return result;
    }

    private static SQLTextTree.Node processFunctionEscape(SQLTextTree.EscapeNode escape) throws SQLException {
        escape.removeAll(SQLTextTree.WhitespacePiece.class, false);
        SQLTextEscapes.checkSize(escape, 3);
        SQLTextTree.UnquotedIdentifierPiece name = SQLTextEscapes.getNode(escape, 1, SQLTextTree.UnquotedIdentifierPiece.class);
        List<SQLTextTree.Node> args = SQLTextEscapes.split(SQLTextEscapes.getNode(escape, 2, SQLTextTree.ParenGroupNode.class), false, ",");
        Method method = SQLTextEscapeFunctions.getEscapeMethod(name.toString());
        if (method == null) {
            throw new SQLException("Escape function not supported (" + escape.getStartPos() + "): " + name, "Syntax Error");
        }
        return SQLTextEscapeFunctions.invokeEscape(method, name.toString(), args);
    }

    private static SQLTextTree.Node processDateEscape(SQLTextTree.EscapeNode escape, Context context) throws SQLException {
        Date date;
        escape.removeAll(SQLTextTree.WhitespacePiece.class, false);
        SQLTextEscapes.checkSize(escape, 2);
        SQLTextTree.StringLiteralPiece dateLit = SQLTextEscapes.getNode(escape, 1, SQLTextTree.StringLiteralPiece.class);
        try {
            date = Date.valueOf(dateLit.getText());
        }
        catch (Exception e1) {
            throw new SQLException("invalid date format in escape (" + escape.getStartPos() + ")");
        }
        return SQLTextEscapeFunctions.sequence("DATE", SQLTextEscapeFunctions.space(), SQLTextEscapeFunctions.literal(date.toString()));
    }

    private static SQLTextTree.Node processTimeEscape(SQLTextTree.EscapeNode escape, Context context) throws SQLException {
        Time time;
        escape.removeAll(SQLTextTree.WhitespacePiece.class, false);
        SQLTextEscapes.checkSize(escape, 2);
        SQLTextTree.StringLiteralPiece timeLit = SQLTextEscapes.getNode(escape, 1, SQLTextTree.StringLiteralPiece.class);
        try {
            time = Time.valueOf(timeLit.toString());
        }
        catch (Exception e1) {
            throw new SQLException("invalid time format in escape (" + escape.getStartPos() + ")");
        }
        return SQLTextEscapeFunctions.sequence("TIME", SQLTextEscapeFunctions.space(), SQLTextEscapeFunctions.literal(time.toString()));
    }

    private static SQLTextTree.Node processTimestampEscape(SQLTextTree.EscapeNode escape, Context context) throws SQLException {
        Timestamp timestamp;
        escape.removeAll(SQLTextTree.WhitespacePiece.class, false);
        SQLTextEscapes.checkSize(escape, 2);
        SQLTextTree.StringLiteralPiece tsLit = SQLTextEscapes.getNode(escape, 1, SQLTextTree.StringLiteralPiece.class);
        try {
            timestamp = Timestamp.valueOf(tsLit.toString());
        }
        catch (Exception e) {
            throw new SQLException("invalid timestamp format in escape (" + escape.getStartPos() + ")");
        }
        return SQLTextEscapeFunctions.sequence("TIMESTAMP", SQLTextEscapeFunctions.space(), SQLTextEscapeFunctions.literal(timestamp.toString()));
    }

    private static SQLTextTree.Node processOuterJoinEscape(SQLTextTree.EscapeNode escape) throws SQLException {
        List<SQLTextTree.Node> nodes = SQLTextEscapes.split(escape, true, "OJ", "LEFT", "RIGHT", "FULL", "OUTER", "JOIN", "ON");
        SQLTextEscapes.checkSize(nodes, escape.getStartPos(), 8);
        SQLTextEscapes.checkLiteralNode(nodes.get(3), "OUTER");
        SQLTextEscapes.checkLiteralNode(nodes.get(4), "JOIN");
        SQLTextEscapes.checkLiteralNode(nodes.get(6), "ON");
        return SQLTextEscapeFunctions.sequence(nodes.get(1), SQLTextEscapeFunctions.space(), nodes.get(2), "OUTER", "JOIN", nodes.get(5), "ON", nodes.get(7));
    }

    private static SQLTextTree.Node processCallAssignEscape(SQLTextTree.EscapeNode escape) throws SQLException {
        escape.removeAll(SQLTextTree.WhitespacePiece.class, false);
        SQLTextEscapes.checkLiteralNode(escape, 1, "=");
        SQLTextEscapes.checkLiteralNode(escape, 2, "call");
        escape.process(new SQLTextTree.Processor(){

            @Override
            public SQLTextTree.Node process(SQLTextTree.Node node) throws SQLException {
                if (node instanceof SQLTextTree.ParameterPiece) {
                    SQLTextTree.ParameterPiece pp = (SQLTextTree.ParameterPiece)node;
                    pp.setIdx(pp.getIdx() - 1);
                }
                return node;
            }
        }, true);
        if (escape.getNodeCount() > 4) {
            return SQLTextEscapeFunctions.groupedSequence("SELECT", SQLTextEscapeFunctions.space(), SQLTextEscapeFunctions.grammar("*"), "FROM", SQLTextEscapes.getNode(escape, 3, SQLTextTree.UnquotedIdentifierPiece.class), SQLTextEscapeFunctions.space(), SQLTextEscapes.getNode(escape, 4, SQLTextTree.ParenGroupNode.class));
        }
        return SQLTextEscapeFunctions.groupedSequence("SELECT", SQLTextEscapeFunctions.space(), SQLTextEscapeFunctions.grammar("*"), "FROM", SQLTextEscapes.getNode(escape, 3, SQLTextTree.UnquotedIdentifierPiece.class));
    }

    private static SQLTextTree.Node processCallEscape(SQLTextTree.EscapeNode escape) throws SQLException {
        escape.removeAll(SQLTextTree.WhitespacePiece.class, false);
        SQLTextEscapes.checkSize(escape, 2, 3);
        return SQLTextEscapeFunctions.groupedSequence("SELECT", SQLTextEscapeFunctions.space(), SQLTextEscapeFunctions.grammar("*"), "FROM", SQLTextEscapes.getNode(escape, 1, SQLTextTree.UnquotedIdentifierPiece.class), SQLTextEscapeFunctions.space(), SQLTextEscapes.getNode(escape, 2, SQLTextTree.ParenGroupNode.class));
    }

    private static SQLTextTree.Node processLimitEscape(SQLTextTree.EscapeNode escape) throws SQLException {
        escape.removeAll(SQLTextTree.WhitespacePiece.class, false);
        SQLTextEscapes.checkSize(escape, 2, 4);
        SQLTextTree.Node rows = SQLTextEscapes.getNode(escape, 1, SQLTextTree.Node.class);
        SQLTextTree.Node offset = null;
        if (escape.getNodeCount() == 4) {
            SQLTextEscapes.checkLiteralNode(escape, 2, "OFFSET");
            offset = SQLTextEscapes.getNode(escape, 3, SQLTextTree.Node.class);
        }
        SQLTextTree.Node limit = SQLTextEscapeFunctions.sequence("LIMIT", rows);
        if (offset != null) {
            limit = SQLTextEscapeFunctions.concat(limit, SQLTextEscapeFunctions.sequence(SQLTextEscapeFunctions.space(), "OFFSET", offset));
        }
        return limit;
    }

    private static SQLTextTree.Node processLikeEscape(SQLTextTree.EscapeNode escape) throws SQLException {
        escape.removeAll(SQLTextTree.WhitespacePiece.class, false);
        SQLTextEscapes.checkSize(escape, 2);
        return SQLTextEscapeFunctions.sequence("ESCAPE", SQLTextEscapeFunctions.space(), SQLTextEscapes.getNode(escape, 1, SQLTextTree.Node.class));
    }

    private static void checkSize(SQLTextTree.CompositeNode comp, int ... sizes) throws SQLException {
        SQLTextEscapes.checkSize(comp.nodes, comp.getStartPos(), sizes);
    }

    private static void checkSize(List<SQLTextTree.Node> nodes, int startPos, int ... sizes) throws SQLException {
        for (int size : sizes) {
            if (nodes.size() != size) continue;
            return;
        }
        throw new SQLException("Invalid escape syntax (" + startPos + ")", "Syntax Error");
    }

    private static void checkLiteralNode(SQLTextTree.CompositeNode comp, int index, String text) throws SQLException {
        SQLTextEscapes.checkLiteralNode(SQLTextEscapes.getNode(comp, index, SQLTextTree.Node.class), text);
    }

    private static void checkLiteralNode(SQLTextTree.Node test, String text) throws SQLException {
        if (!test.toString().equalsIgnoreCase(text)) {
            throw new SQLException("Invalid escape (" + test.getStartPos() + ")", "Syntax Error");
        }
    }

    private static <T extends SQLTextTree.Node> T getNode(SQLTextTree.CompositeNode comp, int idx, Class<T> nodeType) throws SQLException {
        SQLTextTree.Node node = comp.get(idx);
        if (!nodeType.isInstance(node)) {
            throw new SQLException("invalid escape (" + comp.getStartPos() + ")", "Syntax Error");
        }
        return (T)((SQLTextTree.Node)nodeType.cast(node));
    }

    private static <T extends SQLTextTree.Node, U extends SQLTextTree.Node> U getNodeNotOf(SQLTextTree.CompositeNode comp, int idx, Class<T> notNodeType, Class<U> nodeType) throws SQLException {
        SQLTextTree.Node node = null;
        while (idx < comp.getNodeCount() && notNodeType.isInstance(node = comp.get(idx))) {
            ++idx;
        }
        return (U)((SQLTextTree.Node)nodeType.cast(node));
    }

    private static List<SQLTextTree.Node> split(SQLTextTree.CompositeNode comp, boolean includeMatches, String ... matches) {
        return SQLTextEscapes.split(comp.nodes, comp.getStartPos(), includeMatches, matches);
    }

    private static List<SQLTextTree.Node> split(List<SQLTextTree.Node> nodes, int startPos, boolean includeMatches, String ... matches) {
        List<String> matchList = Arrays.asList(matches);
        if (nodes.size() == 0) {
            return Collections.emptyList();
        }
        SQLTextTree.CompositeNode current = new SQLTextTree.CompositeNode(startPos);
        ArrayList<SQLTextTree.Node> comps = new ArrayList<SQLTextTree.Node>();
        for (SQLTextTree.Node node : nodes) {
            if (node instanceof SQLTextTree.PieceNode && matchList.contains(((SQLTextTree.PieceNode)node).getText().toUpperCase())) {
                current.trim();
                if (current.getNodeCount() > 0) {
                    comps.add(current);
                    current = new SQLTextTree.CompositeNode(node.getEndPos());
                }
                if (!includeMatches) continue;
                comps.add(node);
                continue;
            }
            current.add(node);
        }
        current.trim();
        if (current.getNodeCount() > 0) {
            comps.add(current);
        }
        return comps;
    }
}

