/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.protocol;

import com.impossibl.postgres.protocol.ResultField;
import com.impossibl.postgres.protocol.UpdatableRowData;
import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.types.Type;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.AbstractReferenceCounted;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import java.io.IOException;

public class FieldBuffersRowData
extends AbstractReferenceCounted
implements UpdatableRowData,
ReferenceCounted {
    private ByteBuf[] fieldBuffers;
    private ByteBufAllocator alloc;

    public FieldBuffersRowData(ResultField[] fields, ByteBufAllocator alloc) {
        this(new ByteBuf[fields.length], alloc);
    }

    public FieldBuffersRowData(ByteBuf[] fieldBuffers, ByteBufAllocator alloc) {
        this.fieldBuffers = fieldBuffers;
        this.alloc = alloc;
    }

    @Override
    public int getFieldCount() {
        return this.fieldBuffers.length;
    }

    @Override
    public Object getField(int fieldIdx, ResultField field, Context context, Class<?> targetClass, Object targetContext) throws IOException {
        Object result;
        Type type = context.getRegistry().resolve(field.getTypeRef());
        ByteBuf fieldBuffer = this.fieldBuffers[fieldIdx];
        fieldBuffer.resetReaderIndex();
        switch (field.getFormat()) {
            case Text: {
                String fieldStr = fieldBuffer.toString(context.getCharset());
                Type.Codec.Decoder<String> decoder = type.getTextCodec().getDecoder();
                result = decoder.decode(context, type, field.getTypeLength(), field.getTypeModifier(), fieldStr, targetClass, targetContext);
                break;
            }
            case Binary: {
                Type.Codec.Decoder<ByteBuf> decoder = type.getBinaryCodec().getDecoder();
                result = decoder.decode(context, type, field.getTypeLength(), field.getTypeModifier(), fieldBuffer, targetClass, targetContext);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return result;
    }

    @Override
    public void updateField(int columnIndex, ResultField field, Context context, Object source, Object sourceContext) throws IOException {
        ByteBuf byteBuf = this.fieldBuffers[columnIndex];
        if (byteBuf == null) {
            if (source == null) {
                return;
            }
            this.fieldBuffers[columnIndex] = byteBuf = this.alloc.buffer();
        } else {
            byteBuf.resetReaderIndex().resetWriterIndex();
        }
        if (source == null) {
            ReferenceCountUtil.release(byteBuf);
            this.fieldBuffers[columnIndex] = null;
            return;
        }
        Type type = context.getRegistry().resolve(field.getTypeRef());
        switch (field.getFormat()) {
            case Text: {
                StringBuilder out = new StringBuilder();
                type.getTextCodec().getEncoder().encode(context, type, source, sourceContext, out);
                ByteBufUtil.writeUtf8(byteBuf, (CharSequence)out);
                break;
            }
            case Binary: {
                type.getBinaryCodec().getEncoder().encode(context, type, source, sourceContext, byteBuf);
            }
        }
    }

    @Override
    public ByteBuf[] getFieldBuffers() {
        return this.fieldBuffers;
    }

    @Override
    protected void deallocate() {
        for (ByteBuf fieldBuffer : this.fieldBuffers) {
            ReferenceCountUtil.release(fieldBuffer);
        }
    }

    @Override
    public FieldBuffersRowData touch(Object hint) {
        for (ByteBuf fieldBuffer : this.fieldBuffers) {
            ReferenceCountUtil.touch(fieldBuffer, hint);
        }
        return this;
    }

    @Override
    public UpdatableRowData duplicateForUpdate() {
        ByteBuf[] fieldBuffers;
        for (ByteBuf fieldBuffer : fieldBuffers = (ByteBuf[])this.fieldBuffers.clone()) {
            ReferenceCountUtil.retain(fieldBuffer);
        }
        return new FieldBuffersRowData(fieldBuffers, this.alloc);
    }
}

