/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.protocol.sasl.scram.message;

import com.impossibl.postgres.protocol.sasl.scram.ScramAttributeValue;
import com.impossibl.postgres.protocol.sasl.scram.ScramAttributes;
import com.impossibl.postgres.protocol.sasl.scram.ScramStringFormatting;
import com.impossibl.postgres.protocol.sasl.scram.gssapi.Gs2Header;
import com.impossibl.postgres.protocol.sasl.scram.util.Preconditions;
import com.impossibl.postgres.protocol.sasl.scram.util.StringWritable;
import com.impossibl.postgres.protocol.sasl.scram.util.StringWritableCsv;
import java.nio.charset.StandardCharsets;

public class ClientFinalMessage
implements StringWritable {
    private final byte[] cbindInput;
    private final String nonce;
    private final byte[] proof;

    private static byte[] generateCBindInput(Gs2Header gs2Header, byte[] cbindData) {
        StringBuffer sb = new StringBuffer();
        gs2Header.writeTo(sb).append(',');
        byte[] cbindInput = sb.toString().getBytes(StandardCharsets.US_ASCII);
        if (null != cbindData) {
            byte[] cbindInputNew = new byte[cbindInput.length + cbindData.length];
            System.arraycopy(cbindInput, 0, cbindInputNew, 0, cbindInput.length);
            System.arraycopy(cbindData, 0, cbindInputNew, cbindInput.length, cbindData.length);
            cbindInput = cbindInputNew;
        }
        return cbindInput;
    }

    public ClientFinalMessage(Gs2Header gs2Header, byte[] cbindData, String nonce, byte[] proof) {
        this.cbindInput = ClientFinalMessage.generateCBindInput(Preconditions.checkNotNull(gs2Header, "gs2Header"), cbindData);
        this.nonce = Preconditions.checkNotEmpty(nonce, "nonce");
        this.proof = Preconditions.checkNotNull(proof, "proof");
    }

    private static StringBuffer writeToWithoutProof(StringBuffer sb, byte[] cbindInput, String nonce) {
        return StringWritableCsv.writeTo(sb, new ScramAttributeValue(ScramAttributes.CHANNEL_BINDING, ScramStringFormatting.base64Encode(cbindInput)), new ScramAttributeValue(ScramAttributes.NONCE, nonce));
    }

    private static StringBuffer writeToWithoutProof(StringBuffer sb, Gs2Header gs2Header, byte[] cbindData, String nonce) {
        return ClientFinalMessage.writeToWithoutProof(sb, ClientFinalMessage.generateCBindInput(Preconditions.checkNotNull(gs2Header, "gs2Header"), cbindData), nonce);
    }

    public static StringBuffer writeToWithoutProof(Gs2Header gs2Header, byte[] cbindData, String nonce) {
        return ClientFinalMessage.writeToWithoutProof(new StringBuffer(), gs2Header, cbindData, nonce);
    }

    @Override
    public StringBuffer writeTo(StringBuffer sb) {
        ClientFinalMessage.writeToWithoutProof(sb, this.cbindInput, this.nonce);
        return StringWritableCsv.writeTo(sb, null, new ScramAttributeValue(ScramAttributes.CLIENT_PROOF, ScramStringFormatting.base64Encode(this.proof)));
    }

    public String toString() {
        return this.writeTo(new StringBuffer()).toString();
    }
}

