/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.protocol.ssl;

import com.impossibl.postgres.protocol.ssl.ConfiguredCallbackHandler;
import com.impossibl.postgres.protocol.ssl.NonValidatingTrustManager;
import com.impossibl.postgres.protocol.ssl.OnDemandKeyManager;
import com.impossibl.postgres.protocol.ssl.SSLMode;
import com.impossibl.postgres.system.Configuration;
import com.impossibl.postgres.system.SystemSettings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.Collection;
import java.util.Iterator;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.security.auth.callback.CallbackHandler;

public class SSLEngineFactory {
    private static final String TRUST_MANAGER_FACTORY_TYPE = "PKIX";
    private static final String SSL_PROTOCOL = "TLS";
    private static final String KEY_STORE_TYPE = "JKS";
    private static final String CERTIFICATE_FACTORY_TYPE = "X.509";

    public static SSLEngine create(SSLMode sslMode, Configuration config) throws IOException {
        SSLContext sslContext;
        TrustManager[] trustManagers;
        CallbackHandler sslPasswordCallback;
        boolean sslFileIsDefault = false;
        String sslCertFile = config.getSetting(SystemSettings.SSL_CRT_FILE);
        sslFileIsDefault = sslFileIsDefault || SystemSettings.SSL_CRT_FILE.getDefault().equals(sslCertFile);
        String sslKeyFile = config.getSetting(SystemSettings.SSL_KEY_FILE);
        sslFileIsDefault = sslFileIsDefault || SystemSettings.SSL_KEY_FILE.getDefault().equals(sslKeyFile);
        Class sslPasswordCallbackClass = config.getSetting(SystemSettings.SSL_KEY_PASSWORD_CALLBACK);
        try {
            sslPasswordCallback = (CallbackHandler)sslPasswordCallbackClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IOException("Cannot instantiate provided password callback: " + sslPasswordCallbackClass.getName());
        }
        if (sslPasswordCallback instanceof ConfiguredCallbackHandler) {
            ((ConfiguredCallbackHandler)sslPasswordCallback).init(config);
        }
        OnDemandKeyManager keyManager = new OnDemandKeyManager(sslCertFile, sslKeyFile, sslPasswordCallback, sslFileIsDefault);
        if (sslMode == SSLMode.VerifyCa || sslMode == SSLMode.VerifyFull) {
            KeyStore keyStore;
            TrustManagerFactory trustManagerFactory;
            try {
                trustManagerFactory = TrustManagerFactory.getInstance(TRUST_MANAGER_FACTORY_TYPE);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("trust manager not available", e);
            }
            try {
                keyStore = KeyStore.getInstance(KEY_STORE_TYPE);
            }
            catch (KeyStoreException e) {
                throw new RuntimeException("keystore not available", e);
            }
            String sslRootCertFile = config.getSetting(SystemSettings.SSL_CA_CRT_FILE);
            if (SystemSettings.SSL_CA_CRT_FILE.getDefault().equals(sslRootCertFile)) {
                sslRootCertFile = config.getSetting(SystemSettings.SSL_HOME_DIR) + File.separator + sslRootCertFile;
            }
            try (FileInputStream sslRootCertInputStream = new FileInputStream(sslRootCertFile);){
                try {
                    CertificateFactory certificateFactory = CertificateFactory.getInstance(CERTIFICATE_FACTORY_TYPE);
                    Collection<? extends Certificate> certificates = certificateFactory.generateCertificates(sslRootCertInputStream);
                    keyStore.load(null, null);
                    Iterator<? extends Certificate> certificatesIter = certificates.iterator();
                    int i = 0;
                    while (certificatesIter.hasNext()) {
                        keyStore.setCertificateEntry("cert" + i, certificatesIter.next());
                        ++i;
                    }
                    trustManagerFactory.init(keyStore);
                }
                catch (GeneralSecurityException e) {
                    throw new IOException("loading SSL root certificate failed", e);
                }
            }
            catch (FileNotFoundException e) {
                throw new IOException("cannot not open SSL root certificate file " + sslRootCertFile, e);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            trustManagers = trustManagerFactory.getTrustManagers();
        } else {
            trustManagers = new TrustManager[]{new NonValidatingTrustManager()};
        }
        try {
            sslContext = SSLContext.getInstance(SSL_PROTOCOL);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("ssl context not available", e);
        }
        try {
            sslContext.init(new KeyManager[]{keyManager}, trustManagers, null);
        }
        catch (KeyManagementException e) {
            throw new IOException("ssl context initialization error", e);
        }
        SSLEngine sslEngine = sslContext.createSSLEngine();
        sslEngine.setUseClientMode(true);
        return sslEngine;
    }
}

