/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.protocol.v30;

import com.impossibl.postgres.protocol.FieldFormat;
import com.impossibl.postgres.protocol.FieldFormatRef;
import com.impossibl.postgres.protocol.FieldFormats;
import com.impossibl.postgres.protocol.Notice;
import com.impossibl.postgres.protocol.RequestExecutor;
import com.impossibl.postgres.protocol.ResultField;
import com.impossibl.postgres.protocol.RowDataSet;
import com.impossibl.postgres.protocol.ServerObjectType;
import com.impossibl.postgres.protocol.TransactionStatus;
import com.impossibl.postgres.protocol.TypeRef;
import com.impossibl.postgres.protocol.v30.BufferRowData;
import com.impossibl.postgres.protocol.v30.ProtocolChannel;
import com.impossibl.postgres.protocol.v30.ProtocolHandler;
import com.impossibl.postgres.protocol.v30.ServerRequest;
import com.impossibl.postgres.system.Empty;
import com.impossibl.postgres.system.NoticeException;
import io.netty.buffer.ByteBuf;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

class ExecuteQueryRequest
implements ServerRequest {
    private String sql;
    private String portalName;
    private FieldFormatRef[] parameterFormats;
    private ByteBuf[] parameterBuffers;
    private FieldFormatRef[] resultFieldFormats;
    private int maxRows;
    private RequestExecutor.ExtendedQueryHandler handler;
    private TypeRef[] describedParameterTypes;
    private ResultField[] describedResultFields;
    private RowDataSet rows;
    private List<Notice> notices;

    ExecuteQueryRequest(String sql, String portalName, FieldFormatRef[] parameterFormats, ByteBuf[] parameterBuffers, FieldFormatRef[] resultFieldFormats, int maxRows, RequestExecutor.ExtendedQueryHandler handler) {
        this.sql = sql;
        this.portalName = portalName;
        this.parameterFormats = parameterFormats;
        this.parameterBuffers = parameterBuffers;
        this.resultFieldFormats = resultFieldFormats;
        this.maxRows = maxRows;
        this.handler = handler;
        this.describedParameterTypes = Empty.EMPTY_TYPES;
        this.describedResultFields = Empty.EMPTY_FIELDS;
        this.rows = new RowDataSet();
        this.notices = new ArrayList<Notice>();
    }

    private boolean isSynchronized() {
        return this.maxRows == 0;
    }

    @Override
    public ProtocolHandler createHandler() {
        return new Handler();
    }

    @Override
    public void execute(ProtocolChannel channel) throws IOException {
        channel.writeParse(null, this.sql, Empty.EMPTY_TYPES).writeDescribe(ServerObjectType.Statement, null).writeBind(this.portalName, null, this.parameterFormats, this.parameterBuffers, this.resultFieldFormats).writeExecute(this.portalName, this.maxRows);
        if (!this.isSynchronized()) {
            channel.writeFlush();
        } else {
            channel.writeSync();
        }
        channel.flush();
    }

    static /* synthetic */ TypeRef[] access$102(ExecuteQueryRequest x0, TypeRef[] x1) {
        x0.describedParameterTypes = x1;
        return x1;
    }

    static /* synthetic */ ResultField[] access$202(ExecuteQueryRequest x0, ResultField[] x1) {
        x0.describedResultFields = x1;
        return x1;
    }

    private class Handler
    implements ProtocolHandler.ParameterDescriptions,
    ProtocolHandler.RowDescription,
    ProtocolHandler.ParseComplete,
    ProtocolHandler.BindComplete,
    ProtocolHandler.NoData,
    ProtocolHandler.DataRow,
    ProtocolHandler.EmptyQuery,
    ProtocolHandler.PortalSuspended,
    ProtocolHandler.CommandComplete,
    ProtocolHandler.ReportNotice,
    ProtocolHandler.CommandError,
    ProtocolHandler.ReadyForQuery {
        private Handler() {
        }

        public String toString() {
            return "Execute Query";
        }

        @Override
        public ProtocolHandler.Action notice(Notice notice) {
            ExecuteQueryRequest.this.notices.add(notice);
            return ProtocolHandler.Action.Resume;
        }

        @Override
        public ProtocolHandler.Action bindComplete() {
            return ProtocolHandler.Action.Resume;
        }

        @Override
        public ProtocolHandler.Action parameterDescriptions(TypeRef[] types) {
            ExecuteQueryRequest.access$102(ExecuteQueryRequest.this, types);
            return ProtocolHandler.Action.Resume;
        }

        @Override
        public ProtocolHandler.Action rowDescription(ResultField[] fields) {
            ExecuteQueryRequest.access$202(ExecuteQueryRequest.this, fields);
            FieldFormat[] effectiveFormats = ExecuteQueryRequest.this.resultFieldFormats == null || ExecuteQueryRequest.this.resultFieldFormats.length == 0 ? FieldFormats.REQUEST_ALL_BINARY : ExecuteQueryRequest.this.resultFieldFormats;
            for (int idx = 0; idx < ExecuteQueryRequest.this.describedResultFields.length; ++idx) {
                FieldFormat format = effectiveFormats[Integer.min(idx, effectiveFormats.length - 1)].getFormat();
                ExecuteQueryRequest.this.describedResultFields[idx].setFormat(format);
            }
            return ProtocolHandler.Action.Resume;
        }

        @Override
        public ProtocolHandler.Action parseComplete() {
            return ProtocolHandler.Action.Resume;
        }

        @Override
        public ProtocolHandler.Action rowData(ByteBuf data) {
            ExecuteQueryRequest.this.rows.add(new BufferRowData(data.retain()));
            return ProtocolHandler.Action.Resume;
        }

        @Override
        public ProtocolHandler.Action noData() {
            return ProtocolHandler.Action.Resume;
        }

        @Override
        public ProtocolHandler.Action portalSuspended() throws IOException {
            try {
                ExecuteQueryRequest.this.handler.handleSuspend(ExecuteQueryRequest.this.describedParameterTypes, ExecuteQueryRequest.this.describedResultFields, ExecuteQueryRequest.this.rows, ExecuteQueryRequest.this.notices);
            }
            finally {
                ReferenceCountUtil.release(ExecuteQueryRequest.this.rows);
            }
            return ProtocolHandler.Action.Complete;
        }

        @Override
        public ProtocolHandler.Action emptyQuery() throws IOException {
            return this.commandComplete(null, null, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ProtocolHandler.Action commandComplete(String command, Long rowsAffected, Long insertedOid) throws IOException {
            try {
                ExecuteQueryRequest.this.handler.handleComplete(command, rowsAffected, insertedOid, ExecuteQueryRequest.this.describedParameterTypes, ExecuteQueryRequest.this.describedResultFields, ExecuteQueryRequest.this.rows, ExecuteQueryRequest.this.notices);
            }
            finally {
                ReferenceCountUtil.release(ExecuteQueryRequest.this.rows);
            }
            return ExecuteQueryRequest.this.isSynchronized() ? ProtocolHandler.Action.Resume : ProtocolHandler.Action.Complete;
        }

        @Override
        public ProtocolHandler.Action error(Notice error) throws IOException {
            try {
                ExecuteQueryRequest.this.handler.handleError(new NoticeException(error), ExecuteQueryRequest.this.notices);
            }
            finally {
                ReferenceCountUtil.release(ExecuteQueryRequest.this.rows);
            }
            return ExecuteQueryRequest.this.isSynchronized() ? ProtocolHandler.Action.Resume : ProtocolHandler.Action.Complete;
        }

        @Override
        public ProtocolHandler.Action readyForQuery(TransactionStatus txnStatus) throws IOException {
            ExecuteQueryRequest.this.handler.handleReady(txnStatus);
            return ProtocolHandler.Action.Complete;
        }

        @Override
        public void exception(Throwable cause) throws IOException {
            try {
                ExecuteQueryRequest.this.handler.handleError(cause, ExecuteQueryRequest.this.notices);
            }
            finally {
                ReferenceCountUtil.release(ExecuteQueryRequest.this.rows);
            }
        }
    }
}

