/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.protocol.v30;

import com.impossibl.postgres.protocol.Notice;
import com.impossibl.postgres.protocol.RequestExecutor;
import com.impossibl.postgres.protocol.RowDataSet;
import com.impossibl.postgres.protocol.TransactionStatus;
import com.impossibl.postgres.protocol.v30.BufferRowData;
import com.impossibl.postgres.protocol.v30.ProtocolChannel;
import com.impossibl.postgres.protocol.v30.ProtocolHandler;
import com.impossibl.postgres.protocol.v30.ServerRequest;
import com.impossibl.postgres.system.NoticeException;
import io.netty.buffer.ByteBuf;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ResumePortalRequest
implements ServerRequest {
    private String portalName;
    private int maxRows;
    private RequestExecutor.ResumeHandler handler;
    private RowDataSet rows;
    private List<Notice> notices;

    ResumePortalRequest(String portalName, int maxRows, RequestExecutor.ResumeHandler handler) {
        this.portalName = portalName;
        this.maxRows = maxRows;
        this.handler = handler;
        this.rows = new RowDataSet();
        this.notices = new ArrayList<Notice>();
    }

    boolean isSynced() {
        return this.maxRows < 1;
    }

    @Override
    public Handler createHandler() {
        return new Handler();
    }

    @Override
    public void execute(ProtocolChannel channel) throws IOException {
        channel.writeExecute(this.portalName, this.maxRows);
        if (this.isSynced()) {
            channel.writeSync();
        } else {
            channel.writeFlush();
        }
        channel.flush();
    }

    private class Handler
    implements ProtocolHandler.DataRow,
    ProtocolHandler.EmptyQuery,
    ProtocolHandler.PortalSuspended,
    ProtocolHandler.CommandComplete,
    ProtocolHandler.ReadyForQuery,
    ProtocolHandler.CommandError {
        private Handler() {
        }

        public String toString() {
            return "Resume Portal";
        }

        @Override
        public ProtocolHandler.Action rowData(ByteBuf data) {
            ResumePortalRequest.this.rows.add(new BufferRowData(data.retain()));
            return ProtocolHandler.Action.Resume;
        }

        @Override
        public ProtocolHandler.Action portalSuspended() throws IOException {
            try {
                ResumePortalRequest.this.handler.handleSuspend(ResumePortalRequest.this.rows, ResumePortalRequest.this.notices);
            }
            finally {
                ReferenceCountUtil.release(ResumePortalRequest.this.rows);
            }
            return ProtocolHandler.Action.Complete;
        }

        @Override
        public ProtocolHandler.Action emptyQuery() throws IOException {
            return this.commandComplete(null, null, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ProtocolHandler.Action commandComplete(String command, Long rowsAffected, Long insertedOid) throws IOException {
            try {
                ResumePortalRequest.this.handler.handleComplete(command, rowsAffected, insertedOid, ResumePortalRequest.this.rows, ResumePortalRequest.this.notices);
            }
            finally {
                ReferenceCountUtil.release(ResumePortalRequest.this.rows);
            }
            return ResumePortalRequest.this.isSynced() ? ProtocolHandler.Action.Resume : ProtocolHandler.Action.Complete;
        }

        @Override
        public ProtocolHandler.Action error(Notice error) throws IOException {
            try {
                ResumePortalRequest.this.handler.handleError(new NoticeException(error), ResumePortalRequest.this.notices);
            }
            finally {
                ReferenceCountUtil.release(ResumePortalRequest.this.rows);
            }
            return ResumePortalRequest.this.isSynced() ? ProtocolHandler.Action.Resume : ProtocolHandler.Action.Complete;
        }

        @Override
        public ProtocolHandler.Action readyForQuery(TransactionStatus txnStatus) {
            return ProtocolHandler.Action.Complete;
        }

        @Override
        public void exception(Throwable cause) throws IOException {
            try {
                ResumePortalRequest.this.handler.handleError(cause, ResumePortalRequest.this.notices);
            }
            finally {
                ReferenceCountUtil.release(ResumePortalRequest.this.rows);
            }
        }
    }
}

