/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.ConversionException;
import com.impossibl.postgres.system.procs.NumericBinaryDecoder;
import com.impossibl.postgres.system.procs.NumericBinaryEncoder;
import com.impossibl.postgres.system.procs.NumericTextDecoder;
import com.impossibl.postgres.system.procs.NumericTextEncoder;
import com.impossibl.postgres.system.procs.SimpleProcProvider;
import com.impossibl.postgres.types.Type;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.text.ParseException;

public class Float8s
extends SimpleProcProvider {
    public Float8s() {
        super((Type.Codec.Encoder<StringBuilder>)new TxtEncoder(), (Type.Codec.Decoder<CharSequence>)new TxtDecoder(), (Type.Codec.Encoder<ByteBuf>)new BinEncoder(), (Type.Codec.Decoder<ByteBuf>)new BinDecoder(), "float8");
    }

    private static Double convertStringInput(Context context, String value) throws ConversionException {
        try {
            return context.getClientDecimalFormatter().parse(value).doubleValue();
        }
        catch (ParseException e) {
            throw new ConversionException("Invalid Long", e);
        }
    }

    private static String convertStringOutput(Context context, Number number) {
        return context.getClientDecimalFormatter().format(number);
    }

    static class TxtEncoder
    extends NumericTextEncoder<Double> {
        TxtEncoder() {
            super((x$0, x$1) -> Float8s.convertStringInput(x$0, x$1), val -> val != false ? 1.0 : 0.0, Number::doubleValue);
        }

        @Override
        public Class<Double> getDefaultClass() {
            return Double.class;
        }

        @Override
        protected void encodeNativeValue(Context context, Type type, Double value, Object sourceContext, StringBuilder buffer) throws IOException {
            buffer.append(value);
        }
    }

    static class TxtDecoder
    extends NumericTextDecoder<Double> {
        TxtDecoder() {
            super((Context x$0, N x$1) -> Float8s.convertStringOutput(x$0, x$1));
        }

        @Override
        public Class<Double> getDefaultClass() {
            return Double.class;
        }

        @Override
        protected Double decodeNativeValue(Context context, Type type, Short typeLength, Integer typeModifier, CharSequence buffer, Class<?> targetClass, Object targetContext) throws IOException, ParseException {
            return Double.valueOf(buffer.toString());
        }
    }

    static class BinEncoder
    extends NumericBinaryEncoder<Double> {
        BinEncoder() {
            super(8, (x$0, x$1) -> Float8s.convertStringInput(x$0, x$1), val -> val != false ? 1.0 : 0.0, Number::doubleValue);
        }

        @Override
        public Class<Double> getDefaultClass() {
            return Double.class;
        }

        @Override
        protected void encodeNativeValue(Context context, Type type, Double value, Object sourceContext, ByteBuf buffer) throws IOException {
            buffer.writeDouble(value);
        }
    }

    static class BinDecoder
    extends NumericBinaryDecoder<Double> {
        BinDecoder() {
            super((Integer)8, (Context x$0, N x$1) -> Float8s.convertStringOutput(x$0, x$1));
        }

        @Override
        public Class<Double> getDefaultClass() {
            return Double.class;
        }

        @Override
        protected Double decodeNativeValue(Context context, Type type, Short typeLength, Integer typeModifier, ByteBuf buffer, Class<?> targetClass, Object targetContext) throws IOException {
            return buffer.readDouble();
        }
    }
}

