/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.ConversionException;
import com.impossibl.postgres.system.procs.AutoConvertingDecoder;
import com.impossibl.postgres.system.procs.ContextConversionFunction;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;

class NumericDecodingConverter<N extends Number>
implements AutoConvertingDecoder.Converter<N> {
    private ContextConversionFunction<N, String> stringConverter;

    NumericDecodingConverter(ContextConversionFunction<N, String> stringConverter) {
        this.stringConverter = stringConverter;
    }

    @Override
    public Object convert(Context context, N decoded, Class<?> targetClass, Object targetContext) throws ConversionException {
        if (targetClass == String.class) {
            return this.stringConverter.apply(context, decoded);
        }
        if (targetClass == BigDecimal.class) {
            BigDecimal decimal;
            if (decoded instanceof Byte || decoded instanceof Short || decoded instanceof Integer || decoded instanceof Long) {
                decimal = BigDecimal.valueOf(((Number)decoded).longValue());
            } else if (decoded instanceof Float) {
                decimal = BigDecimal.valueOf(((Number)decoded).floatValue());
            } else if (decoded instanceof Double) {
                decimal = BigDecimal.valueOf(((Number)decoded).doubleValue());
            } else if (decoded instanceof BigInteger) {
                decimal = new BigDecimal(decoded.toString());
            } else {
                return null;
            }
            if (targetContext != null) {
                int scale = ((Number)targetContext).intValue();
                decimal = decimal.setScale(scale, RoundingMode.HALF_UP);
            }
            return decimal;
        }
        if (targetClass == Double.class || targetClass == Double.TYPE) {
            return ((Number)decoded).doubleValue();
        }
        if (targetClass == Float.class || targetClass == Float.TYPE) {
            return Float.valueOf(((Number)decoded).floatValue());
        }
        if (targetClass == BigInteger.class) {
            if (decoded instanceof BigDecimal) {
                return ((BigDecimal)decoded).toBigInteger();
            }
            return BigInteger.valueOf(((Number)decoded).longValue());
        }
        if (targetClass == Boolean.class || targetClass == Boolean.TYPE) {
            return ((Number)decoded).byteValue() != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (targetClass == Byte.class || targetClass == Byte.TYPE) {
            long longVal = ((Number)decoded).longValue();
            if (longVal < -128L || longVal > 127L) {
                throw new ArithmeticException("Value out of byte range");
            }
            return (byte)longVal;
        }
        if (targetClass == Short.class || targetClass == Short.TYPE) {
            long longVal = ((Number)decoded).longValue();
            if (longVal < -32768L || longVal > 32767L) {
                throw new ArithmeticException("Value out of short range");
            }
            return (short)longVal;
        }
        if (targetClass == Integer.class || targetClass == Integer.TYPE) {
            long longVal = ((Number)decoded).longValue();
            if (longVal < Integer.MIN_VALUE || longVal > Integer.MAX_VALUE) {
                throw new ArithmeticException("Value out of int range");
            }
            return (int)longVal;
        }
        if (targetClass == Long.class || targetClass == Long.TYPE) {
            if (decoded instanceof BigDecimal) {
                return ((BigDecimal)decoded).toBigInteger().longValueExact();
            }
            if (decoded instanceof BigInteger) {
                return ((BigInteger)decoded).longValueExact();
            }
            return ((Number)decoded).longValue();
        }
        return null;
    }
}

