/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.utils;

import com.impossibl.postgres.api.data.Path;
import java.util.Arrays;

public enum GeometryParsers {
    INSTANCE;


    public Path parsePath(CharSequence s) {
        return this.parsePath(s, true);
    }

    public double[][] parsePolygon(CharSequence s) {
        Path path = this.parsePath(s, false);
        return path.getPoints();
    }

    public double[] parseCircle(CharSequence s) {
        int idx;
        boolean delim;
        int max = s.length() - 1;
        int pos = GeometryParsers.consummeSpace(s, 0, true);
        char endDelim = ' ';
        if (s.charAt(pos) == '<') {
            ++pos;
            delim = true;
            endDelim = '>';
        } else if (s.charAt(pos) == '(') {
            idx = pos++;
            if ((pos = GeometryParsers.consummeSpace(s, pos, true)) < max && s.charAt(pos) == '(') {
                delim = true;
                endDelim = ')';
                pos = idx + 1;
            } else {
                delim = false;
                pos = idx;
            }
        } else {
            delim = false;
        }
        double[] point = new double[2];
        pos = this.parsePoint(s, pos, point);
        pos = GeometryParsers.consummeSpace(s, pos, true);
        if (s.charAt(pos) != ',') {
            throw new IllegalArgumentException("near " + pos + " in  " + s + " - " + s.charAt(pos));
        }
        ++pos;
        idx = pos = GeometryParsers.consummeSpace(s, pos, true);
        if (delim) {
            while (pos <= max && s.charAt(pos) != endDelim) {
                ++pos;
            }
            if (idx == pos) {
                throw new IllegalArgumentException("near " + idx + " in  " + s);
            }
        } else {
            pos = this.parseNumber(s, pos);
        }
        double radius = Double.parseDouble(s.subSequence(idx, pos).toString());
        if ((pos = GeometryParsers.consummeSpace(s, pos, false)) < max) {
            throw new IllegalArgumentException("near " + pos + " in  " + s);
        }
        return new double[]{point[0], point[1], radius};
    }

    public double[] parsePoint(CharSequence s) {
        double[] point = new double[2];
        int pos = this.parsePoint(s, 0, point);
        if ((pos = GeometryParsers.consummeSpace(s, pos, false)) < s.length() - 1) {
            throw new IllegalArgumentException("near " + pos + " in  " + s);
        }
        return point;
    }

    public double[] parseBox(CharSequence s) {
        PathResult pr = this.parsePath(false, 2, s, 0);
        int pos = GeometryParsers.consummeSpace(s, pr.pos, false);
        if (pos < s.length() - 1) {
            throw new IllegalArgumentException("near " + pos + " in  " + s);
        }
        return new double[]{pr.p[0][0], pr.p[0][1], pr.p[1][0], pr.p[1][1]};
    }

    public double[] parseLSeg(CharSequence s) {
        PathResult pr = this.parsePath(true, 2, s, 0);
        int pos = GeometryParsers.consummeSpace(s, pr.pos, false);
        if (pos < s.length() - 1) {
            throw new IllegalArgumentException("near " + pos + " in  " + s);
        }
        return new double[]{pr.p[0][0], pr.p[0][1], pr.p[1][0], pr.p[1][1]};
    }

    public double[] parseLine(CharSequence s) {
        double[] result;
        int pos = GeometryParsers.consummeSpace(s, 0, true);
        if (s.charAt(pos) == '{') {
            result = new double[3];
            pos = this.parseLineABC(s, pos, result);
        } else {
            PathResult pr = this.parsePath(true, 2, s, pos);
            if (Arrays.equals(pr.p[0], pr.p[1])) {
                throw new IllegalArgumentException("invalid line specification: must be two distinct points");
            }
            pos = pr.pos;
            result = GeometryParsers.lineConstructPts(pr.p[0], pr.p[1]);
        }
        pos = GeometryParsers.consummeSpace(s, pos, false);
        if (pos < s.length() - 1) {
            throw new IllegalArgumentException("near " + pos + " in  " + s);
        }
        return result;
    }

    private static double[] lineConstructPts(double[] pt1, double[] pt2) {
        double[] lineabc = new double[3];
        if (pt1[0] == pt2[0]) {
            lineabc[0] = -1.0;
            lineabc[1] = 0.0;
            lineabc[2] = pt1[0];
        } else if (pt1[1] == pt2[1]) {
            lineabc[0] = 0.0;
            lineabc[1] = -1.0;
            lineabc[2] = pt1[1];
        } else {
            lineabc[0] = (pt2[1] - pt1[1]) / (pt2[0] - pt1[0]);
            lineabc[1] = -1.0;
            lineabc[2] = pt1[1] - lineabc[0] * pt1[0];
        }
        return lineabc;
    }

    private int parseLineABC(CharSequence s, int pos, double[] abc) {
        if (s.charAt(pos) != '{') {
            throw new IllegalArgumentException("near " + pos + " in  " + s);
        }
        int pos1 = ++pos;
        pos = this.parseNumber(s, pos);
        double a = Double.parseDouble(s.subSequence(pos1, pos).toString());
        if (s.charAt(pos = GeometryParsers.consummeSpace(s, pos, true)) != ',') {
            throw new IllegalArgumentException("near " + pos + " in  " + s);
        }
        ++pos;
        pos1 = pos = GeometryParsers.consummeSpace(s, pos, true);
        pos = this.parseNumber(s, pos);
        double b = Double.parseDouble(s.subSequence(pos1, pos).toString());
        if (a == 0.0 && b == 0.0) {
            throw new IllegalArgumentException("invalid line specification: A and B cannot both be zero");
        }
        if (s.charAt(pos = GeometryParsers.consummeSpace(s, pos, true)) != ',') {
            throw new IllegalArgumentException("near " + pos + " in  " + s);
        }
        ++pos;
        pos1 = pos = GeometryParsers.consummeSpace(s, pos, true);
        pos = this.parseNumber(s, pos);
        double c = Double.parseDouble(s.subSequence(pos1, pos).toString());
        if (s.charAt(pos = GeometryParsers.consummeSpace(s, pos, true)) != '}') {
            throw new IllegalArgumentException("near " + pos + " in  " + s);
        }
        abc[0] = a;
        abc[1] = b;
        abc[2] = c;
        return ++pos;
    }

    private Path parsePath(CharSequence s, boolean acceptopen) {
        int npts = GeometryParsers.pairCount(s, ',');
        if (npts < 0) {
            throw new IllegalArgumentException("invalid input syntax for type path: " + s);
        }
        int pos = GeometryParsers.consummeSpace(s, 0, true);
        int max = s.length() - 1;
        int depth = 0;
        if (s.charAt(pos) == '(' && GeometryParsers.findLastDelim(s, pos, '(') == pos + 1) {
            ++pos;
            ++depth;
        }
        PathResult pr = this.parsePath(acceptopen, npts, s, GeometryParsers.consummeSpace(s, pos, true));
        if (depth != 0) {
            pr.pos = GeometryParsers.consummeSpace(s, pr.pos, true);
            if (s.charAt(pr.pos) != ')') {
                throw new IllegalArgumentException("near " + pr.pos + " in  " + s);
            }
        }
        pr.pos = GeometryParsers.consummeSpace(s, pr.pos, false);
        if (pr.pos < max) {
            throw new IllegalArgumentException("near " + pr.pos + " in  " + s);
        }
        return new Path(pr.p, !pr.isOpen);
    }

    private static int pairCount(CharSequence s, char delim) {
        int ndelim = 0;
        int max = s.length() - 1;
        for (int pos = 0; pos < max; ++pos) {
            if (s.charAt(pos) != delim) continue;
            ++ndelim;
        }
        return ndelim % 2 == 0 ? -1 : (ndelim + 1) / 2;
    }

    public static void main(String ... args) {
        String[] paths;
        String[] lsegs;
        String[] boxes;
        String[] points;
        String[] numbers;
        String[] circles;
        System.out.println("Circles ===========");
        for (String c : circles = new String[]{"124.66, -565.88, 1256.6", "(124.66, -565.88), 1256.6", "((124.66, -565.88), 1256.6)", "<(124.66, -565.88), 1256.6>"}) {
            System.out.println(c + " --> " + Arrays.toString(INSTANCE.parseCircle(c)));
        }
        System.out.println("Numbers ===========");
        for (String n : numbers = new String[]{"99.4", "89E03", "8e-3", "45.3E+45"}) {
            int pos = INSTANCE.parseNumber(n, 0);
            System.out.println(n + " " + pos + " " + n.length() + " " + n.substring(0, pos));
        }
        System.out.println("Points ===========");
        for (String p : points = new String[]{"(100, 100)", "(-343.43, 43.01)", "100.0, 99.4", "(0,0)", "(124, 24343)", "(-113.7, +8989.98)", "(100e+2, 100e-2)", "(-343.43, 43.01)", "100.0e4, 99.4e-2"}) {
            try {
                double[] point = INSTANCE.parsePoint(p);
                System.out.println(p + " --> " + Arrays.toString(point));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        System.out.println("Boxes ===========");
        for (String box : boxes = new String[]{"((678.6,454),(124.6,0))", "(678.6,454),(124.6,0)", "(0,0),(0,0)", "(-678.6, -454),(124.6,1.0)", "-678.6, -454,124.6,1.0", "(10, 20),(100, 120)"}) {
            try {
                double[] b = INSTANCE.parseBox(box);
                System.out.println(box + " --> " + Arrays.toString(b));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        System.out.println("LSegs ===========");
        for (String lseg : lsegs = new String[]{"[(678.6,454),(124.6,0)]", "((678.6,454),(124.6,0))", "(678.6,454),(124.6,0)", "(0,0),(0,0)", "(-678.6, -454),(124.6,1.0)", "-678.6, -454,124.6,1.0", "(10, 20),(100, 120)"}) {
            try {
                double[] b = INSTANCE.parseLSeg(lseg);
                System.out.println(lseg + " --> " + Arrays.toString(b));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        System.out.println("Paths ===========");
        for (String path : paths = new String[]{"[(678.6,454)]", "((678.6,454))", "[(678.6,454),(124.6,0)]", "((678.6,454),(124.6,0))", "(678.6,454),(124.6,0)", "(0,0),(0,0)", "(-678.6, -454),(124.6,1.0)", "-678.6, -454,124.6,1.0", "(10, 20),(100, 120)", "[(678.6,454),(10,89),(124.6,0)]", "((678.6,454),(10,89),(124.6,0))", "(678.6,454),(10,89),(124.6,0)", "(0,0),(10,89),(0,0)", "(-678.6, -454),(10,89),(124.6,1.0)", "-678.6,10,89, -454,124.6,1.0", "(10, 20),(10,89),(100, 120)"}) {
            try {
                Path pr = INSTANCE.parsePath(path);
                System.out.println(path + " --> " + pr);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private static int findLastDelim(CharSequence s, int pos, char delim) {
        int found = -1;
        int max = s.length() - 1;
        while (pos < max) {
            if (s.charAt(pos) == delim) {
                found = pos;
            }
            ++pos;
        }
        return found;
    }

    private PathResult parsePath(boolean opendelim, int npts, CharSequence s, int pos) {
        PathResult pr = new PathResult();
        int depth = 0;
        pr.pos = GeometryParsers.consummeSpace(s, pos, true);
        char c = s.charAt(pr.pos);
        if (c == '[') {
            pr.isOpen = true;
            if (!opendelim) {
                throw new IllegalArgumentException("near " + pr.pos + " in  " + s);
            }
            ++pr.pos;
            ++depth;
            pr.pos = GeometryParsers.consummeSpace(s, pr.pos, true);
        } else if (c == '(') {
            int cp = GeometryParsers.consummeSpace(s, pr.pos + 1, true);
            if (s.charAt(cp) == '(') {
                if (npts <= 1) {
                    throw new IllegalArgumentException("near " + pr.pos + " in  " + s);
                }
                ++depth;
                pr.pos = cp;
            } else if (GeometryParsers.findLastDelim(s, pr.pos, '(') == cp) {
                ++depth;
                pr.pos = cp;
            }
        }
        pr.p = new double[npts][];
        int max = s.length() - 1;
        for (int i = 0; i < npts; ++i) {
            double[] points = new double[2];
            pr.pos = this.parsePoint(s, pr.pos, points);
            pr.pos = GeometryParsers.consummeSpace(s, pr.pos, i < npts - 1);
            if (pr.pos < max && s.charAt(pr.pos) == ',') {
                ++pr.pos;
            }
            pr.p[i] = points;
        }
        while (depth > 0) {
            if (s.charAt(pr.pos) == ')' || s.charAt(pr.pos) == ']' && pr.isOpen && depth == 1) {
                pr.pos = GeometryParsers.consummeSpace(s, ++pr.pos, --depth != 0);
                continue;
            }
            throw new IllegalArgumentException("near " + pr.pos + " in  " + s);
        }
        return pr;
    }

    private int parsePoint(CharSequence s, int pos, double[] p) {
        double p2;
        int max = s.length() - 1;
        pos = GeometryParsers.consummeSpace(s, pos, true);
        boolean delim = false;
        if ('(' == s.charAt(pos)) {
            ++pos;
            delim = true;
        }
        int pos1 = pos = GeometryParsers.consummeSpace(s, pos, true);
        while (pos <= max && ',' != s.charAt(pos)) {
            ++pos;
        }
        double p1 = Double.parseDouble(s.subSequence(pos1, pos).toString());
        ++pos;
        pos1 = pos = GeometryParsers.consummeSpace(s, pos, true);
        if (delim) {
            while (pos <= max && ')' != s.charAt(pos)) {
                ++pos;
            }
            p2 = Double.parseDouble(s.subSequence(pos1, pos).toString());
        } else {
            pos = this.parseNumber(s, pos);
            p2 = Double.parseDouble(s.subSequence(pos1, pos).toString());
        }
        pos = GeometryParsers.consummeSpace(s, pos, delim);
        if (delim) {
            if (s.charAt(pos) != ')') {
                throw new IllegalArgumentException("near " + pos + " in  " + s);
            }
            ++pos;
        }
        p[0] = p1;
        p[1] = p2;
        return pos;
    }

    private static int parseExponent(CharSequence s, int pos) {
        int max = s.length() - 1;
        if (pos >= max) {
            return pos;
        }
        char c = s.charAt(pos);
        if (c == 'e' || c == 'E') {
            if (++pos >= max) {
                throw new NumberFormatException("near " + pos + " in  " + s);
            }
            c = s.charAt(pos);
            if (c == '-' || c == '+') {
                ++pos;
            }
            if (pos > max) {
                throw new NumberFormatException("near " + pos + " in  " + s);
            }
            int initpos = pos;
            while (pos <= max && Character.isDigit(s.charAt(pos))) {
                ++pos;
            }
            if (initpos == pos) {
                throw new NumberFormatException("near " + pos + " in  " + s);
            }
        }
        return pos;
    }

    private int parseNumber(CharSequence s, int pos) {
        int max = s.length() - 1;
        switch (s.charAt(pos)) {
            case '+': 
            case '-': 
            case '.': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                boolean dot = s.charAt(pos) == '.';
                ++pos;
                while (pos <= max) {
                    char c = s.charAt(pos);
                    if ('.' == c) {
                        if (dot) {
                            throw new NumberFormatException("near " + pos + " in  " + s);
                        }
                        dot = true;
                    } else if ((c < '0' || c > '9') && !Character.isDigit(c)) break;
                    ++pos;
                }
                if (pos > max) break;
                pos = GeometryParsers.parseExponent(s, pos);
            }
        }
        return pos;
    }

    private static int consummeSpace(CharSequence s, int pos, boolean checkEOS) {
        int max = s.length() - 1;
        while (pos <= max && Character.isSpaceChar(s.charAt(pos))) {
            ++pos;
        }
        if (checkEOS && pos > max) {
            throw new IllegalArgumentException("near " + pos + " in  " + s);
        }
        return pos;
    }

    static class PathResult {
        int pos;
        double[][] p;
        boolean isOpen = false;

        PathResult() {
        }
    }
}

