/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.datetime;

import com.impossibl.postgres.datetime.DateTimeFormat;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.time.chrono.IsoChronology;
import java.time.chrono.IsoEra;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;

public class ISOTimestampFormat
implements DateTimeFormat {
    private Parser parser = new Parser();
    private Printer printer = new Printer();
    private static final DateTimeFormatter FMT = new DateTimeFormatterBuilder().parseCaseInsensitive().appendValue(ChronoField.YEAR_OF_ERA, 4, 10, SignStyle.EXCEEDS_PAD).parseLenient().appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral(' ').append(DateTimeFormatter.ISO_LOCAL_TIME).optionalStart().appendOffset("+HH:mm", "+00").optionalEnd().toFormatter().withChronology(IsoChronology.INSTANCE);
    private static final DateTimeFormatter FMT_ERA = new DateTimeFormatterBuilder().parseCaseInsensitive().appendValue(ChronoField.YEAR_OF_ERA, 4, 10, SignStyle.EXCEEDS_PAD).parseLenient().appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral(' ').append(DateTimeFormatter.ISO_LOCAL_TIME).optionalStart().appendOffset("+HH:mm", "+00").optionalEnd().optionalStart().appendPattern(" GG").toFormatter().withChronology(IsoChronology.INSTANCE);

    @Override
    public Parser getParser() {
        return this.parser;
    }

    @Override
    public Printer getPrinter() {
        return this.printer;
    }

    public static class Parser
    implements DateTimeFormat.Parser {
        @Override
        public TemporalAccessor parse(CharSequence text) {
            return FMT_ERA.parseBest(text, ZonedDateTime::from, OffsetDateTime::from, LocalDateTime::from);
        }
    }

    static class Printer
    implements DateTimeFormat.Printer {
        Printer() {
        }

        @Override
        public String format(Temporal temporal) {
            if (temporal.get(ChronoField.ERA) != IsoEra.CE.getValue()) {
                return FMT_ERA.format(temporal);
            }
            return FMT.format(temporal);
        }
    }
}

