/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import java.util.concurrent.atomic.AtomicReference;

abstract class ExecutionTimerTask
implements Runnable {
    private final AtomicReference<State> state = new AtomicReference<State>(State.NotStarted);
    private Thread thread;

    ExecutionTimerTask() {
    }

    protected abstract void go();

    boolean isCancelled() {
        return this.state.get() != State.Running || this.thread.isInterrupted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.thread = Thread.currentThread();
            if (!this.state.compareAndSet(State.NotStarted, State.Running)) {
                return;
            }
            this.go();
        }
        catch (Throwable throwable) {
            this.state.set(State.Completed);
            AtomicReference<State> atomicReference = this.state;
            synchronized (atomicReference) {
                this.state.notify();
            }
        }
        finally {
            this.state.set(State.Completed);
            AtomicReference<State> atomicReference = this.state;
            synchronized (atomicReference) {
                this.state.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancel() {
        if (this.state.getAndSet(State.Cancelling) == State.Running) {
            this.thread.interrupt();
            AtomicReference<State> atomicReference = this.state;
            synchronized (atomicReference) {
                while (this.state.get() == State.Cancelling) {
                    try {
                        this.state.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    static enum State {
        NotStarted,
        Running,
        Cancelling,
        Completed;

    }
}

