/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.protocol.ssl;

import com.impossibl.postgres.jdbc.PGSQLSimpleException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.Socket;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.sql.SQLException;
import java.util.Collection;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.x500.X500Principal;

public class OnDemandKeyManager
extends X509ExtendedKeyManager {
    private X509Certificate[] certificates = null;
    private PrivateKey key = null;
    private String certfile;
    private String keyfileName;
    private CallbackHandler cbh;
    private boolean defaultfile;
    private PGSQLSimpleException error = null;

    public OnDemandKeyManager(String certfile, String keyfile, CallbackHandler cbh, boolean defaultfile) {
        this.certfile = certfile;
        this.keyfileName = keyfile;
        this.cbh = cbh;
        this.defaultfile = defaultfile;
    }

    public void throwKeyManagerException() throws SQLException {
        if (this.error != null) {
            throw this.error;
        }
    }

    @Override
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        if (this.certfile == null) {
            return null;
        }
        if (issuers == null || issuers.length == 0) {
            return "user";
        }
        X509Certificate[] certchain = this.getCertificateChain("user");
        if (certchain == null) {
            return null;
        }
        X500Principal ourissuer = certchain[certchain.length - 1].getIssuerX500Principal();
        boolean found = false;
        for (int i = 0; i < issuers.length; ++i) {
            if (!ourissuer.equals(issuers[i])) continue;
            found = true;
        }
        return found ? "user" : null;
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        return null;
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        if (this.certificates == null && this.certfile != null) {
            Collection<? extends Certificate> certs;
            CertificateFactory cf;
            try {
                cf = CertificateFactory.getInstance("X.509");
            }
            catch (CertificateException ex) {
                this.error = new PGSQLSimpleException("Could not find a java cryptographic algorithm: X.509 CertificateFactory not available");
                return null;
            }
            try {
                certs = cf.generateCertificates(new FileInputStream(this.certfile));
            }
            catch (FileNotFoundException ioex) {
                if (!this.defaultfile) {
                    this.error = new PGSQLSimpleException("Could not open SSL certificate file " + this.certfile, ioex);
                }
                return null;
            }
            catch (CertificateException gsex) {
                this.error = new PGSQLSimpleException("Loading the SSL certificate " + this.certfile + " into a KeyManager failed", gsex);
                return null;
            }
            this.certificates = certs.toArray(new X509Certificate[certs.size()]);
        }
        return this.certificates;
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        String[] stringArray;
        String alias = this.chooseClientAlias(new String[]{keyType}, issuers, null);
        if (alias == null) {
            stringArray = new String[]{};
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = alias;
        }
        return stringArray;
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        block20: {
            try {
                byte[] keydata;
                if (this.key != null || this.keyfileName == null) break block20;
                if (this.certificates == null && this.getCertificateChain("user") == null) {
                    return null;
                }
                File keyf = new File(this.keyfileName);
                try (FileInputStream fl = new FileInputStream(this.keyfileName);){
                    keydata = new byte[(int)keyf.length()];
                    fl.read(keydata, 0, (int)keyf.length());
                }
                catch (FileNotFoundException ex) {
                    if (!this.defaultfile) {
                        throw ex;
                    }
                    return null;
                }
                KeyFactory keyFactory = KeyFactory.getInstance(this.certificates[0].getPublicKey().getAlgorithm());
                try {
                    PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keydata);
                    this.key = keyFactory.generatePrivate(pkcs8KeySpec);
                }
                catch (InvalidKeySpecException ex) {
                    Cipher cipher;
                    EncryptedPrivateKeyInfo ePKInfo = new EncryptedPrivateKeyInfo(keydata);
                    try {
                        cipher = Cipher.getInstance(ePKInfo.getAlgName());
                    }
                    catch (NoSuchPaddingException npex) {
                        throw new NoSuchAlgorithmException(npex.getMessage(), npex);
                    }
                    PasswordCallback pwdcb = new PasswordCallback("Enter SSL password:", false);
                    try {
                        this.cbh.handle(new Callback[]{pwdcb});
                    }
                    catch (UnsupportedCallbackException ucex) {
                        this.error = new PGSQLSimpleException("Could not read password for SSL key file, console is not available", ucex);
                        return null;
                    }
                    try {
                        PBEKeySpec pbeKeySpec = new PBEKeySpec(pwdcb.getPassword());
                        SecretKeyFactory skFac = SecretKeyFactory.getInstance(ePKInfo.getAlgName());
                        SecretKey pbeKey = skFac.generateSecret(pbeKeySpec);
                        AlgorithmParameters algParams = ePKInfo.getAlgParameters();
                        cipher.init(2, (Key)pbeKey, algParams);
                        PKCS8EncodedKeySpec pkcs8KeySpec = ePKInfo.getKeySpec(cipher);
                        this.key = keyFactory.generatePrivate(pkcs8KeySpec);
                    }
                    catch (GeneralSecurityException ikex) {
                        this.error = new PGSQLSimpleException("Could not decrypt SSL key file " + this.keyfileName, ikex);
                        return null;
                    }
                }
            }
            catch (IOException ioex) {
                this.error = new PGSQLSimpleException("Could not read SSL key file " + this.keyfileName, ioex);
            }
            catch (NoSuchAlgorithmException ex) {
                this.error = new PGSQLSimpleException("Could not find a java cryptographic algorithm: " + ex.getMessage(), ex);
                return null;
            }
        }
        return this.key;
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return new String[0];
    }

    @Override
    public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine) {
        return this.chooseClientAlias(keyType, issuers, null);
    }
}

