/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.ConversionException;
import com.impossibl.postgres.system.procs.AutoConvertingBinaryDecoder;
import com.impossibl.postgres.system.procs.AutoConvertingBinaryEncoder;
import com.impossibl.postgres.system.procs.AutoConvertingTextDecoder;
import com.impossibl.postgres.system.procs.AutoConvertingTextEncoder;
import com.impossibl.postgres.system.procs.SimpleProcProvider;
import com.impossibl.postgres.types.Type;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;

public class Bools
extends SimpleProcProvider {
    public Bools() {
        super((Type.Codec.Encoder<StringBuilder>)new TxtEncoder(), (Type.Codec.Decoder<CharSequence>)new TxtDecoder(), (Type.Codec.Encoder<ByteBuf>)new BinEncoder(), (Type.Codec.Decoder<ByteBuf>)new BinDecoder(), "bool");
    }

    private static Boolean convertInput(Context context, Object source, Object sourceContext) throws ConversionException {
        if (source instanceof Boolean) {
            return (Boolean)source;
        }
        if (source instanceof Byte) {
            return (Byte)source != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (source instanceof Short) {
            return (Short)source != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (source instanceof Integer) {
            return (Integer)source != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (source instanceof Long) {
            return (Long)source != 0L ? Boolean.TRUE : Boolean.FALSE;
        }
        if (source instanceof BigInteger) {
            return ((BigInteger)source).compareTo(BigInteger.ZERO) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (source instanceof Float) {
            return ((Float)source).floatValue() != 0.0f ? Boolean.TRUE : Boolean.FALSE;
        }
        if (source instanceof Double) {
            return (Double)source != 0.0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (source instanceof BigDecimal) {
            return ((BigDecimal)source).compareTo(BigDecimal.ZERO) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (source instanceof Character) {
            switch (((Character)source).charValue()) {
                case '0': 
                case 'F': 
                case 'N': 
                case 'f': 
                case 'n': {
                    return false;
                }
                case '1': 
                case 'T': 
                case 'Y': 
                case 't': 
                case 'y': {
                    return true;
                }
            }
            throw new ConversionException("Cannot convert value '" + source + "' to bool");
        }
        if (source instanceof String) {
            String val = (String)source;
            if (val.equalsIgnoreCase("f") || val.equalsIgnoreCase("false") || val.equalsIgnoreCase("n") || val.equalsIgnoreCase("no") || val.equalsIgnoreCase("off") || val.equalsIgnoreCase("0")) {
                return false;
            }
            if (val.equalsIgnoreCase("t") || val.equalsIgnoreCase("true") || val.equalsIgnoreCase("y") || val.equalsIgnoreCase("yes") || val.equalsIgnoreCase("on") || val.equalsIgnoreCase("1")) {
                return true;
            }
            throw new ConversionException("Cannot convert value \"" + val + "\" to bool");
        }
        return null;
    }

    private static Object convertOutput(Context context, Boolean decoded, Class<?> targetClass, Object targetContext) {
        if (targetClass == Boolean.class || targetClass == Boolean.TYPE) {
            return decoded;
        }
        if (targetClass == Byte.class || targetClass == Byte.TYPE) {
            return decoded != false ? (byte)1 : 0;
        }
        if (targetClass == Short.class || targetClass == Short.TYPE) {
            return decoded != false ? (short)1 : 0;
        }
        if (targetClass == Integer.class || targetClass == Integer.TYPE) {
            return decoded != false ? 1 : 0;
        }
        if (targetClass == Long.class || targetClass == Long.TYPE) {
            return decoded != false ? 1L : 0L;
        }
        if (targetClass == BigInteger.class) {
            return decoded != false ? BigInteger.ONE : BigInteger.ZERO;
        }
        if (targetClass == Float.class || targetClass == Float.TYPE) {
            return Float.valueOf(decoded != false ? 1.0f : 0.0f);
        }
        if (targetClass == Double.class || targetClass == Double.TYPE) {
            return decoded != false ? 1.0 : 0.0;
        }
        if (targetClass == BigDecimal.class) {
            return decoded != false ? BigDecimal.ONE : BigDecimal.ZERO;
        }
        if (targetClass == String.class) {
            return decoded != false ? "t" : "f";
        }
        return null;
    }

    static class TxtEncoder
    extends AutoConvertingTextEncoder<Boolean> {
        TxtEncoder() {
            super((Context x$0, Object x$1, Object x$2) -> Bools.convertInput(x$0, x$1, x$2));
        }

        @Override
        public Class<Boolean> getDefaultClass() {
            return Boolean.class;
        }

        @Override
        protected void encodeNativeValue(Context context, Type type, Boolean value, Object sourceContext, StringBuilder buffer) throws IOException {
            buffer.append(value != false ? "t" : "f");
        }
    }

    static class TxtDecoder
    extends AutoConvertingTextDecoder<Boolean> {
        TxtDecoder() {
            super((Context x$0, N x$1, Class<?> x$2, Object x$3) -> Bools.convertOutput(x$0, x$1, x$2, x$3));
        }

        @Override
        public Class<Boolean> getDefaultClass() {
            return Boolean.class;
        }

        @Override
        protected Boolean decodeNativeValue(Context context, Type type, Short typeLength, Integer typeModifier, CharSequence buffer, Class<?> targetClass, Object targetContext) throws IOException {
            switch (buffer.toString().toLowerCase()) {
                case "t": 
                case "true": 
                case "y": 
                case "yes": 
                case "on": 
                case "1": {
                    return true;
                }
                case "f": 
                case "false": 
                case "n": 
                case "no": 
                case "off": 
                case "0": {
                    return false;
                }
            }
            throw new ConversionException("Invalid format for boolean");
        }
    }

    static class BinEncoder
    extends AutoConvertingBinaryEncoder<Boolean> {
        BinEncoder() {
            super((Integer)1, (Context x$0, Object x$1, Object x$2) -> Bools.convertInput(x$0, x$1, x$2));
        }

        @Override
        public Class<Boolean> getDefaultClass() {
            return Boolean.class;
        }

        @Override
        protected void encodeNativeValue(Context context, Type type, Boolean value, Object sourceContext, ByteBuf buffer) throws IOException {
            buffer.writeByte(value != false ? 1 : 0);
        }
    }

    static class BinDecoder
    extends AutoConvertingBinaryDecoder<Boolean> {
        BinDecoder() {
            super((Integer)1, (Context x$0, N x$1, Class<?> x$2, Object x$3) -> Bools.convertOutput(x$0, x$1, x$2, x$3));
        }

        @Override
        public Class<Boolean> getDefaultClass() {
            return Boolean.class;
        }

        @Override
        protected Boolean decodeNativeValue(Context context, Type type, Short typeLength, Integer typeModifier, ByteBuf buffer, Class<?> targetClass, Object targetContext) throws IOException {
            return buffer.readByte() != 0;
        }
    }
}

