/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.ConversionException;
import com.impossibl.postgres.system.procs.NumericBinaryDecoder;
import com.impossibl.postgres.system.procs.NumericBinaryEncoder;
import com.impossibl.postgres.system.procs.NumericTextDecoder;
import com.impossibl.postgres.system.procs.NumericTextEncoder;
import com.impossibl.postgres.system.procs.SimpleProcProvider;
import com.impossibl.postgres.types.Type;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.text.ParseException;

public class Int2s
extends SimpleProcProvider {
    public Int2s() {
        super((Type.Codec.Encoder<StringBuilder>)new TxtEncoder(), (Type.Codec.Decoder<CharSequence>)new TxtDecoder(), (Type.Codec.Encoder<ByteBuf>)new BinEncoder(), (Type.Codec.Decoder<ByteBuf>)new BinDecoder(), "int2");
    }

    private static Short convertStringInput(Context context, String value) throws ConversionException {
        try {
            return context.getClientIntegerFormatter().parse(value).shortValue();
        }
        catch (ParseException e) {
            throw new ConversionException("Invalid Long", e);
        }
    }

    private static String convertStringOutput(Context context, Number number) {
        return context.getClientIntegerFormatter().format(number);
    }

    static class TxtEncoder
    extends NumericTextEncoder<Short> {
        TxtEncoder() {
            super((x$0, x$1) -> Int2s.convertStringInput(x$0, x$1), val -> val != false ? (short)1 : (short)0, Number::shortValue);
        }

        @Override
        public Class<Short> getDefaultClass() {
            return Short.class;
        }

        @Override
        protected void encodeNativeValue(Context context, Type type, Short value, Object sourceContext, StringBuilder buffer) throws IOException {
            buffer.append(value);
        }
    }

    static class TxtDecoder
    extends NumericTextDecoder<Short> {
        TxtDecoder() {
            super((Context x$0, N x$1) -> Int2s.convertStringOutput(x$0, x$1));
        }

        @Override
        public Class<Short> getDefaultClass() {
            return Short.class;
        }

        @Override
        protected Short decodeNativeValue(Context context, Type type, Short typeLength, Integer typeModifier, CharSequence buffer, Class<?> targetClass, Object targetContext) throws IOException, ParseException {
            return Short.valueOf(buffer.toString());
        }
    }

    static class BinEncoder
    extends NumericBinaryEncoder<Short> {
        BinEncoder() {
            super(2, (x$0, x$1) -> Int2s.convertStringInput(x$0, x$1), val -> val != false ? (short)1 : (short)0, Number::shortValue);
        }

        @Override
        public Class<Short> getDefaultClass() {
            return Short.class;
        }

        @Override
        protected void encodeNativeValue(Context context, Type type, Short value, Object sourceContext, ByteBuf buffer) throws IOException {
            buffer.writeShort(value.shortValue());
        }
    }

    static class BinDecoder
    extends NumericBinaryDecoder<Short> {
        BinDecoder() {
            super((Integer)2, (Context x$0, N x$1) -> Int2s.convertStringOutput(x$0, x$1));
        }

        @Override
        public Class<Short> getDefaultClass() {
            return Short.class;
        }

        @Override
        protected Short decodeNativeValue(Context context, Type type, Short typeLength, Integer typeModifier, ByteBuf buffer, Class<?> targetClass, Object targetContext) throws IOException {
            return buffer.readShort();
        }
    }
}

