/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.jdbc.PGBuffersArray;
import com.impossibl.postgres.protocol.FieldFormat;
import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.procs.BaseBinaryDecoder;
import com.impossibl.postgres.system.procs.BaseTextDecoder;
import com.impossibl.postgres.types.NestedArrayType;
import com.impossibl.postgres.types.Type;
import com.impossibl.postgres.utils.CompositeCharSequence;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.CompositeByteBuf;
import java.io.IOException;
import java.sql.Array;

public class NestedArrays {
    public static final BinDecoder BINARY_DECODER = new BinDecoder();
    public static final TxtDecoder TEXT_DECODER = new TxtDecoder();

    static class BinDecoder
    extends BaseBinaryDecoder {
        BinDecoder() {
        }

        @Override
        public Class<?> getDefaultClass() {
            return Array.class;
        }

        @Override
        protected Object decodeValue(Context context, Type type, Short typeLength, Integer typeModifier, ByteBuf buffer, Class<?> targetClass, Object targetContext) throws IOException {
            NestedArrayType atype = (NestedArrayType)type;
            CompositeByteBuf compBuf = (CompositeByteBuf)buffer;
            ByteBuf[] elementBufs = new ByteBuf[compBuf.numComponents()];
            for (int c = 0; c < elementBufs.length; ++c) {
                elementBufs[c] = compBuf.component(c).retain();
            }
            return new PGBuffersArray(context, atype, atype.getElementFormat(), elementBufs, atype.getDimensions());
        }
    }

    static class TxtDecoder
    extends BaseTextDecoder {
        TxtDecoder() {
        }

        @Override
        public Class<?> getDefaultClass() {
            return Array.class;
        }

        @Override
        protected Object decodeValue(Context context, Type type, Short typeLength, Integer typeModifier, CharSequence buffer, Class<?> targetClass, Object targetContext) throws IOException {
            ByteBufAllocator byteBufAllocator = context.getAllocator();
            NestedArrayType atype = (NestedArrayType)type;
            CompositeCharSequence compBuf = (CompositeCharSequence)buffer;
            CharSequence[] elementBufs = compBuf.getComponents();
            ByteBuf[] elementBinaryBufs = new ByteBuf[elementBufs.length];
            for (int elementIdx = 0; elementIdx < elementBufs.length; ++elementIdx) {
                elementBinaryBufs[elementIdx] = ByteBufUtil.writeUtf8(byteBufAllocator, elementBufs[elementIdx]);
            }
            return new PGBuffersArray(context, atype, FieldFormat.Text, elementBinaryBufs, atype.getDimensions());
        }
    }
}

