/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.procs.Arrays;
import com.impossibl.postgres.system.procs.BaseTextDecoder;
import com.impossibl.postgres.system.procs.BaseTextEncoder;
import com.impossibl.postgres.system.procs.SimpleProcProvider;
import com.impossibl.postgres.types.Type;
import com.impossibl.postgres.utils.guava.Joiner;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.text.ParseException;

public class OidVectors
extends SimpleProcProvider {
    public OidVectors() {
        super((Type.Codec.Encoder<StringBuilder>)new TxtEncoder(), (Type.Codec.Decoder<CharSequence>)new TxtDecoder(), (Type.Codec.Encoder<ByteBuf>)new BinEncoder(), (Type.Codec.Decoder<ByteBuf>)new BinDecoder(), "oidvector");
    }

    static class TxtEncoder
    extends BaseTextEncoder {
        TxtEncoder() {
        }

        @Override
        protected void encodeValue(Context context, Type type, Object value, Object sourceContext, StringBuilder buffer) throws IOException {
            Integer[] oids = (Integer[])value;
            Object[] items = new String[oids.length];
            for (int c = 0; c < oids.length; ++c) {
                items[c] = Long.toString((long)oids[c].intValue() & 0xFFFFFFFFL);
            }
            Joiner.on(' ').appendTo(buffer, items);
        }
    }

    static class TxtDecoder
    extends BaseTextDecoder {
        TxtDecoder() {
        }

        @Override
        public Class<?> getDefaultClass() {
            return Integer[].class;
        }

        @Override
        protected Object decodeValue(Context context, Type type, Short typeLength, Integer typeModifier, CharSequence buffer, Class<?> targetClass, Object targetContext) throws IOException, ParseException {
            String[] items = buffer.toString().split(" ");
            Integer[] oids = new Integer[items.length];
            for (int c = 0; c < items.length; ++c) {
                oids[c] = (int)(Long.parseLong(items[c]) & 0xFFFFFFFFL);
            }
            return oids;
        }
    }

    static class BinEncoder
    extends Arrays.BinEncoder {
        BinEncoder() {
        }
    }

    static class BinDecoder
    extends Arrays.BinDecoder {
        BinDecoder() {
        }

        @Override
        public Class<?> getDefaultClass() {
            return Integer[].class;
        }
    }
}

