/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.jdbc.PGDirectConnection;
import com.impossibl.postgres.jdbc.PGSQLXML;
import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.ConversionException;
import com.impossibl.postgres.system.procs.BaseTextDecoder;
import com.impossibl.postgres.system.procs.ConvertedBytes;
import com.impossibl.postgres.system.procs.SimpleProcProvider;
import com.impossibl.postgres.system.procs.Strings;
import com.impossibl.postgres.types.Type;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.sql.SQLXML;
import java.text.ParseException;

public class XMLs
extends SimpleProcProvider {
    public XMLs() {
        super((Type.Codec.Encoder<StringBuilder>)new TxtEncoder(), (Type.Codec.Decoder<CharSequence>)new TxtDecoder(), (Type.Codec.Encoder<ByteBuf>)new BinEncoder(), (Type.Codec.Decoder<ByteBuf>)new BinDecoder(), "xml_");
    }

    static byte[] convertInput(Type type, Object value) throws ConversionException {
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        if (value instanceof PGSQLXML) {
            return ((PGSQLXML)value).getData();
        }
        throw new ConversionException(value.getClass(), type);
    }

    static Object convertOutput(Context context, Type type, byte[] data, Class<?> targetClass) throws ConversionException {
        if (targetClass == SQLXML.class) {
            return new PGSQLXML((PGDirectConnection)context.unwrap(), data);
        }
        if (targetClass == String.class) {
            return new String(data, context.getCharset());
        }
        if (targetClass == byte[].class) {
            return data;
        }
        throw new ConversionException(type, targetClass);
    }

    static class TxtEncoder
    extends Strings.TxtEncoder {
        TxtEncoder() {
        }

        @Override
        protected void encodeValue(Context context, Type type, Object value, Object sourceContext, StringBuilder buffer) throws IOException {
            if (value instanceof byte[]) {
                value = new String((byte[])value, context.getCharset());
            }
            super.encodeValue(context, type, value, sourceContext, buffer);
        }
    }

    static class TxtDecoder
    extends BaseTextDecoder {
        TxtDecoder() {
        }

        @Override
        public Class<?> getDefaultClass() {
            return SQLXML.class;
        }

        @Override
        protected Object decodeValue(Context context, Type type, Short typeLength, Integer typeModifier, CharSequence buffer, Class<?> targetClass, Object targetContext) throws IOException, ParseException {
            byte[] data = buffer.toString().getBytes(context.getCharset());
            return XMLs.convertOutput(context, type, data, targetClass);
        }
    }

    static class BinEncoder
    extends ConvertedBytes.BinEncoder {
        BinEncoder() {
        }

        @Override
        protected void encodeValue(Context context, Type type, Object value, Object sourceContext, ByteBuf buffer) throws IOException {
            if ((value = (Object)XMLs.convertInput(type, value)) == null) {
                value = new byte[0];
            }
            super.encodeValue(context, type, value, sourceContext, buffer);
        }
    }

    static class BinDecoder
    extends ConvertedBytes.BinDecoder {
        BinDecoder() {
        }

        @Override
        public Class<?> getDefaultClass() {
            return SQLXML.class;
        }

        @Override
        protected Object decodeValue(Context context, Type type, Short typeLength, Integer typeModifier, ByteBuf buffer, Class<?> targetClass, Object targetContext) throws IOException {
            byte[] data = (byte[])super.decodeValue(context, type, typeLength, typeModifier, buffer, targetClass, targetContext);
            return XMLs.convertOutput(context, type, data, targetClass);
        }
    }
}

