/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal;

import com.google.gson.JsonElement;
import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.retry.RetryConfiguration;
import com.pubnub.api.retry.RetryableEndpointGroup;
import com.pubnub.api.v2.BasePNConfiguration;
import com.pubnub.api.v2.callbacks.Result;
import com.pubnub.internal.EndpointInterface;
import com.pubnub.internal.PubNubCore;
import com.pubnub.internal.managers.RetrofitManager;
import com.pubnub.internal.retry.RetryableCallback;
import com.pubnub.internal.retry.RetryableRestCaller;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import kotlin.KotlinNullPointerException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.UninitializedPropertyAccessException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\b&\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\b\u0012\u0004\u0012\u0002H\u00020\u0003B\u000f\b\u0004\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010'\u001a\u00020(2\u0012\u0010)\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\t0\bH\u0016J\u001b\u0010*\u001a\u00028\u00012\f\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00000,H\u0002\u00a2\u0006\u0002\u0010-J$\u0010.\u001a\u001e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00180/j\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0018`0H\u0004J.\u00101\u001a\u0002022\f\u00103\u001a\b\u0012\u0004\u0012\u00028\u00000,2\n\b\u0002\u00104\u001a\u0004\u0018\u00010\u00182\n\b\u0002\u00105\u001a\u0004\u0018\u000106H\u0002J\u001b\u00107\u001a\u00028\u00012\f\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00000,H$\u00a2\u0006\u0002\u0010-J2\u00108\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b2\"\u00109\u001a\u001e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00180/j\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0018`0H$J&\u0010:\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0012\u0006\u0012\u0004\u0018\u0001060;2\f\u00103\u001a\b\u0012\u0004\u0012\u00028\u00000,H\u0002J\u000e\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00180=H\u0014J\u000e\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00180=H\u0014J\b\u0010?\u001a\u00020@H$J\u001b\u0010A\u001a\u00028\u00012\f\u00103\u001a\b\u0012\u0004\u0012\u00028\u00000,H\u0002\u00a2\u0006\u0002\u0010-J\b\u0010B\u001a\u00020&H\u0014J\b\u0010C\u001a\u00020&H\u0014J\b\u0010D\u001a\u00020&H\u0014J\b\u0010E\u001a\u00020&H\u0014J\u0010\u0010F\u001a\u00020(2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\b\u0010G\u001a\u00020(H\u0016J\b\u0010H\u001a\u00020(H\u0016J\r\u0010I\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010JJ\b\u0010K\u001a\u00020(H\u0014R\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\t0\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001d\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00180\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001c8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR!\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000 8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010$\u001a\u0004\b!\u0010\"R\u000e\u0010%\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006L"}, d2={"Lcom/pubnub/internal/EndpointCore;", "Input", "Output", "Lcom/pubnub/internal/EndpointInterface;", "pubnub", "Lcom/pubnub/internal/PubNubCore;", "(Lcom/pubnub/internal/PubNubCore;)V", "cachedCallback", "Ljava/util/function/Consumer;", "Lcom/pubnub/api/v2/callbacks/Result;", "call", "Lretrofit2/Call;", "configOverride", "Lcom/pubnub/api/v2/BasePNConfiguration;", "configuration", "getConfiguration", "()Lcom/pubnub/api/v2/BasePNConfiguration;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getPubnub", "()Lcom/pubnub/internal/PubNubCore;", "queryParam", "", "", "getQueryParam", "()Ljava/util/Map;", "retrofitManager", "Lcom/pubnub/internal/managers/RetrofitManager;", "getRetrofitManager", "()Lcom/pubnub/internal/managers/RetrofitManager;", "retryableRestCaller", "Lcom/pubnub/internal/retry/RetryableRestCaller;", "getRetryableRestCaller", "()Lcom/pubnub/internal/retry/RetryableRestCaller;", "retryableRestCaller$delegate", "Lkotlin/Lazy;", "silenceFailures", "", "async", "", "callback", "checkAndCreateResponse", "input", "Lretrofit2/Response;", "(Lretrofit2/Response;)Ljava/lang/Object;", "createBaseParams", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "createException", "Lcom/pubnub/api/PubNubException;", "response", "errorString", "errorBody", "Lcom/google/gson/JsonElement;", "createResponse", "doWork", "queryParams", "extractErrorBody", "Lkotlin/Pair;", "getAffectedChannelGroups", "", "getAffectedChannels", "getEndpointGroupName", "Lcom/pubnub/api/retry/RetryableEndpointGroup;", "handleResponse", "isAuthRequired", "isEndpointRetryable", "isPubKeyRequired", "isSubKeyRequired", "overrideConfiguration", "retry", "silentCancel", "sync", "()Ljava/lang/Object;", "validateParams", "pubnub-core-impl"})
public abstract class EndpointCore<Input, Output>
implements EndpointInterface<Output> {
    @NotNull
    private final PubNubCore pubnub;
    @Nullable
    private BasePNConfiguration configOverride;
    private final Logger log;
    private Consumer<Result<Output>> cachedCallback;
    private Call<Input> call;
    private boolean silenceFailures;
    @NotNull
    private final Lazy retryableRestCaller$delegate;
    @NotNull
    private final Map<String, String> queryParam;

    protected EndpointCore(@NotNull PubNubCore pubnub) {
        Intrinsics.checkNotNullParameter(pubnub, "pubnub");
        this.pubnub = pubnub;
        this.log = LoggerFactory.getLogger((String)this.getClass().getSimpleName());
        this.retryableRestCaller$delegate = LazyKt.lazy(new Function0<RetryableRestCaller<Input>>(this){
            final /* synthetic */ EndpointCore<Input, Output> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final RetryableRestCaller<Input> invoke() {
                return new RetryableRestCaller<T>(this.this$0.getConfiguration().getRetryConfiguration(), this.this$0.getEndpointGroupName(), this.this$0.isEndpointRetryable());
            }
        });
        this.queryParam = new LinkedHashMap();
    }

    @NotNull
    protected final PubNubCore getPubnub() {
        return this.pubnub;
    }

    @Override
    @NotNull
    public final BasePNConfiguration getConfiguration() {
        BasePNConfiguration basePNConfiguration = this.configOverride;
        if (basePNConfiguration == null) {
            basePNConfiguration = this.pubnub.getConfiguration();
        }
        return basePNConfiguration;
    }

    @NotNull
    protected final RetrofitManager getRetrofitManager() {
        RetrofitManager retrofitManager;
        BasePNConfiguration basePNConfiguration = this.configOverride;
        if (basePNConfiguration != null) {
            BasePNConfiguration configOverrideNonNull = basePNConfiguration;
            boolean bl = false;
            retrofitManager = new RetrofitManager(this.pubnub.getRetrofitManager$pubnub_core_impl(), configOverrideNonNull);
        } else {
            retrofitManager = this.pubnub.getRetrofitManager$pubnub_core_impl();
        }
        return retrofitManager;
    }

    private final RetryableRestCaller<Input> getRetryableRestCaller() {
        Lazy lazy = this.retryableRestCaller$delegate;
        return (RetryableRestCaller)lazy.getValue();
    }

    @NotNull
    public final Map<String, String> getQueryParam() {
        return this.queryParam;
    }

    @Override
    public Output sync() {
        this.validateParams();
        this.call = this.doWork(this.createBaseParams());
        RetryableRestCaller<Input> retryableRestCaller2 = this.getRetryableRestCaller();
        Call<Input> call = this.call;
        if (call == null) {
            Intrinsics.throwUninitializedPropertyAccessException("call");
            call = null;
        }
        Response<Input> response = retryableRestCaller2.execute$pubnub_core_impl(call);
        return this.handleResponse(response);
    }

    private final Output handleResponse(Response<Input> response) {
        if (response.isSuccessful()) {
            return this.checkAndCreateResponse(response);
        }
        Pair<String, JsonElement> pair = this.extractErrorBody(response);
        String errorString = pair.component1();
        JsonElement errorJson = pair.component2();
        throw this.createException(response, errorString, errorJson);
    }

    @Override
    public void async(@NotNull Consumer<Result<Output>> callback) {
        Call<Input> call;
        Intrinsics.checkNotNullParameter(callback, "callback");
        this.cachedCallback = callback;
        try {
            this.validateParams();
            this.call = this.doWork(this.createBaseParams());
        }
        catch (PubNubException pubnubException) {
            callback.accept(Result.Companion.failure(pubnubException));
            return;
        }
        Call<Input> call2 = this.call;
        if (call2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("call");
            call2 = null;
        }
        if ((call = this.call) == null) {
            Intrinsics.throwUninitializedPropertyAccessException("call");
            call = null;
        }
        Call<Input> call3 = call;
        RetryConfiguration retryConfiguration = this.getConfiguration().getRetryConfiguration();
        RetryableEndpointGroup retryableEndpointGroup = this.getEndpointGroupName();
        boolean bl = this.isEndpointRetryable();
        ScheduledExecutorService scheduledExecutorService = this.pubnub.getExecutorService$pubnub_core_impl();
        call2.enqueue(new RetryableCallback<Input>(this, callback, call3, retryConfiguration, retryableEndpointGroup, bl, scheduledExecutorService){
            final /* synthetic */ EndpointCore<Input, Output> this$0;
            final /* synthetic */ Consumer<Result<Output>> $callback;
            {
                this.this$0 = $receiver;
                this.$callback = $callback;
                super($super_call_param$2, $super_call_param$3, $super_call_param$1, $super_call_param$4, $super_call_param$5);
            }

            public void onFinalResponse(@NotNull Call<Input> call, @NotNull Response<Input> response) {
                Intrinsics.checkNotNullParameter(call, "call");
                Intrinsics.checkNotNullParameter(response, "response");
                if (response.isSuccessful()) {
                    Result<Object> result;
                    try {
                        result = Result.Companion.success(EndpointCore.access$checkAndCreateResponse(this.this$0, response));
                    }
                    catch (PubNubException e) {
                        result = Result.Companion.failure(e);
                    }
                    Consumer<Result<Output>> e = this.$callback;
                    Result<Object> result2 = result;
                    boolean bl = false;
                    e.accept(result2);
                } else {
                    Pair pair = EndpointCore.access$extractErrorBody(this.this$0, response);
                    String errorString = (String)pair.component1();
                    JsonElement errorJson = (JsonElement)pair.component2();
                    this.$callback.accept(Result.Companion.failure(EndpointCore.access$createException(this.this$0, response, errorString, errorJson)));
                }
            }

            public void onFinalFailure(@NotNull Call<Input> call, @NotNull Throwable t) {
                Intrinsics.checkNotNullParameter(call, "call");
                Intrinsics.checkNotNullParameter(t, "t");
                if (EndpointCore.access$getSilenceFailures$p(this.this$0)) {
                    return;
                }
                Throwable throwable = t;
                PubNubError error = (throwable instanceof UnknownHostException ? true : throwable instanceof ConnectException) ? PubNubError.CONNECT_EXCEPTION : (throwable instanceof SocketTimeoutException ? PubNubError.SUBSCRIBE_TIMEOUT : (throwable instanceof IOException ? PubNubError.PARSING_ERROR : (throwable instanceof IllegalStateException ? PubNubError.PARSING_ERROR : PubNubError.HTTP_ERROR)));
                PubNubException pubnubException = new PubNubException(t.toString(), error, null, 0, null, null, null, null, t, null, this.this$0, 764, null);
                this.$callback.accept(Result.Companion.failure(pubnubException));
            }
        });
    }

    @NotNull
    protected final HashMap<String, String> createBaseParams() {
        HashMap<String, String> map = new HashMap<String, String>();
        ((Map)map).putAll(this.queryParam);
        ((Map)map).put("pnsdk", this.pubnub.generatePnsdk());
        ((Map)map).put("uuid", this.getConfiguration().getUserId().getValue());
        if (this.getConfiguration().getIncludeInstanceIdentifier()) {
            ((Map)map).put("instanceid", this.pubnub.getInstanceId());
        }
        if (this.getConfiguration().getIncludeRequestIdentifier()) {
            ((Map)map).put("requestid", this.pubnub.requestId$pubnub_core_impl());
        }
        if (this.isAuthRequired()) {
            String token = this.pubnub.getTokenManager$pubnub_core_impl().getToken();
            if (token != null) {
                ((Map)map).put("auth", token);
            } else if (BasePNConfiguration.Companion.isValid(this.getConfiguration().getAuthKey())) {
                ((Map)map).put("auth", this.getConfiguration().getAuthKey());
            }
        }
        return map;
    }

    @Override
    public void silentCancel() {
        if (this.call != null) {
            Call<Input> call = this.call;
            if (call == null) {
                Intrinsics.throwUninitializedPropertyAccessException("call");
                call = null;
            }
            if (!call.isCanceled()) {
                this.silenceFailures = true;
                Call<Input> call2 = this.call;
                if (call2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("call");
                    call2 = null;
                }
                call2.cancel();
            }
        }
    }

    private final PubNubException createException(Response<Input> response, String errorString, JsonElement errorBody) {
        List<String> list;
        List<String> list2;
        Object channelGroupName;
        Iterator<JsonElement> iterator2;
        List errorChannels = new ArrayList();
        List errorGroups = new ArrayList();
        if (errorBody != null && this.pubnub.getMapper().isJsonObject(errorBody) && this.pubnub.getMapper().hasField(errorBody, "payload")) {
            JsonElement jsonElement = this.pubnub.getMapper().getField(errorBody, "payload");
            Intrinsics.checkNotNull(jsonElement);
            JsonElement payloadBody = jsonElement;
            if (this.pubnub.getMapper().hasField(payloadBody, "channels")) {
                iterator2 = this.pubnub.getMapper().getArrayIterator(payloadBody, "channels");
                while (iterator2.hasNext()) {
                    String string = this.pubnub.getMapper().elementToString(iterator2.next());
                    Intrinsics.checkNotNull(string);
                    errorChannels.add(string);
                }
            }
            if (this.pubnub.getMapper().hasField(payloadBody, "channel-groups")) {
                iterator2 = this.pubnub.getMapper().getArrayIterator(payloadBody, "channel-groups");
                while (iterator2.hasNext()) {
                    String string;
                    String it;
                    JsonElement node = iterator2.next();
                    Intrinsics.checkNotNull(this.pubnub.getMapper().elementToString(node));
                    boolean bl = false;
                    if (Intrinsics.areEqual(String.valueOf(StringsKt.first(it)), ":")) {
                        String string2 = it.substring(1);
                        string = string2;
                        Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).substring(startIndex)");
                    } else {
                        string = it;
                    }
                    channelGroupName = string;
                    errorGroups.add(channelGroupName);
                }
            }
        }
        if ((iterator2 = (List<String>)errorChannels).isEmpty()) {
            boolean bl = false;
            try {
                channelGroupName = this.getAffectedChannels();
            }
            catch (UninitializedPropertyAccessException e) {
                channelGroupName = CollectionsKt.emptyList();
            }
            list2 = channelGroupName;
        } else {
            list2 = iterator2;
        }
        List affectedChannels = list2;
        Object object = errorGroups;
        if (object.isEmpty()) {
            List<String> list3;
            boolean bl = false;
            try {
                list3 = this.getAffectedChannelGroups();
            }
            catch (UninitializedPropertyAccessException e) {
                list3 = CollectionsKt.emptyList();
            }
            list = list3;
        } else {
            list = object;
        }
        List affectedChannelGroups = list;
        object = PubNubError.HTTP_ERROR;
        JsonElement jsonElement = errorBody;
        String string = jsonElement != null ? jsonElement.toString() : null;
        int n = response.code();
        Call<Input> call = this.call;
        if (call == null) {
            Intrinsics.throwUninitializedPropertyAccessException("call");
            call = null;
        }
        Call<Input> call2 = call;
        String string3 = response.headers().get("Retry-After");
        Integer n2 = string3 != null ? StringsKt.toIntOrNull(string3) : null;
        PubNubException.RequestInfo requestInfo = new PubNubException.RequestInfo(response.raw().request().url().isHttps(), response.raw().request().url().host(), response.raw().request().url().queryParameter("uuid"), response.raw().request().url().queryParameter("auth"), response.raw().request());
        return new PubNubException(errorString, (PubNubError)((Object)object), string, n, call2, n2, affectedChannels, affectedChannelGroups, null, requestInfo, this, 256, null);
    }

    static /* synthetic */ PubNubException createException$default(EndpointCore endpointCore, Response response, String string, JsonElement jsonElement, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createException");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            jsonElement = null;
        }
        return endpointCore.createException(response, string, jsonElement);
    }

    @Override
    public void retry() {
        this.silenceFailures = false;
        Consumer<Result<Output>> consumer = this.cachedCallback;
        if (consumer == null) {
            Intrinsics.throwUninitializedPropertyAccessException("cachedCallback");
            consumer = null;
        }
        this.async(consumer);
    }

    private final Pair<String, JsonElement> extractErrorBody(Response<Input> response) {
        JsonElement jsonElement;
        String string;
        try {
            ResponseBody responseBody = response.errorBody();
            string = responseBody != null ? responseBody.string() : null;
        }
        catch (IOException e) {
            string = "N/A";
        }
        String errorBodyString = string;
        try {
            jsonElement = this.pubnub.getMapper().fromJson(errorBodyString, JsonElement.class);
        }
        catch (PubNubException e) {
            jsonElement = null;
        }
        JsonElement errorBodyJson = jsonElement;
        return TuplesKt.to(errorBodyString, errorBodyJson);
    }

    private final Output checkAndCreateResponse(Response<Input> input) {
        try {
            return this.createResponse(input);
        }
        catch (PubNubException pubnubException) {
            int n = input.code();
            String string = this.pubnub.getMapper().toJson(input.body());
            Call<Input> call = this.call;
            if (call == null) {
                Intrinsics.throwUninitializedPropertyAccessException("call");
                call = null;
            }
            Call<Input> call2 = call;
            throw PubNubException.copy$default(pubnubException, null, null, string, n, call2, null, null, null, null, null, null, 2019, null);
        }
        catch (KotlinNullPointerException e) {
            PubNubError pubNubError = PubNubError.PARSING_ERROR;
            String string = e.toString();
            Call<Input> call = this.call;
            if (call == null) {
                Intrinsics.throwUninitializedPropertyAccessException("call");
                call = null;
            }
            Call<Input> call3 = call;
            int n = input.code();
            String string2 = this.pubnub.getMapper().toJson(input.body());
            throw new PubNubException(string, pubNubError, string2, n, call3, null, null, null, e, null, null, 1760, null);
        }
        catch (IllegalStateException e) {
            PubNubError pubNubError = PubNubError.PARSING_ERROR;
            String string = e.toString();
            Call<Input> call = this.call;
            if (call == null) {
                Intrinsics.throwUninitializedPropertyAccessException("call");
                call = null;
            }
            Call<Input> call4 = call;
            int n = input.code();
            String string3 = this.pubnub.getMapper().toJson(input.body());
            throw new PubNubException(string, pubNubError, string3, n, call4, null, null, null, e, null, null, 1760, null);
        }
        catch (IndexOutOfBoundsException e) {
            PubNubError pubNubError = PubNubError.PARSING_ERROR;
            String string = e.toString();
            Call<Input> call = this.call;
            if (call == null) {
                Intrinsics.throwUninitializedPropertyAccessException("call");
                call = null;
            }
            Call<Input> call5 = call;
            int n = input.code();
            String string4 = this.pubnub.getMapper().toJson(input.body());
            throw new PubNubException(string, pubNubError, string4, n, call5, null, null, null, e, null, null, 1760, null);
        }
        catch (NullPointerException e) {
            PubNubError pubNubError = PubNubError.PARSING_ERROR;
            String string = e.toString();
            Call<Input> call = this.call;
            if (call == null) {
                Intrinsics.throwUninitializedPropertyAccessException("call");
                call = null;
            }
            Call<Input> call6 = call;
            int n = input.code();
            String string5 = this.pubnub.getMapper().toJson(input.body());
            throw new PubNubException(string, pubNubError, string5, n, call6, null, null, null, e, null, null, 1760, null);
        }
        catch (IllegalArgumentException e) {
            PubNubError pubNubError = PubNubError.PARSING_ERROR;
            String string = e.toString();
            Call<Input> call = this.call;
            if (call == null) {
                Intrinsics.throwUninitializedPropertyAccessException("call");
                call = null;
            }
            Call<Input> call7 = call;
            int n = input.code();
            String string6 = this.pubnub.getMapper().toJson(input.body());
            throw new PubNubException(string, pubNubError, string6, n, call7, null, null, null, e, null, null, 1760, null);
        }
        catch (TypeCastException e) {
            PubNubError pubNubError = PubNubError.PARSING_ERROR;
            String string = e.toString();
            Call<Input> call = this.call;
            if (call == null) {
                Intrinsics.throwUninitializedPropertyAccessException("call");
                call = null;
            }
            Call<Input> call8 = call;
            int n = input.code();
            String string7 = this.pubnub.getMapper().toJson(input.body());
            throw new PubNubException(string, pubNubError, string7, n, call8, null, null, null, e, null, null, 1760, null);
        }
        catch (ClassCastException e) {
            PubNubError pubNubError = PubNubError.PARSING_ERROR;
            String string = e.toString();
            Call<Input> call = this.call;
            if (call == null) {
                Intrinsics.throwUninitializedPropertyAccessException("call");
                call = null;
            }
            Call<Input> call9 = call;
            int n = input.code();
            String string8 = this.pubnub.getMapper().toJson(input.body());
            throw new PubNubException(string, pubNubError, string8, n, call9, null, null, null, e, null, null, 1760, null);
        }
        catch (UninitializedPropertyAccessException e) {
            PubNubError pubNubError = PubNubError.PARSING_ERROR;
            String string = e.toString();
            Call<Input> call = this.call;
            if (call == null) {
                Intrinsics.throwUninitializedPropertyAccessException("call");
                call = null;
            }
            Call<Input> call10 = call;
            int n = input.code();
            String string9 = this.pubnub.getMapper().toJson(input.body());
            throw new PubNubException(string, pubNubError, string9, n, call10, null, null, null, e, null, null, 1760, null);
        }
    }

    @NotNull
    protected List<String> getAffectedChannels() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    protected List<String> getAffectedChannelGroups() {
        return CollectionsKt.emptyList();
    }

    protected void validateParams() {
        if (this.isSubKeyRequired() && !BasePNConfiguration.Companion.isValid(this.getConfiguration().getSubscribeKey())) {
            throw new PubNubException(PubNubError.SUBSCRIBE_KEY_MISSING);
        }
        if (this.isPubKeyRequired() && !BasePNConfiguration.Companion.isValid(this.getConfiguration().getPublishKey())) {
            throw new PubNubException(PubNubError.PUBLISH_KEY_MISSING);
        }
    }

    @Override
    public void overrideConfiguration(@NotNull BasePNConfiguration configuration) {
        Intrinsics.checkNotNullParameter(configuration, "configuration");
        this.configOverride = configuration;
    }

    @NotNull
    protected abstract Call<Input> doWork(@NotNull HashMap<String, String> var1);

    protected abstract Output createResponse(@NotNull Response<Input> var1);

    protected boolean isSubKeyRequired() {
        return true;
    }

    protected boolean isPubKeyRequired() {
        return false;
    }

    protected boolean isAuthRequired() {
        return true;
    }

    @NotNull
    protected abstract RetryableEndpointGroup getEndpointGroupName();

    protected boolean isEndpointRetryable() {
        return true;
    }

    public static final /* synthetic */ Object access$checkAndCreateResponse(EndpointCore $this, Response input) {
        return $this.checkAndCreateResponse(input);
    }

    public static final /* synthetic */ Pair access$extractErrorBody(EndpointCore $this, Response response) {
        return $this.extractErrorBody(response);
    }

    public static final /* synthetic */ PubNubException access$createException(EndpointCore $this, Response response, String errorString, JsonElement errorBody) {
        return $this.createException(response, errorString, errorBody);
    }

    public static final /* synthetic */ boolean access$getSilenceFailures$p(EndpointCore $this) {
        return $this.silenceFailures;
    }
}

