/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.endpoints.files;

import com.pubnub.api.PubNubException;
import com.pubnub.api.builder.PubNubErrorBuilder;
import com.pubnub.api.endpoints.BuilderSteps;
import com.pubnub.api.endpoints.files.PublishFileMessage;
import com.pubnub.api.endpoints.files.requiredparambuilder.FilesBuilderSteps;
import com.pubnub.api.models.consumer.files.PNPublishFileMessageResult;
import com.pubnub.internal.EndpointInterface;
import com.pubnub.internal.PubNubCore;
import com.pubnub.internal.endpoints.IdentityMappingEndpoint;
import com.pubnub.internal.endpoints.files.requiredparambuilder.ChannelFileNameFileIdBuilder;
import org.jetbrains.annotations.NotNull;

public class PublishFileMessageImpl
extends IdentityMappingEndpoint<PNPublishFileMessageResult>
implements PublishFileMessage {
    private Object message;
    private Object meta;
    private Integer ttl;
    private Boolean shouldStore;
    private final String channel;
    private final String fileName;
    private final String fileId;

    public PublishFileMessageImpl(String channel, String fileName, String fileId, PubNubCore pubnub) {
        super(pubnub);
        this.channel = channel;
        this.fileName = fileName;
        this.fileId = fileId;
    }

    @Override
    @NotNull
    protected EndpointInterface<PNPublishFileMessageResult> createAction() {
        return this.pubnub.publishFileMessage(this.channel, this.fileName, this.fileId, this.message, this.meta, this.ttl, this.shouldStore);
    }

    public static PublishFileMessage.Builder builder(PubNubCore pubNub) {
        return new Builder(ChannelFileNameFileIdBuilder.create((channel, fileName, fileId) -> new PublishFileMessageImpl((String)channel, (String)fileName, (String)fileId, pubNub)));
    }

    @Override
    protected void validateParams() throws PubNubException {
        if (this.channel == null) {
            throw new PubNubException(PubNubErrorBuilder.PNERROBJ_CHANNEL_MISSING);
        }
    }

    @Override
    public PublishFileMessageImpl message(Object message) {
        this.message = message;
        return this;
    }

    @Override
    public PublishFileMessageImpl meta(Object meta) {
        this.meta = meta;
        return this;
    }

    @Override
    public PublishFileMessageImpl ttl(Integer ttl) {
        this.ttl = ttl;
        return this;
    }

    @Override
    public PublishFileMessageImpl shouldStore(Boolean shouldStore) {
        this.shouldStore = shouldStore;
        return this;
    }

    public static class Builder
    extends ChannelFileNameFileIdBuilder<PublishFileMessage>
    implements PublishFileMessage.Builder {
        private Builder(BuilderSteps.ChannelStep<FilesBuilderSteps.FileNameStep<FilesBuilderSteps.FileIdStep<PublishFileMessage>>> builder2) {
            super(builder2);
        }
    }
}

