/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.endpoints.files;

import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.crypto.CryptoModule;
import com.pubnub.api.endpoints.remoteaction.ComposableRemoteAction;
import com.pubnub.api.endpoints.remoteaction.ExtendedRemoteAction;
import com.pubnub.api.endpoints.remoteaction.MappingRemoteActionKt;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.models.consumer.files.PNBaseFile;
import com.pubnub.api.models.consumer.files.PNFileUploadResult;
import com.pubnub.api.models.consumer.files.PNPublishFileMessageResult;
import com.pubnub.api.v2.callbacks.Result;
import com.pubnub.internal.crypto.cryptor.InputStreamSeparator;
import com.pubnub.internal.endpoints.files.GenerateUploadUrlEndpoint;
import com.pubnub.internal.endpoints.files.PublishFileMessageEndpoint;
import com.pubnub.internal.endpoints.files.SendFileInterface;
import com.pubnub.internal.endpoints.files.UploadFileEndpoint;
import com.pubnub.internal.endpoints.remoteaction.RetryingRemoteAction;
import com.pubnub.internal.models.server.files.FileUploadRequestDetails;
import java.io.Closeable;
import java.io.InputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0083\u0001\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u0012\u0006\u0010\u000e\u001a\u00020\u000b\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0018\u00a2\u0006\u0002\u0010\u0019J\u001c\u0010\u001f\u001a\u00020 2\u0012\u0010!\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0#0\"H\u0016J\u0018\u0010$\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\b\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020 H\u0016J8\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J\b\u0010-\u001a\u00020 H\u0016J\b\u0010.\u001a\u00020\u001cH\u0016J\b\u0010/\u001a\u00020 H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001dR\u0012\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001e\u00a8\u00060"}, d2={"Lcom/pubnub/internal/endpoints/files/SendFileEndpoint;", "Lcom/pubnub/internal/endpoints/files/SendFileInterface;", "channel", "", "fileName", "inputStream", "Ljava/io/InputStream;", "message", "", "meta", "ttl", "", "shouldStore", "", "fileMessagePublishRetryLimit", "executorService", "Ljava/util/concurrent/ExecutorService;", "generateUploadUrlFactory", "Lcom/pubnub/internal/endpoints/files/GenerateUploadUrlEndpoint$Factory;", "publishFileMessageFactory", "Lcom/pubnub/internal/endpoints/files/PublishFileMessageEndpoint$Factory;", "sendFileToS3Factory", "Lcom/pubnub/internal/endpoints/files/UploadFileEndpoint$Factory;", "cryptoModule", "Lcom/pubnub/api/crypto/CryptoModule;", "(Ljava/lang/String;Ljava/lang/String;Ljava/io/InputStream;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Integer;Ljava/lang/Boolean;ILjava/util/concurrent/ExecutorService;Lcom/pubnub/internal/endpoints/files/GenerateUploadUrlEndpoint$Factory;Lcom/pubnub/internal/endpoints/files/PublishFileMessageEndpoint$Factory;Lcom/pubnub/internal/endpoints/files/UploadFileEndpoint$Factory;Lcom/pubnub/api/crypto/CryptoModule;)V", "sendFileMultistepAction", "Lcom/pubnub/api/endpoints/remoteaction/ExtendedRemoteAction;", "Lcom/pubnub/api/models/consumer/files/PNFileUploadResult;", "Ljava/lang/Boolean;", "Ljava/lang/Integer;", "async", "", "callback", "Ljava/util/function/Consumer;", "Lcom/pubnub/api/v2/callbacks/Result;", "mapPublishFileMessageToFileUpload", "requestDetails", "Lcom/pubnub/internal/models/server/files/FileUploadRequestDetails;", "res", "Lcom/pubnub/api/models/consumer/files/PNPublishFileMessageResult;", "operationType", "Lcom/pubnub/api/enums/PNOperationType;", "retry", "sendFileComposedActions", "silentCancel", "sync", "validate", "pubnub-core-impl"})
public final class SendFileEndpoint
implements SendFileInterface {
    @NotNull
    private final String channel;
    @NotNull
    private final String fileName;
    @Nullable
    private final Object message;
    @Nullable
    private final Object meta;
    @Nullable
    private final Integer ttl;
    @Nullable
    private final Boolean shouldStore;
    private final int fileMessagePublishRetryLimit;
    @NotNull
    private final ExecutorService executorService;
    @NotNull
    private final ExtendedRemoteAction<PNFileUploadResult> sendFileMultistepAction;

    public SendFileEndpoint(@NotNull String channel, @NotNull String fileName, @NotNull InputStream inputStream2, @Nullable Object message, @Nullable Object meta, @Nullable Integer ttl, @Nullable Boolean shouldStore, int fileMessagePublishRetryLimit, @NotNull ExecutorService executorService, @NotNull GenerateUploadUrlEndpoint.Factory generateUploadUrlFactory, @NotNull PublishFileMessageEndpoint.Factory publishFileMessageFactory, @NotNull UploadFileEndpoint.Factory sendFileToS3Factory, @Nullable CryptoModule cryptoModule) {
        Intrinsics.checkNotNullParameter(channel, "channel");
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        Intrinsics.checkNotNullParameter(inputStream2, "inputStream");
        Intrinsics.checkNotNullParameter(executorService, "executorService");
        Intrinsics.checkNotNullParameter(generateUploadUrlFactory, "generateUploadUrlFactory");
        Intrinsics.checkNotNullParameter(publishFileMessageFactory, "publishFileMessageFactory");
        Intrinsics.checkNotNullParameter(sendFileToS3Factory, "sendFileToS3Factory");
        this.channel = channel;
        this.fileName = fileName;
        this.message = message;
        this.meta = meta;
        this.ttl = ttl;
        this.shouldStore = shouldStore;
        this.fileMessagePublishRetryLimit = fileMessagePublishRetryLimit;
        this.executorService = executorService;
        this.sendFileMultistepAction = this.sendFileComposedActions(generateUploadUrlFactory, publishFileMessageFactory, sendFileToS3Factory, inputStream2, cryptoModule);
    }

    public /* synthetic */ SendFileEndpoint(String string, String string2, InputStream inputStream2, Object object, Object object2, Integer n, Boolean bl, int n2, ExecutorService executorService, GenerateUploadUrlEndpoint.Factory factory2, PublishFileMessageEndpoint.Factory factory3, UploadFileEndpoint.Factory factory4, CryptoModule cryptoModule, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 8) != 0) {
            object = null;
        }
        if ((n3 & 0x10) != 0) {
            object2 = null;
        }
        if ((n3 & 0x20) != 0) {
            n = null;
        }
        if ((n3 & 0x40) != 0) {
            bl = null;
        }
        if ((n3 & 0x1000) != 0) {
            cryptoModule = null;
        }
        this(string, string2, inputStream2, object, object2, n, bl, n2, executorService, factory2, factory3, factory4, cryptoModule);
    }

    @Override
    @NotNull
    public PNFileUploadResult sync() throws PubNubException {
        this.validate();
        return (PNFileUploadResult)this.sendFileMultistepAction.sync();
    }

    @Override
    public void async(@NotNull Consumer<Result<PNFileUploadResult>> callback) {
        Intrinsics.checkNotNullParameter(callback, "callback");
        this.executorService.execute(() -> SendFileEndpoint.async$lambda$0(this, callback));
    }

    private final void validate() throws PubNubException {
        if (((CharSequence)this.channel).length() == 0) {
            throw new PubNubException(PubNubError.CHANNEL_MISSING);
        }
        if (((CharSequence)this.fileName).length() == 0) {
            throw PubNubException.copy$default(new PubNubException(PubNubError.INVALID_ARGUMENTS), "File name cannot be null nor empty", null, null, 0, null, null, null, null, null, null, null, 2046, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ExtendedRemoteAction<PNFileUploadResult> sendFileComposedActions(GenerateUploadUrlEndpoint.Factory generateUploadUrlFactory, PublishFileMessageEndpoint.Factory publishFileMessageFactory, UploadFileEndpoint.Factory sendFileToS3Factory, InputStream inputStream2, CryptoModule cryptoModule) {
        Object object;
        AtomicReference<FileUploadRequestDetails> result;
        block9: {
            block8: {
                byte[] byArray;
                result = new AtomicReference<FileUploadRequestDetails>();
                object = cryptoModule;
                if (object == null || (object = object.encryptStream(new InputStreamSeparator(inputStream2))) == null) break block8;
                Closeable closeable = (Closeable)object;
                Throwable throwable = null;
                try {
                    InputStream it = (InputStream)closeable;
                    boolean bl = false;
                    byArray = ByteStreamsKt.readBytes(it);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally(closeable, throwable);
                }
                object = byArray;
                if (byArray != null) break block9;
            }
            object = ByteStreamsKt.readBytes(inputStream2);
        }
        Object content = object;
        return MappingRemoteActionKt.map(ComposableRemoteAction.Companion.firstDo(generateUploadUrlFactory.create(this.channel, this.fileName)).then((Function1)new Function1<FileUploadRequestDetails, ExtendedRemoteAction<Unit>>(result, sendFileToS3Factory, this, (byte[])content){
            final /* synthetic */ AtomicReference<FileUploadRequestDetails> $result;
            final /* synthetic */ UploadFileEndpoint.Factory $sendFileToS3Factory;
            final /* synthetic */ SendFileEndpoint this$0;
            final /* synthetic */ byte[] $content;
            {
                this.$result = $result;
                this.$sendFileToS3Factory = $sendFileToS3Factory;
                this.this$0 = $receiver;
                this.$content = $content;
                super(1);
            }

            @NotNull
            public final ExtendedRemoteAction<Unit> invoke(@NotNull FileUploadRequestDetails res) {
                Intrinsics.checkNotNullParameter(res, "res");
                this.$result.set(res);
                return this.$sendFileToS3Factory.create(SendFileEndpoint.access$getFileName$p(this.this$0), this.$content, res);
            }
        }).checkpoint().then((Function1)new Function1<Unit, ExtendedRemoteAction<PNPublishFileMessageResult>>(result, publishFileMessageFactory, this){
            final /* synthetic */ AtomicReference<FileUploadRequestDetails> $result;
            final /* synthetic */ PublishFileMessageEndpoint.Factory $publishFileMessageFactory;
            final /* synthetic */ SendFileEndpoint this$0;
            {
                this.$result = $result;
                this.$publishFileMessageFactory = $publishFileMessageFactory;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final ExtendedRemoteAction<PNPublishFileMessageResult> invoke(@NotNull Unit it) {
                Intrinsics.checkNotNullParameter(it, "it");
                FileUploadRequestDetails details = this.$result.get();
                return RetryingRemoteAction.Companion.autoRetry(this.$publishFileMessageFactory.create(SendFileEndpoint.access$getChannel$p(this.this$0), details.getData().getName(), details.getData().getId(), SendFileEndpoint.access$getMessage$p(this.this$0), SendFileEndpoint.access$getMeta$p(this.this$0), SendFileEndpoint.access$getTtl$p(this.this$0), SendFileEndpoint.access$getShouldStore$p(this.this$0)), SendFileEndpoint.access$getFileMessagePublishRetryLimit$p(this.this$0), SendFileEndpoint.access$getExecutorService$p(this.this$0));
            }
        }), (Function1)new Function1<PNPublishFileMessageResult, PNFileUploadResult>(this, result){
            final /* synthetic */ SendFileEndpoint this$0;
            final /* synthetic */ AtomicReference<FileUploadRequestDetails> $result;
            {
                this.this$0 = $receiver;
                this.$result = $result;
                super(1);
            }

            @NotNull
            public final PNFileUploadResult invoke(@NotNull PNPublishFileMessageResult it) {
                Intrinsics.checkNotNullParameter(it, "it");
                FileUploadRequestDetails fileUploadRequestDetails = this.$result.get();
                Intrinsics.checkNotNullExpressionValue(fileUploadRequestDetails, "result.get()");
                return SendFileEndpoint.access$mapPublishFileMessageToFileUpload(this.this$0, fileUploadRequestDetails, it);
            }
        });
    }

    private final PNFileUploadResult mapPublishFileMessageToFileUpload(FileUploadRequestDetails requestDetails, PNPublishFileMessageResult res) {
        return new PNFileUploadResult(res.getTimetoken(), 200, new PNBaseFile(requestDetails.getData().getId(), requestDetails.getData().getName()));
    }

    @Override
    public void retry() {
        this.sendFileMultistepAction.retry();
    }

    @Override
    public void silentCancel() {
        this.sendFileMultistepAction.silentCancel();
    }

    @Override
    @NotNull
    public PNOperationType operationType() {
        return PNOperationType.FileOperation;
    }

    private static final void async$lambda$0(SendFileEndpoint this$0, Consumer $callback) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($callback, "$callback");
        try {
            this$0.validate();
            this$0.sendFileMultistepAction.async($callback);
        }
        catch (PubNubException ex) {
            $callback.accept(Result.Companion.failure(ex));
        }
    }

    public static final /* synthetic */ String access$getFileName$p(SendFileEndpoint $this) {
        return $this.fileName;
    }

    public static final /* synthetic */ String access$getChannel$p(SendFileEndpoint $this) {
        return $this.channel;
    }

    public static final /* synthetic */ Object access$getMessage$p(SendFileEndpoint $this) {
        return $this.message;
    }

    public static final /* synthetic */ Object access$getMeta$p(SendFileEndpoint $this) {
        return $this.meta;
    }

    public static final /* synthetic */ Integer access$getTtl$p(SendFileEndpoint $this) {
        return $this.ttl;
    }

    public static final /* synthetic */ Boolean access$getShouldStore$p(SendFileEndpoint $this) {
        return $this.shouldStore;
    }

    public static final /* synthetic */ int access$getFileMessagePublishRetryLimit$p(SendFileEndpoint $this) {
        return $this.fileMessagePublishRetryLimit;
    }

    public static final /* synthetic */ ExecutorService access$getExecutorService$p(SendFileEndpoint $this) {
        return $this.executorService;
    }

    public static final /* synthetic */ PNFileUploadResult access$mapPublishFileMessageToFileUpload(SendFileEndpoint $this, FileUploadRequestDetails requestDetails, PNPublishFileMessageResult res) {
        return $this.mapPublishFileMessageToFileUpload(requestDetails, res);
    }
}

