/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.endpoints.files;

import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.endpoints.remoteaction.ExtendedRemoteAction;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.v2.callbacks.Result;
import com.pubnub.internal.PubNubCore;
import com.pubnub.internal.models.server.files.FileUploadRequestDetails;
import com.pubnub.internal.models.server.files.FormField;
import com.pubnub.internal.services.S3Service;
import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import javax.net.ssl.SSLException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u0000 $2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002$%B;\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\f\u0012\u0006\u0010\r\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u000eJ\u001c\u0010\u0011\u001a\u00020\u00022\u0012\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00140\u0013H\u0016J\u0016\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u0018H\u0002J\u0012\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0006H\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010H\u0002J\b\u0010\u001f\u001a\u00020\u0002H\u0016J\b\u0010 \u001a\u00020\u0002H\u0016J\b\u0010!\u001a\u00020\u0002H\u0016J\u0014\u0010\"\u001a\u0004\u0018\u00010\u0006*\b\u0012\u0004\u0012\u00020\n0\fH\u0002J\u0012\u0010#\u001a\u00020\u0006*\b\u0012\u0004\u0012\u00020\u00020\u0018H\u0002R\u000e\u0010\r\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/pubnub/internal/endpoints/files/UploadFileEndpoint;", "Lcom/pubnub/api/endpoints/remoteaction/ExtendedRemoteAction;", "", "s3Service", "Lcom/pubnub/internal/services/S3Service;", "fileName", "", "content", "", "key", "Lcom/pubnub/internal/models/server/files/FormField;", "formParams", "", "baseUrl", "(Lcom/pubnub/internal/services/S3Service;Ljava/lang/String;[BLcom/pubnub/internal/models/server/files/FormField;Ljava/util/List;Ljava/lang/String;)V", "call", "Lretrofit2/Call;", "async", "callback", "Ljava/util/function/Consumer;", "Lcom/pubnub/api/v2/callbacks/Result;", "createException", "Lcom/pubnub/api/PubNubException;", "response", "Lretrofit2/Response;", "getMediaType", "Lokhttp3/MediaType;", "contentType", "operationType", "Lcom/pubnub/api/enums/PNOperationType;", "prepareCall", "retry", "silentCancel", "sync", "findContentType", "readErrorMessage", "Companion", "Factory", "pubnub-core-impl"})
@SourceDebugExtension(value={"SMAP\nUploadFileEndpoint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UploadFileEndpoint.kt\ncom/pubnub/internal/endpoints/files/UploadFileEndpoint\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,209:1\n1#2:210\n*E\n"})
public final class UploadFileEndpoint
implements ExtendedRemoteAction<Unit> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final S3Service s3Service;
    @NotNull
    private final String fileName;
    @NotNull
    private final byte[] content;
    @NotNull
    private final FormField key;
    @NotNull
    private final List<FormField> formParams;
    @NotNull
    private final String baseUrl;
    @Nullable
    private Call<Unit> call;
    @NotNull
    private static final MediaType APPLICATION_OCTET_STREAM = MediaType.Companion.get("application/octet-stream");
    @NotNull
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    @NotNull
    private static final String FILE_PART_MULTIPART = "file";
    private static final Logger log = LoggerFactory.getLogger(UploadFileEndpoint.class);

    public UploadFileEndpoint(@NotNull S3Service s3Service, @NotNull String fileName, @NotNull byte[] content, @NotNull FormField key, @NotNull List<FormField> formParams, @NotNull String baseUrl) {
        Intrinsics.checkNotNullParameter(s3Service, "s3Service");
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        Intrinsics.checkNotNullParameter(content, "content");
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(formParams, "formParams");
        Intrinsics.checkNotNullParameter(baseUrl, "baseUrl");
        this.s3Service = s3Service;
        this.fileName = fileName;
        this.content = content;
        this.key = key;
        this.formParams = formParams;
        this.baseUrl = baseUrl;
    }

    private final Call<Unit> prepareCall() throws PubNubException {
        MultipartBody.Builder builder2 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
        UploadFileEndpoint.Companion.addFormParamsWithKeyFirst(this.key, this.formParams, builder2);
        MediaType mediaType = this.getMediaType(this.findContentType(this.formParams));
        builder2.addFormDataPart(FILE_PART_MULTIPART, this.fileName, RequestBody.Companion.create(this.content, mediaType, 0, this.content.length));
        return this.s3Service.upload(this.baseUrl, builder2.build());
    }

    private final String findContentType(List<FormField> $this$findContentType) {
        Object v0;
        block1: {
            Iterable iterable = $this$findContentType;
            for (Object t : iterable) {
                FormField formField = (FormField)t;
                boolean bl = false;
                String key = formField.component1();
                if (!StringsKt.equals(key, CONTENT_TYPE_HEADER, true)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        FormField formField = v0;
        return formField != null ? formField.getValue() : null;
    }

    private final MediaType getMediaType(String contentType) {
        MediaType mediaType;
        if (contentType == null) {
            mediaType = APPLICATION_OCTET_STREAM;
        } else {
            MediaType mediaType2;
            try {
                mediaType2 = MediaType.Companion.get(contentType);
            }
            catch (Throwable t) {
                log.warn("Content-Type: " + contentType + " was not recognized by MediaType.get", t);
                mediaType2 = APPLICATION_OCTET_STREAM;
            }
            mediaType = mediaType2;
        }
        return mediaType;
    }

    @Override
    public void sync() throws PubNubException {
        Response<Unit> response;
        this.call = this.prepareCall();
        try {
            Call<Unit> call = this.call;
            Intrinsics.checkNotNull(call);
            response = call.execute();
        }
        catch (IOException e) {
            String string = e.getMessage();
            Call<Unit> call = this.call;
            PubNubError pubNubError = PubNubError.PARSING_ERROR;
            throw new PubNubException(string, pubNubError, null, 0, call, null, null, null, e, null, null, 1772, null);
        }
        Response<Unit> serverResponse = response;
        if (!serverResponse.isSuccessful()) {
            Intrinsics.checkNotNullExpressionValue(serverResponse, "serverResponse");
            throw this.createException(serverResponse);
        }
    }

    @Override
    public void async(@NotNull Consumer<Result<Unit>> callback) {
        Intrinsics.checkNotNullParameter(callback, "callback");
        try {
            Call<Unit> call = this.call = this.prepareCall();
            Intrinsics.checkNotNull(call);
            call.enqueue(new Callback<Unit>(this, callback){
                final /* synthetic */ UploadFileEndpoint this$0;
                final /* synthetic */ Consumer<Result<Unit>> $callback;
                {
                    this.this$0 = $receiver;
                    this.$callback = $callback;
                }

                public void onResponse(@NotNull Call<Unit> performedCall, @NotNull Response<Unit> response) {
                    Intrinsics.checkNotNullParameter(performedCall, "performedCall");
                    Intrinsics.checkNotNullParameter(response, "response");
                    if (!response.isSuccessful()) {
                        PubNubException ex = UploadFileEndpoint.access$createException(this.this$0, response);
                        this.$callback.accept(Result.Companion.failure(ex));
                        return;
                    }
                    this.$callback.accept(Result.Companion.success(Unit.INSTANCE));
                }

                public void onFailure(@NotNull Call<Unit> performedCall, @NotNull Throwable throwable) {
                    Intrinsics.checkNotNullParameter(performedCall, "performedCall");
                    Intrinsics.checkNotNullParameter(throwable, "throwable");
                    Call call = UploadFileEndpoint.access$getCall$p(this.this$0);
                    Intrinsics.checkNotNull(call);
                    if (call.isCanceled()) {
                        return;
                    }
                    Throwable throwable2 = throwable;
                    PubNubError error = ((throwable2 instanceof UnknownHostException ? true : throwable2 instanceof SocketException) ? true : throwable2 instanceof SSLException) ? PubNubError.CONNECT_EXCEPTION : (throwable2 instanceof SocketTimeoutException ? PubNubError.SUBSCRIBE_TIMEOUT : (performedCall.isCanceled() ? PubNubError.HTTP_ERROR : PubNubError.HTTP_ERROR));
                    PubNubException pubNubException = new PubNubException(error);
                    String string = throwable.getMessage();
                    if (string == null) {
                        string = error.getMessage();
                    }
                    this.$callback.accept(Result.Companion.failure(PubNubException.copy$default(pubNubException, string, null, null, 0, null, null, null, null, throwable, null, null, 1790, null)));
                }
            });
        }
        catch (Throwable e) {
            callback.accept(Result.Companion.failure(PubNubException.Companion.from(e)));
        }
    }

    @Override
    public void retry() {
    }

    @Override
    public void silentCancel() {
        Call<Unit> call = this.call;
        Intrinsics.checkNotNull(call);
        if (!call.isCanceled()) {
            Call<Unit> call2 = this.call;
            Intrinsics.checkNotNull(call2);
            call2.cancel();
        }
    }

    private final PubNubException createException(Response<Unit> response) {
        Object object;
        try {
            object = this.readErrorMessage(response);
            Call<Unit> call = this.call;
            int n = response.code();
            object = new PubNubException((String)object, null, null, n, call, null, null, null, null, null, null, 2022, null);
        }
        catch (Exception e) {
            String string = e.getMessage();
            Call<Unit> call = this.call;
            int n = response.code();
            object = new PubNubException(string, null, null, n, call, null, null, null, null, null, null, 2022, null);
        }
        return object;
    }

    private final String readErrorMessage(Response<Unit> $this$readErrorMessage) {
        String string;
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        dbFactory.setXIncludeAware(false);
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        ResponseBody responseBody = $this$readErrorMessage.errorBody();
        Intrinsics.checkNotNull(responseBody);
        Document doc = dBuilder.parse(responseBody.byteStream());
        doc.getDocumentElement().normalize();
        NodeList elements = doc.getElementsByTagName("Message");
        Node node = elements.item(0);
        if ((node != null && (node = node.getFirstChild()) != null ? node.getNodeValue() : (string = null)) == null) {
            string = "N/A";
        }
        return string;
    }

    @Override
    @NotNull
    public PNOperationType operationType() {
        return PNOperationType.FileOperation;
    }

    public static final /* synthetic */ PubNubException access$createException(UploadFileEndpoint $this, Response response) {
        return $this.createException(response);
    }

    public static final /* synthetic */ Call access$getCall$p(UploadFileEndpoint $this) {
        return $this.call;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/pubnub/internal/endpoints/files/UploadFileEndpoint$Companion;", "", "()V", "APPLICATION_OCTET_STREAM", "Lokhttp3/MediaType;", "CONTENT_TYPE_HEADER", "", "FILE_PART_MULTIPART", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "addFormParamsWithKeyFirst", "", "keyValue", "Lcom/pubnub/internal/models/server/files/FormField;", "formParams", "", "builder", "Lokhttp3/MultipartBody$Builder;", "pubnub-core-impl"})
    @SourceDebugExtension(value={"SMAP\nUploadFileEndpoint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UploadFileEndpoint.kt\ncom/pubnub/internal/endpoints/files/UploadFileEndpoint$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,209:1\n766#2:210\n857#2,2:211\n1855#2,2:213\n*S KotlinDebug\n*F\n+ 1 UploadFileEndpoint.kt\ncom/pubnub/internal/endpoints/files/UploadFileEndpoint$Companion\n*L\n202#1:210\n202#1:211,2\n203#1:213,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final void addFormParamsWithKeyFirst(FormField keyValue, List<FormField> formParams, MultipartBody.Builder builder2) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            builder2.addFormDataPart(keyValue.getKey(), keyValue.getValue());
            Iterable iterable = formParams;
            boolean $i$f$filter = false;
            Iterator iterator2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                FormField it = (FormField)element$iv$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual(it.getKey(), keyValue.getKey()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FormField it = (FormField)element$iv;
                boolean bl = false;
                builder2.addFormDataPart(it.getKey(), it.getValue());
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/pubnub/internal/endpoints/files/UploadFileEndpoint$Factory;", "", "pubNub", "Lcom/pubnub/internal/PubNubCore;", "(Lcom/pubnub/internal/PubNubCore;)V", "create", "Lcom/pubnub/api/endpoints/remoteaction/ExtendedRemoteAction;", "", "fileName", "", "content", "", "fileUploadRequestDetails", "Lcom/pubnub/internal/models/server/files/FileUploadRequestDetails;", "pubnub-core-impl"})
    public static final class Factory {
        @NotNull
        private final PubNubCore pubNub;

        public Factory(@NotNull PubNubCore pubNub) {
            Intrinsics.checkNotNullParameter(pubNub, "pubNub");
            this.pubNub = pubNub;
        }

        @NotNull
        public final ExtendedRemoteAction<Unit> create(@NotNull String fileName, @NotNull byte[] content, @NotNull FileUploadRequestDetails fileUploadRequestDetails) {
            Intrinsics.checkNotNullParameter(fileName, "fileName");
            Intrinsics.checkNotNullParameter(content, "content");
            Intrinsics.checkNotNullParameter(fileUploadRequestDetails, "fileUploadRequestDetails");
            return new UploadFileEndpoint(this.pubNub.getRetrofitManager$pubnub_core_impl().getS3Service$pubnub_core_impl(), fileName, content, fileUploadRequestDetails.getKeyFormField(), fileUploadRequestDetails.getFormFields(), fileUploadRequestDetails.getUrl());
        }
    }
}

