/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.endpoints.message_actions;

import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.models.consumer.message_actions.PNRemoveMessageActionResult;
import com.pubnub.api.retry.RetryableEndpointGroup;
import com.pubnub.internal.EndpointCore;
import com.pubnub.internal.PubNubCore;
import com.pubnub.internal.endpoints.message_actions.RemoveMessageActionInterface;
import com.pubnub.internal.services.MessageActionService;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004B'\b\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\u0012\u001a\u00020\u00032\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0014H\u0014J2\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u00162\"\u0010\u0017\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0018j\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b`\u0019H\u0014J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\u001bH\u0014J\b\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0014R\u0014\u0010\u000b\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000e\u00a8\u0006\""}, d2={"Lcom/pubnub/internal/endpoints/message_actions/RemoveMessageActionEndpoint;", "Lcom/pubnub/internal/EndpointCore;", "Ljava/lang/Void;", "Lcom/pubnub/api/models/consumer/message_actions/PNRemoveMessageActionResult;", "Lcom/pubnub/internal/endpoints/message_actions/RemoveMessageActionInterface;", "pubnub", "Lcom/pubnub/internal/PubNubCore;", "channel", "", "messageTimetoken", "", "actionTimetoken", "(Lcom/pubnub/internal/PubNubCore;Ljava/lang/String;JJ)V", "getActionTimetoken", "()J", "getChannel", "()Ljava/lang/String;", "getMessageTimetoken", "createResponse", "input", "Lretrofit2/Response;", "doWork", "Lretrofit2/Call;", "queryParams", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getAffectedChannels", "", "getEndpointGroupName", "Lcom/pubnub/api/retry/RetryableEndpointGroup;", "operationType", "Lcom/pubnub/api/enums/PNOperationType$PNDeleteMessageAction;", "validateParams", "", "pubnub-core-impl"})
public final class RemoveMessageActionEndpoint
extends EndpointCore<Void, PNRemoveMessageActionResult>
implements RemoveMessageActionInterface {
    @NotNull
    private final String channel;
    private final long messageTimetoken;
    private final long actionTimetoken;

    public RemoveMessageActionEndpoint(@NotNull PubNubCore pubnub, @NotNull String channel, long messageTimetoken, long actionTimetoken) {
        Intrinsics.checkNotNullParameter(pubnub, "pubnub");
        Intrinsics.checkNotNullParameter(channel, "channel");
        super(pubnub);
        this.channel = channel;
        this.messageTimetoken = messageTimetoken;
        this.actionTimetoken = actionTimetoken;
    }

    @Override
    @NotNull
    public String getChannel() {
        return this.channel;
    }

    @Override
    public long getMessageTimetoken() {
        return this.messageTimetoken;
    }

    @Override
    public long getActionTimetoken() {
        return this.actionTimetoken;
    }

    @Override
    protected void validateParams() {
        super.validateParams();
        if (StringsKt.isBlank(this.getChannel())) {
            throw new PubNubException(PubNubError.CHANNEL_MISSING);
        }
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannels() {
        return CollectionsKt.listOf(this.getChannel());
    }

    @Override
    @NotNull
    protected Call<Void> doWork(@NotNull HashMap<String, String> queryParams) {
        Intrinsics.checkNotNullParameter(queryParams, "queryParams");
        MessageActionService messageActionService = this.getRetrofitManager().getMessageActionService$pubnub_core_impl();
        String string = this.getConfiguration().getSubscribeKey();
        String string2 = this.getChannel();
        String string3 = String.valueOf(this.getMessageTimetoken());
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue(locale, "getDefault()");
        String string4 = string3.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue(string4, "this as java.lang.String).toLowerCase(locale)");
        string3 = String.valueOf(this.getActionTimetoken());
        Locale locale2 = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue(locale2, "getDefault()");
        String string5 = string3.toLowerCase(locale2);
        Intrinsics.checkNotNullExpressionValue(string5, "this as java.lang.String).toLowerCase(locale)");
        return messageActionService.deleteMessageAction(string, string2, string4, string5, (Map<String, String>)queryParams);
    }

    @Override
    @NotNull
    protected PNRemoveMessageActionResult createResponse(@NotNull Response<Void> input) {
        Intrinsics.checkNotNullParameter(input, "input");
        return new PNRemoveMessageActionResult();
    }

    @Override
    @NotNull
    public PNOperationType.PNDeleteMessageAction operationType() {
        return PNOperationType.PNDeleteMessageAction;
    }

    @Override
    @NotNull
    protected RetryableEndpointGroup getEndpointGroupName() {
        return RetryableEndpointGroup.MESSAGE_REACTION;
    }
}

