/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.endpoints.objects_api.members;

import com.pubnub.api.endpoints.objects_api.members.ManageChannelMembers;
import com.pubnub.api.endpoints.objects_api.utils.Include;
import com.pubnub.api.endpoints.objects_api.utils.ObjectsBuilderSteps;
import com.pubnub.api.endpoints.objects_api.utils.PNSortKey;
import com.pubnub.api.endpoints.remoteaction.ExtendedRemoteAction;
import com.pubnub.api.endpoints.remoteaction.MappingRemoteAction;
import com.pubnub.api.models.consumer.objects.PNPage;
import com.pubnub.api.models.consumer.objects_api.member.PNManageChannelMembersResult;
import com.pubnub.api.models.consumer.objects_api.member.PNUUID;
import com.pubnub.internal.EndpointInterface;
import com.pubnub.internal.PubNubCore;
import com.pubnub.internal.endpoints.DelegatingEndpoint;
import com.pubnub.internal.endpoints.objects_api.members.SetChannelMembersImpl;
import com.pubnub.internal.models.consumer.objects.member.PNMember;
import com.pubnub.internal.models.consumer.objects.member.PNMemberArrayResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class ManageChannelMembersImpl
extends DelegatingEndpoint<PNMemberArrayResult, PNManageChannelMembersResult>
implements ManageChannelMembers {
    private Integer limit = null;
    private PNPage page;
    private String filter;
    private Collection<PNSortKey> sort = Collections.emptyList();
    private boolean includeTotalCount;
    private boolean includeCustom;
    private final String channel;
    private Include.PNUUIDDetailsLevel includeUUID;
    private final Collection<PNUUID> uuidsToSet;
    private final Collection<PNUUID> uuidsToRemove;

    public ManageChannelMembersImpl(String channel, Collection<PNUUID> uuidsToSet, Collection<PNUUID> uuidsToRemove, PubNubCore pubnubInstance) {
        super(pubnubInstance);
        this.channel = channel;
        this.uuidsToSet = uuidsToSet;
        this.uuidsToRemove = uuidsToRemove;
    }

    @Override
    @NotNull
    protected ExtendedRemoteAction<PNManageChannelMembersResult> mapResult(@NotNull ExtendedRemoteAction<PNMemberArrayResult> action) {
        return new MappingRemoteAction<PNMemberArrayResult, PNManageChannelMembersResult>(action, PNManageChannelMembersResult::from);
    }

    @Override
    @NotNull
    protected EndpointInterface<PNMemberArrayResult> createAction() {
        ArrayList<String> toRemove = new ArrayList<String>(this.uuidsToRemove.size());
        for (PNUUID pnuuid : this.uuidsToRemove) {
            toRemove.add(pnuuid.getUuid().getId());
        }
        ArrayList<PNMember.Partial> toSet = new ArrayList<PNMember.Partial>(this.uuidsToSet.size());
        for (PNUUID pnuuid : this.uuidsToSet) {
            toSet.add(new PNMember.Partial(pnuuid.getUuid().getId(), pnuuid instanceof PNUUID.UUIDWithCustom ? ((PNUUID.UUIDWithCustom)pnuuid).getCustom() : null, pnuuid.getStatus()));
        }
        return this.pubnub.manageChannelMembers(this.channel, toSet, toRemove, this.limit, this.page, this.filter, SetChannelMembersImpl.toInternal(this.sort), this.includeTotalCount, this.includeCustom, SetChannelMembersImpl.toInternal(this.includeUUID));
    }

    @Override
    public ManageChannelMembersImpl limit(Integer limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public ManageChannelMembersImpl page(PNPage page) {
        this.page = page;
        return this;
    }

    @Override
    public ManageChannelMembersImpl filter(String filter) {
        this.filter = filter;
        return this;
    }

    @Override
    public ManageChannelMembersImpl sort(Collection<PNSortKey> sort) {
        this.sort = sort;
        return this;
    }

    @Override
    public ManageChannelMembersImpl includeTotalCount(boolean includeTotalCount) {
        this.includeTotalCount = includeTotalCount;
        return this;
    }

    @Override
    public ManageChannelMembersImpl includeCustom(boolean includeCustom) {
        this.includeCustom = includeCustom;
        return this;
    }

    @Override
    public ManageChannelMembersImpl includeUUID(Include.PNUUIDDetailsLevel includeUUID) {
        this.includeUUID = includeUUID;
        return this;
    }

    public static class Builder
    implements ManageChannelMembers.Builder {
        private final PubNubCore pubnubInstance;

        @Override
        public ObjectsBuilderSteps.RemoveOrSetStep<ManageChannelMembers, PNUUID> channel(final String channel) {
            return new ObjectsBuilderSteps.RemoveOrSetStep<ManageChannelMembers, PNUUID>(){

                @Override
                public ObjectsBuilderSteps.RemoveOrSetStep.RemoveStep<ManageChannelMembers, PNUUID> set(final Collection<PNUUID> uuidsToSet) {
                    return new ObjectsBuilderSteps.RemoveOrSetStep.RemoveStep<ManageChannelMembers, PNUUID>(){

                        @Override
                        public ManageChannelMembers remove(Collection<PNUUID> uuidsToRemove) {
                            return new ManageChannelMembersImpl(channel, uuidsToSet, uuidsToRemove, pubnubInstance);
                        }
                    };
                }

                @Override
                public ObjectsBuilderSteps.RemoveOrSetStep.SetStep<ManageChannelMembers, PNUUID> remove(final Collection<PNUUID> uuidsToRemove) {
                    return new ObjectsBuilderSteps.RemoveOrSetStep.SetStep<ManageChannelMembers, PNUUID>(){

                        @Override
                        public ManageChannelMembers set(Collection<PNUUID> uuidsToSet) {
                            return new ManageChannelMembersImpl(channel, uuidsToSet, uuidsToRemove, pubnubInstance);
                        }
                    };
                }
            };
        }

        public Builder(PubNubCore pubnubInstance) {
            this.pubnubInstance = pubnubInstance;
        }
    }
}

