/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.endpoints.objects_api.members;

import com.pubnub.api.endpoints.objects_api.members.SetChannelMembers;
import com.pubnub.api.endpoints.objects_api.utils.Include;
import com.pubnub.api.endpoints.objects_api.utils.ObjectsBuilderSteps;
import com.pubnub.api.endpoints.objects_api.utils.PNSortKey;
import com.pubnub.api.endpoints.remoteaction.ExtendedRemoteAction;
import com.pubnub.api.endpoints.remoteaction.MappingRemoteAction;
import com.pubnub.api.models.consumer.objects.PNPage;
import com.pubnub.api.models.consumer.objects_api.member.PNSetChannelMembersResult;
import com.pubnub.api.models.consumer.objects_api.member.PNUUID;
import com.pubnub.internal.EndpointInterface;
import com.pubnub.internal.PubNubCore;
import com.pubnub.internal.endpoints.DelegatingEndpoint;
import com.pubnub.internal.models.consumer.objects.PNMemberKey;
import com.pubnub.internal.models.consumer.objects.PNSortKey;
import com.pubnub.internal.models.consumer.objects.member.PNMember;
import com.pubnub.internal.models.consumer.objects.member.PNMemberArrayResult;
import com.pubnub.internal.models.consumer.objects.member.PNUUIDDetailsLevel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SetChannelMembersImpl
extends DelegatingEndpoint<PNMemberArrayResult, PNSetChannelMembersResult>
implements SetChannelMembers {
    private Integer limit = null;
    private PNPage page;
    private String filter;
    private Collection<PNSortKey> sort = Collections.emptyList();
    private boolean includeTotalCount;
    private boolean includeCustom;
    private Include.PNUUIDDetailsLevel includeUUID;
    private final String channel;
    private final Collection<PNUUID> uuids;

    public SetChannelMembersImpl(PubNubCore pubnubInstance, String channel, Collection<PNUUID> uuids) {
        super(pubnubInstance);
        this.channel = channel;
        this.uuids = uuids;
    }

    @Override
    @NotNull
    protected ExtendedRemoteAction<PNSetChannelMembersResult> mapResult(@NotNull ExtendedRemoteAction<PNMemberArrayResult> action) {
        return new MappingRemoteAction<PNMemberArrayResult, PNSetChannelMembersResult>(action, PNSetChannelMembersResult::from);
    }

    @Override
    @NotNull
    protected EndpointInterface<PNMemberArrayResult> createAction() {
        ArrayList<PNMember.Partial> memberInputs = new ArrayList<PNMember.Partial>(this.uuids.size());
        for (PNUUID uuid : this.uuids) {
            memberInputs.add(new PNMember.Partial(uuid.getUuid().getId(), uuid instanceof PNUUID.UUIDWithCustom ? ((PNUUID.UUIDWithCustom)uuid).getCustom() : null, uuid.getStatus()));
        }
        return this.pubnub.setChannelMembers(this.channel, memberInputs, this.limit, this.page, this.filter, SetChannelMembersImpl.toInternal(this.sort), this.includeTotalCount, this.includeCustom, SetChannelMembersImpl.toInternal(this.includeUUID));
    }

    static Collection<? extends com.pubnub.internal.models.consumer.objects.PNSortKey<PNMemberKey>> toInternal(Collection<PNSortKey> sort) {
        ArrayList<com.pubnub.internal.models.consumer.objects.PNSortKey> list = new ArrayList<com.pubnub.internal.models.consumer.objects.PNSortKey>(sort.size());
        for (PNSortKey pnSortKey : sort) {
            PNMemberKey key = null;
            switch (pnSortKey.getKey()) {
                case ID: {
                    key = PNMemberKey.UUID_ID;
                    break;
                }
                case NAME: {
                    key = PNMemberKey.UUID_NAME;
                    break;
                }
                case UPDATED: {
                    key = PNMemberKey.UUID_UPDATED;
                    break;
                }
                default: {
                    throw new IllegalStateException("Should never happen");
                }
            }
            if (pnSortKey.getDir().equals((Object)PNSortKey.Dir.ASC)) {
                list.add(new PNSortKey.PNAsc<PNMemberKey>(key));
                continue;
            }
            list.add(new PNSortKey.PNDesc<PNMemberKey>(key));
        }
        return list;
    }

    @Nullable
    static PNUUIDDetailsLevel toInternal(Include.PNUUIDDetailsLevel detailLevel) {
        if (detailLevel == null) {
            return null;
        }
        switch (detailLevel) {
            case UUID: {
                return PNUUIDDetailsLevel.UUID;
            }
            case UUID_WITH_CUSTOM: {
                return PNUUIDDetailsLevel.UUID_WITH_CUSTOM;
            }
        }
        throw new IllegalStateException("Unknown detail level: " + (Object)((Object)detailLevel));
    }

    @Override
    public SetChannelMembersImpl limit(Integer limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public SetChannelMembersImpl page(PNPage page) {
        this.page = page;
        return this;
    }

    @Override
    public SetChannelMembersImpl filter(String filter) {
        this.filter = filter;
        return this;
    }

    @Override
    public SetChannelMembersImpl sort(Collection<PNSortKey> sort) {
        this.sort = sort;
        return this;
    }

    @Override
    public SetChannelMembersImpl includeTotalCount(boolean includeTotalCount) {
        this.includeTotalCount = includeTotalCount;
        return this;
    }

    @Override
    public SetChannelMembersImpl includeCustom(boolean includeCustom) {
        this.includeCustom = includeCustom;
        return this;
    }

    @Override
    public SetChannelMembersImpl includeUUID(Include.PNUUIDDetailsLevel includeUUID) {
        this.includeUUID = includeUUID;
        return this;
    }

    public static class Builder
    implements SetChannelMembers.Builder {
        private final PubNubCore pubnubInstance;

        @Override
        public ObjectsBuilderSteps.UUIDsStep<SetChannelMembers> channel(final String channel) {
            return new ObjectsBuilderSteps.UUIDsStep<SetChannelMembers>(){

                @Override
                public SetChannelMembers uuids(@NotNull Collection<PNUUID> uuids) {
                    return new SetChannelMembersImpl(pubnubInstance, channel, uuids);
                }
            };
        }

        public Builder(PubNubCore pubnubInstance) {
            this.pubnubInstance = pubnubInstance;
        }
    }
}

