/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.endpoints.presence;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.models.consumer.presence.PNSetStateResult;
import com.pubnub.api.retry.RetryableEndpointGroup;
import com.pubnub.internal.EndpointCore;
import com.pubnub.internal.PubNubCore;
import com.pubnub.internal.PubNubUtilKt;
import com.pubnub.internal.endpoints.presence.SetStateInterface;
import com.pubnub.internal.models.server.Envelope;
import com.pubnub.internal.presence.eventengine.data.PresenceData;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0004\u0012\u00020\u00040\u00012\u00020\u0005BE\b\u0000\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\n\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u001c\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u001cH\u0002J\u001c\u0010\u001d\u001a\u00020\u00042\u0012\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u001fH\u0014J8\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020!2\"\u0010\u001b\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\"j\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n`#H\u0014J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0014J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0014J\b\u0010&\u001a\u00020'H\u0014J\b\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020\u001aH\u0014R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u000e\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006+"}, d2={"Lcom/pubnub/internal/endpoints/presence/SetStateEndpoint;", "Lcom/pubnub/internal/EndpointCore;", "Lcom/pubnub/internal/models/server/Envelope;", "Lcom/google/gson/JsonElement;", "Lcom/pubnub/api/models/consumer/presence/PNSetStateResult;", "Lcom/pubnub/internal/endpoints/presence/SetStateInterface;", "pubnub", "Lcom/pubnub/internal/PubNubCore;", "channels", "", "", "channelGroups", "state", "", "uuid", "presenceData", "Lcom/pubnub/internal/presence/eventengine/data/PresenceData;", "(Lcom/pubnub/internal/PubNubCore;Ljava/util/List;Ljava/util/List;Ljava/lang/Object;Ljava/lang/String;Lcom/pubnub/internal/presence/eventengine/data/PresenceData;)V", "getChannelGroups", "()Ljava/util/List;", "getChannels", "getState", "()Ljava/lang/Object;", "getUuid", "()Ljava/lang/String;", "addQueryParams", "", "queryParams", "", "createResponse", "input", "Lretrofit2/Response;", "doWork", "Lretrofit2/Call;", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getAffectedChannelGroups", "getAffectedChannels", "getEndpointGroupName", "Lcom/pubnub/api/retry/RetryableEndpointGroup;", "operationType", "Lcom/pubnub/api/enums/PNOperationType$PNSetStateOperation;", "validateParams", "pubnub-core-impl"})
@SourceDebugExtension(value={"SMAP\nSetStateEndpoint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SetStateEndpoint.kt\ncom/pubnub/internal/endpoints/presence/SetStateEndpoint\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,74:1\n1271#2,2:75\n1285#2,4:77\n*S KotlinDebug\n*F\n+ 1 SetStateEndpoint.kt\ncom/pubnub/internal/endpoints/presence/SetStateEndpoint\n*L\n43#1:75,2\n43#1:77,4\n*E\n"})
public final class SetStateEndpoint
extends EndpointCore<Envelope<JsonElement>, PNSetStateResult>
implements SetStateInterface {
    @NotNull
    private final List<String> channels;
    @NotNull
    private final List<String> channelGroups;
    @NotNull
    private final Object state;
    @NotNull
    private final String uuid;
    @NotNull
    private final PresenceData presenceData;

    public SetStateEndpoint(@NotNull PubNubCore pubnub, @NotNull List<String> channels, @NotNull List<String> channelGroups, @NotNull Object state, @NotNull String uuid, @NotNull PresenceData presenceData) {
        Intrinsics.checkNotNullParameter(pubnub, "pubnub");
        Intrinsics.checkNotNullParameter(channels, "channels");
        Intrinsics.checkNotNullParameter(channelGroups, "channelGroups");
        Intrinsics.checkNotNullParameter(state, "state");
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        Intrinsics.checkNotNullParameter(presenceData, "presenceData");
        super(pubnub);
        this.channels = channels;
        this.channelGroups = channelGroups;
        this.state = state;
        this.uuid = uuid;
        this.presenceData = presenceData;
    }

    public /* synthetic */ SetStateEndpoint(PubNubCore pubNubCore, List list, List list2, Object object, String string, PresenceData presenceData, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            string = pubNubCore.getConfiguration().getUserId().getValue();
        }
        this(pubNubCore, list, list2, object, string, presenceData);
    }

    @Override
    @NotNull
    public List<String> getChannels() {
        return this.channels;
    }

    @Override
    @NotNull
    public List<String> getChannelGroups() {
        return this.channelGroups;
    }

    @Override
    @NotNull
    public Object getState() {
        return this.state;
    }

    @Override
    @NotNull
    public String getUuid() {
        return this.uuid;
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannels() {
        return this.getChannels();
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannelGroups() {
        return this.getChannelGroups();
    }

    @Override
    protected void validateParams() {
        super.validateParams();
        if (this.getChannels().isEmpty() && this.getChannelGroups().isEmpty()) {
            throw new PubNubException(PubNubError.CHANNEL_AND_GROUP_MISSING);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected Call<Envelope<JsonElement>> doWork(@NotNull HashMap<String, String> queryParams) {
        Intrinsics.checkNotNullParameter(queryParams, "queryParams");
        if (Intrinsics.areEqual(this.getUuid(), this.getPubnub().getConfiguration().getUserId().getValue())) {
            void $this$associateWith$iv;
            JsonElement stateCopy = this.getPubnub().getMapper().fromJson(this.getPubnub().getMapper().toJson(this.getState()), JsonElement.class);
            Iterable iterable = this.getChannels();
            ConcurrentHashMap<String, Object> concurrentHashMap = this.presenceData.getChannelStates$pubnub_core_impl();
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateWith$iv, 10)), 16));
            void $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                String string = (String)element$iv$iv;
                Object t = element$iv$iv;
                Map map = result$iv;
                boolean bl = false;
                JsonElement jsonElement = stateCopy;
                map.put(t, jsonElement);
            }
            concurrentHashMap.putAll(result$iv);
        }
        this.addQueryParams((Map<String, String>)queryParams);
        return this.getRetrofitManager().getPresenceService$pubnub_core_impl().setState(this.getConfiguration().getSubscribeKey(), PubNubUtilKt.toCsv(this.getChannels()), this.getUuid(), (Map<String, String>)queryParams);
    }

    @Override
    @NotNull
    protected PNSetStateResult createResponse(@NotNull Response<Envelope<JsonElement>> input) {
        Intrinsics.checkNotNullParameter(input, "input");
        Envelope<JsonElement> envelope = input.body();
        Intrinsics.checkNotNull(envelope);
        JsonElement jsonElement = envelope.getPayload$pubnub_core_impl();
        Intrinsics.checkNotNull(jsonElement);
        if (jsonElement instanceof JsonNull) {
            throw new PubNubException(PubNubError.PARSING_ERROR);
        }
        Envelope<JsonElement> envelope2 = input.body();
        Intrinsics.checkNotNull(envelope2);
        JsonElement jsonElement2 = envelope2.getPayload$pubnub_core_impl();
        Intrinsics.checkNotNull(jsonElement2);
        return new PNSetStateResult(jsonElement2);
    }

    @Override
    @NotNull
    public PNOperationType.PNSetStateOperation operationType() {
        return PNOperationType.PNSetStateOperation;
    }

    @Override
    @NotNull
    protected RetryableEndpointGroup getEndpointGroupName() {
        return RetryableEndpointGroup.PRESENCE;
    }

    private final void addQueryParams(Map<String, String> queryParams) {
        if (!((Collection)this.getChannelGroups()).isEmpty()) {
            queryParams.put("channel-group", PubNubUtilKt.toCsv(this.getChannelGroups()));
        }
        queryParams.put("state", this.getPubnub().getMapper().toJson(this.getState()));
    }
}

