/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.endpoints.pubsub;

import com.pubnub.api.PubNubException;
import com.pubnub.api.builder.PubNubErrorBuilder;
import com.pubnub.api.endpoints.pubsub.Publish;
import com.pubnub.api.models.consumer.PNPublishResult;
import com.pubnub.api.v2.endpoints.pubsub.PublishBuilder;
import com.pubnub.internal.EndpointInterface;
import com.pubnub.internal.PubNubCore;
import com.pubnub.internal.endpoints.IdentityMappingEndpoint;
import org.jetbrains.annotations.NotNull;

public class PublishImpl
extends IdentityMappingEndpoint<PNPublishResult>
implements Publish,
PublishBuilder {
    private Object message;
    private String channel;
    private Boolean shouldStore;
    private boolean usePOST;
    private Object meta;
    private boolean replicate = true;
    private Integer ttl;

    public PublishImpl(PubNubCore pubnub) {
        super(pubnub);
    }

    @Override
    @NotNull
    protected EndpointInterface<PNPublishResult> createAction() {
        return this.pubnub.publish(this.channel, this.message, this.meta, this.shouldStore, this.usePOST, this.replicate, this.ttl);
    }

    @Override
    protected void validateParams() throws PubNubException {
        if (this.message == null) {
            throw new PubNubException(PubNubErrorBuilder.PNERROBJ_MESSAGE_MISSING);
        }
        if (this.channel == null) {
            throw new PubNubException(PubNubErrorBuilder.PNERROBJ_CHANNEL_MISSING);
        }
    }

    @Override
    public PublishImpl message(Object message) {
        this.message = message;
        return this;
    }

    @Override
    public PublishImpl channel(String channel) {
        this.channel = channel;
        return this;
    }

    @Override
    public PublishImpl shouldStore(Boolean shouldStore) {
        this.shouldStore = shouldStore;
        return this;
    }

    @Override
    public PublishImpl usePOST(boolean usePOST) {
        this.usePOST = usePOST;
        return this;
    }

    @Override
    public PublishImpl meta(Object meta) {
        this.meta = meta;
        return this;
    }

    @Override
    public PublishImpl replicate(boolean replicate) {
        this.replicate = replicate;
        return this;
    }

    @Override
    public PublishImpl ttl(Integer ttl) {
        this.ttl = ttl;
        return this;
    }
}

