/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.endpoints.push;

import com.pubnub.api.PubNubException;
import com.pubnub.api.builder.PubNubErrorBuilder;
import com.pubnub.api.endpoints.push.RemoveChannelsFromPush;
import com.pubnub.api.enums.PNPushEnvironment;
import com.pubnub.api.enums.PNPushType;
import com.pubnub.api.models.consumer.push.PNPushRemoveChannelResult;
import com.pubnub.internal.EndpointInterface;
import com.pubnub.internal.PubNubCore;
import com.pubnub.internal.endpoints.IdentityMappingEndpoint;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RemoveChannelsFromPushImpl
extends IdentityMappingEndpoint<PNPushRemoveChannelResult>
implements RemoveChannelsFromPush {
    private PNPushType pushType;
    private List<String> channels;
    private String deviceId;
    private PNPushEnvironment environment = PNPushEnvironment.DEVELOPMENT;
    private String topic;

    public RemoveChannelsFromPushImpl(PubNubCore pubnub) {
        super(pubnub);
    }

    @Override
    @NotNull
    protected EndpointInterface<PNPushRemoveChannelResult> createAction() {
        return this.pubnub.removePushNotificationsFromChannels(this.pushType, this.channels, this.deviceId, this.topic, this.environment);
    }

    @Override
    protected void validateParams() throws PubNubException {
        if (this.pushType == null) {
            throw new PubNubException(PubNubErrorBuilder.PNERROBJ_PUSH_TYPE_MISSING);
        }
        if (this.deviceId == null || this.deviceId.isEmpty()) {
            throw new PubNubException(PubNubErrorBuilder.PNERROBJ_DEVICE_ID_MISSING);
        }
        if (this.channels == null) {
            throw new PubNubException(PubNubErrorBuilder.PNERROBJ_CHANNEL_MISSING);
        }
    }

    @Override
    public RemoveChannelsFromPushImpl pushType(PNPushType pushType) {
        this.pushType = pushType;
        return this;
    }

    @Override
    public RemoveChannelsFromPushImpl channels(List<String> channels) {
        this.channels = channels;
        return this;
    }

    @Override
    public RemoveChannelsFromPushImpl deviceId(String deviceId) {
        this.deviceId = deviceId;
        return this;
    }

    @Override
    public RemoveChannelsFromPushImpl environment(PNPushEnvironment environment) {
        this.environment = environment;
        return this;
    }

    @Override
    public RemoveChannelsFromPushImpl topic(String topic) {
        this.topic = topic;
        return this;
    }
}

