/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.vendor;

import com.pubnub.api.PubNubException;
import com.pubnub.internal.vendor.Crypto;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Locale;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0007H\u0002J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0004J\u0018\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0016\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0004J\u001d\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0016J\u0018\u0010\u0017\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0004H\u0002J\u001c\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u00192\u0006\u0010\u001a\u001a\u00020\u000fH\u0002J\b\u0010\u001b\u001a\u00020\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/pubnub/internal/vendor/FileEncryptionUtil;", "", "()V", "CIPHER_TRANSFORMATION", "", "ENCODING_UTF_8", "IV_SIZE_BYTES", "", "cipher", "Ljavax/crypto/Cipher;", "keyBytes", "", "ivBytes", "mode", "decrypt", "Ljava/io/InputStream;", "inputStream", "cipherKey", "decryptionCipher", "encrypt", "encryptToBytes", "bytesToEncrypt", "encryptToBytes$pubnub_core_impl", "encryptionCipher", "loadIvAndDataFromInputStream", "Lkotlin/Pair;", "inputStreamToEncrypt", "randomIv", "pubnub-core-impl"})
public final class FileEncryptionUtil {
    @NotNull
    public static final FileEncryptionUtil INSTANCE = new FileEncryptionUtil();
    private static final int IV_SIZE_BYTES = 16;
    @NotNull
    public static final String ENCODING_UTF_8 = "UTF-8";
    @NotNull
    public static final String CIPHER_TRANSFORMATION = "AES/CBC/PKCS5Padding";

    private FileEncryptionUtil() {
    }

    @NotNull
    public final InputStream encrypt(@NotNull InputStream inputStream2, @NotNull String cipherKey) throws PubNubException {
        Intrinsics.checkNotNullParameter(inputStream2, "inputStream");
        Intrinsics.checkNotNullParameter(cipherKey, "cipherKey");
        return new ByteArrayInputStream(this.encryptToBytes$pubnub_core_impl(ByteStreamsKt.readBytes(inputStream2), cipherKey));
    }

    @NotNull
    public final InputStream decrypt(@NotNull InputStream inputStream2, @NotNull String cipherKey) throws PubNubException {
        InputStream inputStream3;
        Intrinsics.checkNotNullParameter(inputStream2, "inputStream");
        Intrinsics.checkNotNullParameter(cipherKey, "cipherKey");
        try {
            byte[] keyBytes = this.keyBytes(cipherKey);
            Pair<byte[], byte[]> pair = this.loadIvAndDataFromInputStream(inputStream2);
            byte[] ivBytes = pair.component1();
            byte[] dataToDecrypt = pair.component2();
            Cipher decryptionCipher = this.decryptionCipher(keyBytes, ivBytes);
            byte[] decryptedBytes = decryptionCipher.doFinal(dataToDecrypt);
            inputStream3 = new ByteArrayInputStream(decryptedBytes);
        }
        catch (Exception e) {
            Exception exception = e;
            if ((((((exception instanceof NoSuchAlgorithmException ? true : exception instanceof InvalidAlgorithmParameterException) ? true : exception instanceof NoSuchPaddingException) ? true : exception instanceof InvalidKeyException) ? true : exception instanceof IOException) ? true : exception instanceof IllegalBlockSizeException) ? true : exception instanceof BadPaddingException) {
                throw new PubNubException(e.getMessage(), null, null, 0, null, null, null, null, null, null, null, 2046, null);
            }
            throw e;
        }
        return inputStream3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final byte[] encryptToBytes$pubnub_core_impl(@NotNull byte[] bytesToEncrypt, @NotNull String cipherKey) throws PubNubException {
        Intrinsics.checkNotNullParameter(bytesToEncrypt, "bytesToEncrypt");
        Intrinsics.checkNotNullParameter(cipherKey, "cipherKey");
        try {
            Closeable closeable = new ByteArrayOutputStream();
            Throwable throwable = null;
            try {
                ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)closeable;
                boolean bl = false;
                byte[] randomIvBytes = INSTANCE.randomIv();
                byteArrayOutputStream.write(randomIvBytes);
                byte[] keyBytes = INSTANCE.keyBytes(cipherKey);
                Cipher encryptionCipher = INSTANCE.encryptionCipher(keyBytes, randomIvBytes);
                byteArrayOutputStream.write(encryptionCipher.doFinal(bytesToEncrypt));
                byte[] byArray = byteArrayOutputStream.toByteArray();
                Intrinsics.checkNotNullExpressionValue(byArray, "byteArrayOutputStream.toByteArray()");
                byte[] byArray2 = byArray;
                return byArray2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
        catch (Exception e) {
            Exception exception = e;
            if ((((((exception instanceof NoSuchAlgorithmException ? true : exception instanceof InvalidAlgorithmParameterException) ? true : exception instanceof NoSuchPaddingException) ? true : exception instanceof InvalidKeyException) ? true : exception instanceof IOException) ? true : exception instanceof BadPaddingException) ? true : exception instanceof IllegalBlockSizeException) {
                throw new PubNubException(e.getMessage(), null, null, 0, null, null, null, null, null, null, null, 2046, null);
            }
            throw e;
        }
    }

    private final Pair<byte[], byte[]> loadIvAndDataFromInputStream(InputStream inputStreamToEncrypt) throws IOException {
        byte[] ivBytes = new byte[16];
        inputStreamToEncrypt.read(ivBytes, 0, 16);
        return TuplesKt.to(ivBytes, ByteStreamsKt.readBytes(inputStreamToEncrypt));
    }

    private final Cipher encryptionCipher(byte[] keyBytes, byte[] ivBytes) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        return this.cipher(keyBytes, ivBytes, 1);
    }

    private final Cipher decryptionCipher(byte[] keyBytes, byte[] ivBytes) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        return this.cipher(keyBytes, ivBytes, 2);
    }

    private final Cipher cipher(byte[] keyBytes, byte[] ivBytes, int mode) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        Cipher cipher = Cipher.getInstance(CIPHER_TRANSFORMATION);
        AlgorithmParameterSpec iv = new IvParameterSpec(ivBytes);
        SecretKeySpec key = new SecretKeySpec(keyBytes, "AES");
        cipher.init(mode, (Key)key, iv);
        Intrinsics.checkNotNullExpressionValue(cipher, "cipher");
        return cipher;
    }

    private final byte[] keyBytes(String cipherKey) throws UnsupportedEncodingException, PubNubException {
        Charset charset = Charset.forName(ENCODING_UTF_8);
        Intrinsics.checkNotNullExpressionValue(charset, "forName(charsetName)");
        byte[] byArray = cipherKey.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue(byArray, "this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = Crypto.hexEncode(Crypto.sha256(byArray));
        Intrinsics.checkNotNullExpressionValue(byArray2, "hexEncode(\n             \u2026         ),\n            )");
        Object object = byArray2;
        Charset charset2 = Charset.forName(ENCODING_UTF_8);
        Intrinsics.checkNotNullExpressionValue(charset2, "forName(charsetName)");
        Charset charset3 = charset2;
        object = new String((byte[])object, charset3);
        int n = 0;
        int n2 = 32;
        String string = ((String)object).substring(n, n2);
        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String\u2026ing(startIndex, endIndex)");
        object = string;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue(locale, "getDefault()");
        String string2 = ((String)object).toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).toLowerCase(locale)");
        object = string2;
        Charset charset4 = Charset.forName(ENCODING_UTF_8);
        Intrinsics.checkNotNullExpressionValue(charset4, "forName(charsetName)");
        Charset charset5 = charset4;
        byte[] byArray3 = ((String)object).getBytes(charset5);
        Intrinsics.checkNotNullExpressionValue(byArray3, "this as java.lang.String).getBytes(charset)");
        return byArray3;
    }

    private final byte[] randomIv() throws NoSuchAlgorithmException {
        byte[] randomIv = new byte[16];
        SecureRandom.getInstance("SHA1PRNG").nextBytes(randomIv);
        return randomIv;
    }
}

