/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.workers;

import com.pubnub.api.PubNubException;
import com.pubnub.api.enums.PNStatusCategory;
import com.pubnub.api.models.consumer.PNStatus;
import com.pubnub.api.models.consumer.pubsub.PNEvent;
import com.pubnub.api.models.consumer.pubsub.PNMessageResult;
import com.pubnub.api.models.consumer.pubsub.PNPresenceEventResult;
import com.pubnub.api.models.consumer.pubsub.PNSignalResult;
import com.pubnub.api.models.consumer.pubsub.files.PNFileEventResult;
import com.pubnub.api.models.consumer.pubsub.message_actions.PNMessageActionResult;
import com.pubnub.internal.PubNubCore;
import com.pubnub.internal.managers.DuplicationManager;
import com.pubnub.internal.managers.ListenerManager;
import com.pubnub.internal.models.consumer.pubsub.objects.PNObjectEventResult;
import com.pubnub.internal.models.server.SubscribeMessage;
import com.pubnub.internal.workers.SubscribeMessageProcessor;
import java.util.concurrent.LinkedBlockingQueue;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/pubnub/internal/workers/SubscribeMessageWorker;", "Ljava/lang/Runnable;", "pubnub", "Lcom/pubnub/internal/PubNubCore;", "listenerManager", "Lcom/pubnub/internal/managers/ListenerManager;", "queue", "Ljava/util/concurrent/LinkedBlockingQueue;", "Lcom/pubnub/internal/models/server/SubscribeMessage;", "duplicationManager", "Lcom/pubnub/internal/managers/DuplicationManager;", "messageProcessor", "Lcom/pubnub/internal/workers/SubscribeMessageProcessor;", "(Lcom/pubnub/internal/PubNubCore;Lcom/pubnub/internal/managers/ListenerManager;Ljava/util/concurrent/LinkedBlockingQueue;Lcom/pubnub/internal/managers/DuplicationManager;Lcom/pubnub/internal/workers/SubscribeMessageProcessor;)V", "getListenerManager", "()Lcom/pubnub/internal/managers/ListenerManager;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "run", "", "takeMessage", "pubnub-core-impl"})
public final class SubscribeMessageWorker
implements Runnable {
    @NotNull
    private final ListenerManager listenerManager;
    @NotNull
    private final LinkedBlockingQueue<SubscribeMessage> queue;
    @NotNull
    private final SubscribeMessageProcessor messageProcessor;
    private final Logger log;

    public SubscribeMessageWorker(@NotNull PubNubCore pubnub, @NotNull ListenerManager listenerManager, @NotNull LinkedBlockingQueue<SubscribeMessage> queue, @NotNull DuplicationManager duplicationManager, @NotNull SubscribeMessageProcessor messageProcessor) {
        Intrinsics.checkNotNullParameter(pubnub, "pubnub");
        Intrinsics.checkNotNullParameter(listenerManager, "listenerManager");
        Intrinsics.checkNotNullParameter(queue, "queue");
        Intrinsics.checkNotNullParameter(duplicationManager, "duplicationManager");
        Intrinsics.checkNotNullParameter(messageProcessor, "messageProcessor");
        this.listenerManager = listenerManager;
        this.queue = queue;
        this.messageProcessor = messageProcessor;
        this.log = LoggerFactory.getLogger((String)"SubscribeMessageWorker");
    }

    public /* synthetic */ SubscribeMessageWorker(PubNubCore pubNubCore, ListenerManager listenerManager, LinkedBlockingQueue linkedBlockingQueue, DuplicationManager duplicationManager, SubscribeMessageProcessor subscribeMessageProcessor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            subscribeMessageProcessor = new SubscribeMessageProcessor(pubNubCore, duplicationManager);
        }
        this(pubNubCore, listenerManager, linkedBlockingQueue, duplicationManager, subscribeMessageProcessor);
    }

    @NotNull
    public final ListenerManager getListenerManager() {
        return this.listenerManager;
    }

    @Override
    public void run() {
        this.takeMessage();
    }

    private final void takeMessage() {
        while (!Thread.interrupted()) {
            try {
                SubscribeMessage subscribeMessage = this.queue.take();
                Intrinsics.checkNotNullExpressionValue(subscribeMessage, "queue.take()");
                PNEvent event = this.messageProcessor.processIncomingPayload(subscribeMessage);
                if (event instanceof PNMessageResult) {
                    this.listenerManager.announce((PNMessageResult)event);
                    continue;
                }
                if (event instanceof PNPresenceEventResult) {
                    this.listenerManager.announce((PNPresenceEventResult)event);
                    continue;
                }
                if (event instanceof PNSignalResult) {
                    this.listenerManager.announce((PNSignalResult)event);
                    continue;
                }
                if (event instanceof PNMessageActionResult) {
                    this.listenerManager.announce((PNMessageActionResult)event);
                    continue;
                }
                if (event instanceof PNObjectEventResult) {
                    this.listenerManager.announce((PNObjectEventResult)event);
                    continue;
                }
                if (!(event instanceof PNFileEventResult)) continue;
                this.listenerManager.announce((PNFileEventResult)event);
            }
            catch (PubNubException e) {
                this.listenerManager.announce(new PNStatus(PNStatusCategory.PNMalformedResponseCategory, e, null, null, null, 28, null));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.log.trace("take message interrupted!", (Throwable)e);
            }
            catch (Exception e) {
                this.log.warn("Unexpected message processing error", (Throwable)e);
            }
        }
    }
}

