/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pubnub;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.pubnub.PubNubConfiguration;
import org.apache.camel.component.pubnub.PubNubEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.ObjectHelper;

@Component(value="pubnub")
public class PubNubComponent
extends DefaultComponent {
    @Metadata
    private PubNubConfiguration configuration = new PubNubConfiguration();

    public PubNubComponent(CamelContext context) {
        super(context);
    }

    public PubNubComponent() {
    }

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        ObjectHelper.notNull(remaining, "channel");
        PubNubConfiguration config = this.configuration != null ? this.configuration.copy() : new PubNubConfiguration();
        config.setChannel(remaining);
        PubNubEndpoint endpoint = new PubNubEndpoint(uri, this, config);
        this.setProperties(endpoint, parameters);
        return endpoint;
    }

    public PubNubConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(PubNubConfiguration configuration) {
        this.configuration = configuration;
    }
}

