/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.support.AbstractVariableRepository;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.CaseInsensitiveMap;
import org.apache.camel.util.StringHelper;

final class ExchangeVariableRepository
extends AbstractVariableRepository {
    private final Map<String, Object> headers = new ConcurrentHashMap<String, Object>(8);

    public ExchangeVariableRepository(CamelContext camelContext) {
        this.setCamelContext(camelContext);
        ServiceHelper.startService(this);
    }

    void copyFrom(ExchangeVariableRepository source2) {
        this.setVariables(source2.getVariables());
        this.headers.putAll(source2.headers);
    }

    @Override
    public Object getVariable(String name) {
        String id = StringHelper.before(name, ":");
        if ("header".equals(id)) {
            Object prefix = StringHelper.after(name, ":");
            if (prefix == null || ((String)prefix).isBlank()) {
                throw new IllegalArgumentException("Variable " + name + " must have header key");
            }
            if (!((String)prefix).contains(".")) {
                prefix = (String)prefix + ".";
                CaseInsensitiveMap map = new CaseInsensitiveMap();
                for (Map.Entry<String, Object> entry : this.headers.entrySet()) {
                    String key = entry.getKey();
                    if (!key.startsWith((String)prefix)) continue;
                    key = StringHelper.after(key, (String)prefix);
                    map.put(key, entry.getValue());
                }
                return map;
            }
            return this.headers.get(prefix);
        }
        return super.getVariable(name);
    }

    @Override
    public void setVariable(String name, Object value) {
        String id = StringHelper.before(name, ":");
        if ("header".equals(id)) {
            name = StringHelper.after(name, ":");
            if (value != null) {
                this.headers.put(name, value);
            } else {
                this.headers.remove(name);
            }
        } else {
            super.setVariable(name, value);
        }
    }

    @Override
    public Object removeVariable(String name) {
        String id = StringHelper.before(name, ":");
        if ("header".equals(id)) {
            name = StringHelper.after(name, ":");
            return this.headers.remove(name);
        }
        return super.removeVariable(name);
    }

    @Override
    public void clear() {
        super.clear();
        this.headers.clear();
    }

    @Override
    public String getId() {
        return "exchange";
    }
}

