/*
 * Decompiled with CFR 0.152.
 */
package co.nstant.in.cbor.decoder;

import co.nstant.in.cbor.CborDecoder;
import co.nstant.in.cbor.CborException;
import co.nstant.in.cbor.decoder.AbstractDecoder;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.MajorType;
import co.nstant.in.cbor.model.Special;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;

public class ByteStringDecoder
extends AbstractDecoder<ByteString> {
    public ByteStringDecoder(CborDecoder decoder, InputStream inputStream2) {
        super(decoder, inputStream2);
    }

    @Override
    public ByteString decode(int initialByte) throws CborException {
        long length = this.getLength(initialByte);
        if (length == -1L) {
            if (this.decoder.isAutoDecodeInfinitiveByteStrings()) {
                return this.decodeInfinitiveLength();
            }
            ByteString byteString = new ByteString(null);
            byteString.setChunked(true);
            return byteString;
        }
        return this.decodeFixedLength(length);
    }

    private ByteString decodeInfinitiveLength() throws CborException {
        ByteArrayOutputStream bytes;
        block2: {
            MajorType majorType;
            bytes = new ByteArrayOutputStream();
            while (true) {
                DataItem dataItem;
                if ((dataItem = this.decoder.decodeNext()) == null) {
                    throw new CborException("Unexpected end of stream");
                }
                majorType = dataItem.getMajorType();
                if (Special.BREAK.equals(dataItem)) break block2;
                if (majorType != MajorType.BYTE_STRING) break;
                ByteString byteString = (ByteString)dataItem;
                byte[] byteArray = byteString.getBytes();
                if (byteArray == null) continue;
                bytes.write(byteArray, 0, byteArray.length);
            }
            throw new CborException("Unexpected major type " + (Object)((Object)majorType));
        }
        return new ByteString(bytes.toByteArray());
    }

    private ByteString decodeFixedLength(long length) throws CborException {
        return new ByteString(this.decodeBytes(length));
    }
}

