/*
 * Decompiled with CFR 0.152.
 */
package co.nstant.in.cbor.model;

import co.nstant.in.cbor.model.MajorType;
import co.nstant.in.cbor.model.Tag;
import java.util.Objects;

public class DataItem {
    private final MajorType majorType;
    private Tag tag;

    protected DataItem(MajorType majorType) {
        this.majorType = majorType;
        Objects.requireNonNull(majorType, "majorType is null");
    }

    public MajorType getMajorType() {
        return this.majorType;
    }

    public void setTag(long tag) {
        if (tag < 0L) {
            throw new IllegalArgumentException("tag number must be 0 or greater");
        }
        this.tag = new Tag(tag);
    }

    public void setTag(Tag tag) {
        Objects.requireNonNull(tag, "tag is null");
        this.tag = tag;
    }

    public void removeTag() {
        this.tag = null;
    }

    public Tag getTag() {
        return this.tag;
    }

    public boolean hasTag() {
        return this.tag != null;
    }

    public boolean equals(Object object) {
        if (object instanceof DataItem) {
            DataItem other = (DataItem)object;
            if (this.tag != null) {
                return this.tag.equals(other.tag) && this.majorType == other.majorType;
            }
            return other.tag == null && this.majorType == other.majorType;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.majorType, this.tag});
    }

    protected void assertTrue(boolean condition, String message) {
        if (!condition) {
            throw new IllegalArgumentException(message);
        }
    }

    public DataItem getOuterTaggable() {
        DataItem item = this;
        while (item.getTag() != null) {
            item = item.getTag();
        }
        return item;
    }
}

