/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.endpoints.files;

import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.models.consumer.files.PNListFilesResult;
import com.pubnub.api.models.consumer.objects.PNPage;
import com.pubnub.api.retry.RetryableEndpointGroup;
import com.pubnub.internal.EndpointCore;
import com.pubnub.internal.PubNubCore;
import com.pubnub.internal.endpoints.files.ListFilesInterface;
import com.pubnub.internal.models.server.files.ListFilesResult;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 $2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004:\u0001$B-\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\u000f\u001a\u00020\u00032\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011H\u0014J2\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u00132\"\u0010\u0014\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0015j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006`\u0016H\u0014J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u0018H\u0014J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u0018H\u0014J\b\u0010\u001a\u001a\u00020\u001bH\u0014J\b\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010\u001e\u001a\u00020\u001dH\u0014J\b\u0010\u001f\u001a\u00020\u001dH\u0014J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020#H\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/pubnub/internal/endpoints/files/ListFilesEndpoint;", "Lcom/pubnub/internal/EndpointCore;", "Lcom/pubnub/internal/models/server/files/ListFilesResult;", "Lcom/pubnub/api/models/consumer/files/PNListFilesResult;", "Lcom/pubnub/internal/endpoints/files/ListFilesInterface;", "channel", "", "limit", "", "next", "Lcom/pubnub/api/models/consumer/objects/PNPage$PNNext;", "pubNub", "Lcom/pubnub/internal/PubNubCore;", "(Ljava/lang/String;Ljava/lang/Integer;Lcom/pubnub/api/models/consumer/objects/PNPage$PNNext;Lcom/pubnub/internal/PubNubCore;)V", "Ljava/lang/Integer;", "createResponse", "input", "Lretrofit2/Response;", "doWork", "Lretrofit2/Call;", "queryParams", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getAffectedChannelGroups", "", "getAffectedChannels", "getEndpointGroupName", "Lcom/pubnub/api/retry/RetryableEndpointGroup;", "isAuthRequired", "", "isPubKeyRequired", "isSubKeyRequired", "operationType", "Lcom/pubnub/api/enums/PNOperationType;", "validateParams", "", "Companion", "pubnub-core-impl"})
public final class ListFilesEndpoint
extends EndpointCore<ListFilesResult, PNListFilesResult>
implements ListFilesInterface {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String channel;
    @Nullable
    private final Integer limit;
    @Nullable
    private final PNPage.PNNext next;
    @NotNull
    private static final String LIMIT_QUERY_PARAM = "limit";
    @NotNull
    private static final String NEXT_PAGE_QUERY_PARAM = "next";
    private static final int DEFAULT_LIMIT = 100;
    private static final int MIN_LIMIT = 1;
    private static final int MAX_LIMIT = 100;

    public ListFilesEndpoint(@NotNull String channel, @Nullable Integer limit, @Nullable PNPage.PNNext next, @NotNull PubNubCore pubNub) {
        Intrinsics.checkNotNullParameter(channel, "channel");
        Intrinsics.checkNotNullParameter(pubNub, "pubNub");
        super(pubNub);
        this.channel = channel;
        this.limit = limit;
        this.next = next;
    }

    public /* synthetic */ ListFilesEndpoint(String string, Integer n, PNPage.PNNext pNNext, PubNubCore pubNubCore, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        if ((n2 & 4) != 0) {
            pNNext = null;
        }
        this(string, n, pNNext, pubNubCore);
    }

    @Override
    protected void validateParams() throws PubNubException {
        if (((CharSequence)this.channel).length() == 0) {
            throw new PubNubException(PubNubError.CHANNEL_MISSING);
        }
        if (this.limit != null && !new IntRange(1, 100).contains(this.limit)) {
            throw PubNubException.copy$default(new PubNubException(PubNubError.INVALID_ARGUMENTS), "Limit should be in range from 1 to 100 (both inclusive)", null, null, 0, null, null, null, null, null, null, null, 2046, null);
        }
        if (this.next != null && StringsKt.isBlank(this.next.getPageHash())) {
            throw PubNubException.copy$default(new PubNubException(PubNubError.INVALID_ARGUMENTS), "Next should not be an empty string", null, null, 0, null, null, null, null, null, null, null, 2046, null);
        }
    }

    @Override
    @NotNull
    protected Call<ListFilesResult> doWork(@NotNull HashMap<String, String> queryParams) throws PubNubException {
        Intrinsics.checkNotNullParameter(queryParams, "queryParams");
        Map map = queryParams;
        String string = LIMIT_QUERY_PARAM;
        Integer n = this.limit;
        String string2 = String.valueOf(n != null ? n : 100);
        map.put(string, string2);
        if (this.next != null) {
            ((Map)queryParams).put(NEXT_PAGE_QUERY_PARAM, this.next.getPageHash());
        }
        return this.getRetrofitManager().getFilesService$pubnub_core_impl().listFiles(this.getConfiguration().getSubscribeKey(), this.channel, (Map<String, String>)queryParams);
    }

    @Override
    @NotNull
    protected PNListFilesResult createResponse(@NotNull Response<ListFilesResult> input) throws PubNubException {
        Intrinsics.checkNotNullParameter(input, "input");
        ListFilesResult listFilesResult = input.body();
        if (listFilesResult == null) {
            throw new PubNubException(PubNubError.INTERNAL_ERROR);
        }
        ListFilesResult body = listFilesResult;
        boolean bl = false;
        return new PNListFilesResult(body.getCount(), body.getNext(), body.getStatus(), body.getData());
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannels() {
        return CollectionsKt.listOf(this.channel);
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannelGroups() {
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public PNOperationType operationType() {
        return PNOperationType.FileOperation;
    }

    @Override
    protected boolean isAuthRequired() {
        return true;
    }

    @Override
    protected boolean isSubKeyRequired() {
        return true;
    }

    @Override
    protected boolean isPubKeyRequired() {
        return false;
    }

    @Override
    @NotNull
    protected RetryableEndpointGroup getEndpointGroupName() {
        return RetryableEndpointGroup.FILE_PERSISTENCE;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/pubnub/internal/endpoints/files/ListFilesEndpoint$Companion;", "", "()V", "DEFAULT_LIMIT", "", "LIMIT_QUERY_PARAM", "", "MAX_LIMIT", "MIN_LIMIT", "NEXT_PAGE_QUERY_PARAM", "pubnub-core-impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

