/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.endpoints.objects_api.memberships;

import com.pubnub.api.endpoints.objects_api.memberships.RemoveMemberships;
import com.pubnub.api.endpoints.objects_api.utils.Include;
import com.pubnub.api.endpoints.objects_api.utils.PNSortKey;
import com.pubnub.api.endpoints.remoteaction.ExtendedRemoteAction;
import com.pubnub.api.endpoints.remoteaction.MappingRemoteAction;
import com.pubnub.api.models.consumer.objects.PNPage;
import com.pubnub.api.models.consumer.objects_api.membership.PNChannelMembership;
import com.pubnub.api.models.consumer.objects_api.membership.PNRemoveMembershipResult;
import com.pubnub.internal.EndpointInterface;
import com.pubnub.internal.PubNubCore;
import com.pubnub.internal.endpoints.DelegatingEndpoint;
import com.pubnub.internal.endpoints.objects_api.memberships.SetMembershipsImpl;
import com.pubnub.internal.models.consumer.objects.membership.PNChannelMembershipArrayResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class RemoveMembershipsImpl
extends DelegatingEndpoint<PNChannelMembershipArrayResult, PNRemoveMembershipResult>
implements RemoveMemberships {
    private final Collection<PNChannelMembership> channelMemberships;
    private String uuid;
    private Integer limit;
    private PNPage page;
    private String filter;
    private Collection<PNSortKey> sort = Collections.emptyList();
    private boolean includeTotalCount;
    private boolean includeCustom;
    private Include.PNChannelDetailsLevel includeChannel;

    public RemoveMembershipsImpl(@NotNull Collection<PNChannelMembership> channelMemberships, PubNubCore pubnubInstance) {
        super(pubnubInstance);
        this.channelMemberships = channelMemberships;
    }

    @Override
    @NotNull
    protected ExtendedRemoteAction<PNRemoveMembershipResult> mapResult(@NotNull ExtendedRemoteAction<PNChannelMembershipArrayResult> action) {
        return new MappingRemoteAction<PNChannelMembershipArrayResult, PNRemoveMembershipResult>(action, PNRemoveMembershipResult::from);
    }

    @Override
    @NotNull
    protected EndpointInterface<PNChannelMembershipArrayResult> createAction() {
        ArrayList<String> channelList = new ArrayList<String>(this.channelMemberships.size());
        for (PNChannelMembership channel : this.channelMemberships) {
            channelList.add(channel.getChannel().getId());
        }
        return this.pubnub.removeMemberships(channelList, this.uuid, this.limit, this.page, this.filter, SetMembershipsImpl.toInternal(this.sort), this.includeTotalCount, this.includeCustom, SetMembershipsImpl.toInternal(this.includeChannel));
    }

    @Override
    public RemoveMembershipsImpl uuid(String uuid) {
        this.uuid = uuid;
        return this;
    }

    @Override
    public RemoveMembershipsImpl limit(Integer limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public RemoveMembershipsImpl page(PNPage page) {
        this.page = page;
        return this;
    }

    @Override
    public RemoveMembershipsImpl filter(String filter) {
        this.filter = filter;
        return this;
    }

    @Override
    public RemoveMembershipsImpl sort(Collection<PNSortKey> sort) {
        this.sort = sort;
        return this;
    }

    @Override
    public RemoveMembershipsImpl includeTotalCount(boolean includeTotalCount) {
        this.includeTotalCount = includeTotalCount;
        return this;
    }

    @Override
    public RemoveMembershipsImpl includeCustom(boolean includeCustom) {
        this.includeCustom = includeCustom;
        return this;
    }

    @Override
    public RemoveMembershipsImpl includeChannel(Include.PNChannelDetailsLevel includeChannel) {
        this.includeChannel = includeChannel;
        return this;
    }

    public static class Builder
    implements RemoveMemberships.Builder {
        private final PubNubCore pubnubInstance;

        @Override
        public RemoveMemberships channelMemberships(@NotNull Collection<PNChannelMembership> channelMemberships) {
            return new RemoveMembershipsImpl(channelMemberships, this.pubnubInstance);
        }

        public Builder(PubNubCore pubnubInstance) {
            this.pubnubInstance = pubnubInstance;
        }
    }
}

