/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.endpoints.presence;

import com.google.gson.JsonElement;
import com.pubnub.api.PubNubError;
import com.pubnub.api.PubNubException;
import com.pubnub.api.enums.PNOperationType;
import com.pubnub.api.models.consumer.presence.PNGetStateResult;
import com.pubnub.api.retry.RetryableEndpointGroup;
import com.pubnub.internal.EndpointCore;
import com.pubnub.internal.PubNubCore;
import com.pubnub.internal.PubNubUtilKt;
import com.pubnub.internal.endpoints.presence.GetStateInterface;
import com.pubnub.internal.managers.MapperManager;
import com.pubnub.internal.models.server.Envelope;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.Response;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0004\u0012\u00020\u00040\u00012\u00020\u0005B5\b\u0000\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\b\b\u0002\u0010\f\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ\u001c\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u0016H\u0002J\u001c\u0010\u0017\u001a\u00020\u00042\u0012\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0019H\u0014J8\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u001b2\"\u0010\u0015\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u001cj\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n`\u001dH\u0014J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0014J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0014J\b\u0010 \u001a\u00020!H\u0014J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\u0014H\u0014R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0014\u0010\f\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006%"}, d2={"Lcom/pubnub/internal/endpoints/presence/GetStateEndpoint;", "Lcom/pubnub/internal/EndpointCore;", "Lcom/pubnub/internal/models/server/Envelope;", "Lcom/google/gson/JsonElement;", "Lcom/pubnub/api/models/consumer/presence/PNGetStateResult;", "Lcom/pubnub/internal/endpoints/presence/GetStateInterface;", "pubnub", "Lcom/pubnub/internal/PubNubCore;", "channels", "", "", "channelGroups", "uuid", "(Lcom/pubnub/internal/PubNubCore;Ljava/util/List;Ljava/util/List;Ljava/lang/String;)V", "getChannelGroups", "()Ljava/util/List;", "getChannels", "getUuid", "()Ljava/lang/String;", "addQueryParams", "", "queryParams", "", "createResponse", "input", "Lretrofit2/Response;", "doWork", "Lretrofit2/Call;", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getAffectedChannelGroups", "getAffectedChannels", "getEndpointGroupName", "Lcom/pubnub/api/retry/RetryableEndpointGroup;", "operationType", "Lcom/pubnub/api/enums/PNOperationType$PNGetState;", "validateParams", "pubnub-core-impl"})
public final class GetStateEndpoint
extends EndpointCore<Envelope<JsonElement>, PNGetStateResult>
implements GetStateInterface {
    @NotNull
    private final List<String> channels;
    @NotNull
    private final List<String> channelGroups;
    @NotNull
    private final String uuid;

    public GetStateEndpoint(@NotNull PubNubCore pubnub, @NotNull List<String> channels, @NotNull List<String> channelGroups, @NotNull String uuid) {
        Intrinsics.checkNotNullParameter(pubnub, "pubnub");
        Intrinsics.checkNotNullParameter(channels, "channels");
        Intrinsics.checkNotNullParameter(channelGroups, "channelGroups");
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        super(pubnub);
        this.channels = channels;
        this.channelGroups = channelGroups;
        this.uuid = uuid;
    }

    public /* synthetic */ GetStateEndpoint(PubNubCore pubNubCore, List list, List list2, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string = pubNubCore.getConfiguration().getUserId().getValue();
        }
        this(pubNubCore, list, list2, string);
    }

    @Override
    @NotNull
    public List<String> getChannels() {
        return this.channels;
    }

    @Override
    @NotNull
    public List<String> getChannelGroups() {
        return this.channelGroups;
    }

    @Override
    @NotNull
    public String getUuid() {
        return this.uuid;
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannels() {
        return this.getChannels();
    }

    @Override
    @NotNull
    protected List<String> getAffectedChannelGroups() {
        return this.getChannelGroups();
    }

    @Override
    protected void validateParams() {
        super.validateParams();
        if (this.getChannels().isEmpty() && this.getChannelGroups().isEmpty()) {
            throw new PubNubException(PubNubError.CHANNEL_AND_GROUP_MISSING);
        }
    }

    @Override
    @NotNull
    protected Call<Envelope<JsonElement>> doWork(@NotNull HashMap<String, String> queryParams) {
        Intrinsics.checkNotNullParameter(queryParams, "queryParams");
        this.addQueryParams((Map<String, String>)queryParams);
        return this.getRetrofitManager().getPresenceService$pubnub_core_impl().getState(this.getConfiguration().getSubscribeKey(), PubNubUtilKt.toCsv(this.getChannels()), this.getUuid(), (Map<String, String>)queryParams);
    }

    @Override
    @NotNull
    protected PNGetStateResult createResponse(@NotNull Response<Envelope<JsonElement>> input) {
        Intrinsics.checkNotNullParameter(input, "input");
        HashMap stateMappings = new HashMap();
        if (this.getChannels().size() == 1 && this.getChannelGroups().isEmpty()) {
            Map map = stateMappings;
            String string = CollectionsKt.first(this.getChannels());
            Envelope<JsonElement> envelope = input.body();
            Intrinsics.checkNotNull(envelope);
            JsonElement jsonElement = envelope.getPayload$pubnub_core_impl();
            Intrinsics.checkNotNull(jsonElement);
            map.put(string, jsonElement);
        } else {
            MapperManager mapperManager = this.getPubnub().getMapper();
            Envelope<JsonElement> envelope = input.body();
            Intrinsics.checkNotNull(envelope);
            JsonElement jsonElement = envelope.getPayload$pubnub_core_impl();
            Intrinsics.checkNotNull(jsonElement);
            Iterator<Map.Entry<String, JsonElement>> it = mapperManager.getObjectIterator(jsonElement);
            while (it.hasNext()) {
                JsonElement jsonElement2;
                String string;
                Map.Entry<String, JsonElement> stateMapping = it.next();
                Map map = stateMappings;
                Intrinsics.checkNotNullExpressionValue(stateMapping.getKey(), "stateMapping.key");
                Intrinsics.checkNotNullExpressionValue(stateMapping.getValue(), "stateMapping.value");
                map.put(string, jsonElement2);
            }
        }
        return new PNGetStateResult(stateMappings);
    }

    @Override
    @NotNull
    public PNOperationType.PNGetState operationType() {
        return PNOperationType.PNGetState;
    }

    @Override
    @NotNull
    protected RetryableEndpointGroup getEndpointGroupName() {
        return RetryableEndpointGroup.PRESENCE;
    }

    private final void addQueryParams(Map<String, String> queryParams) {
        if (!((Collection)this.getChannelGroups()).isEmpty()) {
            queryParams.put("channel-group", PubNubUtilKt.toCsv(this.getChannelGroups()));
        }
    }
}

