/*
 * Decompiled with CFR 0.152.
 */
package com.pubnub.internal.v2.subscription;

import com.pubnub.api.callbacks.Listener;
import com.pubnub.api.v2.callbacks.BaseEventListener;
import com.pubnub.api.v2.subscriptions.BaseSubscription;
import com.pubnub.api.v2.subscriptions.BaseSubscriptionSet;
import com.pubnub.api.v2.subscriptions.SubscriptionCursor;
import com.pubnub.internal.PubNubCore;
import com.pubnub.internal.managers.AnnouncementCallback;
import com.pubnub.internal.managers.AnnouncementEnvelope;
import com.pubnub.internal.v2.callbacks.EventEmitterImpl;
import com.pubnub.internal.v2.callbacks.EventListenerCore;
import com.pubnub.internal.v2.subscription.BaseSubscriptionImpl;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u000e\b\u0001\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00010\u00042\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0005B#\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u0014\u0010\u0015\u001a\u00020\u00162\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0018H\u0002J\u0015\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u001cJ\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fH\u0004J\b\u0010 \u001a\u00020\u001aH\u0016J\u0015\u0010!\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u001cJ\b\u0010\"\u001a\u00020\u001aH\u0016J\u0010\u0010#\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020\u001aH\u0016R\u001a\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\n0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00010\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006)"}, d2={"Lcom/pubnub/internal/v2/subscription/BaseSubscriptionSetImpl;", "EvLis", "Lcom/pubnub/api/v2/callbacks/BaseEventListener;", "Sub", "Lcom/pubnub/api/v2/subscriptions/BaseSubscription;", "Lcom/pubnub/api/v2/subscriptions/BaseSubscriptionSet;", "pubnub", "Lcom/pubnub/internal/PubNubCore;", "initialSubscriptions", "", "Lcom/pubnub/internal/v2/subscription/BaseSubscriptionImpl;", "(Lcom/pubnub/internal/PubNubCore;Ljava/util/Set;)V", "_subscriptions", "Ljava/util/concurrent/CopyOnWriteArraySet;", "eventEmitter", "Lcom/pubnub/internal/v2/callbacks/EventEmitterImpl;", "getEventEmitter", "()Lcom/pubnub/internal/v2/callbacks/EventEmitterImpl;", "subscriptions", "getSubscriptions", "()Ljava/util/Set;", "accepts", "", "envelope", "Lcom/pubnub/internal/managers/AnnouncementEnvelope;", "add", "", "subscription", "(Lcom/pubnub/api/v2/subscriptions/BaseSubscription;)V", "addListener", "listener", "Lcom/pubnub/internal/v2/callbacks/EventListenerCore;", "close", "remove", "removeAllListeners", "removeListener", "Lcom/pubnub/api/callbacks/Listener;", "subscribe", "cursor", "Lcom/pubnub/api/v2/subscriptions/SubscriptionCursor;", "unsubscribe", "pubnub-core-impl"})
@SourceDebugExtension(value={"SMAP\nBaseSubscriptionSetImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseSubscriptionSetImpl.kt\ncom/pubnub/internal/v2/subscription/BaseSubscriptionSetImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,74:1\n1726#2,3:75\n1747#2,3:79\n1855#2,2:82\n1855#2,2:86\n1#3:78\n37#4,2:84\n37#4,2:88\n*S KotlinDebug\n*F\n+ 1 BaseSubscriptionSetImpl.kt\ncom/pubnub/internal/v2/subscription/BaseSubscriptionSetImpl\n*L\n32#1:75,3\n29#1:79,3\n48#1:82,2\n53#1:86,2\n49#1:84,2\n54#1:88,2\n*E\n"})
public abstract class BaseSubscriptionSetImpl<EvLis extends BaseEventListener, Sub extends BaseSubscription<EvLis>>
implements BaseSubscriptionSet<EvLis, Sub> {
    @NotNull
    private final PubNubCore pubnub;
    @NotNull
    private final CopyOnWriteArraySet<BaseSubscriptionImpl<EvLis>> _subscriptions;
    @NotNull
    private final EventEmitterImpl eventEmitter;

    public BaseSubscriptionSetImpl(@NotNull PubNubCore pubnub, @NotNull Set<? extends BaseSubscriptionImpl<EvLis>> initialSubscriptions) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter(pubnub, "pubnub");
            Intrinsics.checkNotNullParameter(initialSubscriptions, "initialSubscriptions");
            this.pubnub = pubnub;
            this._subscriptions = new CopyOnWriteArraySet();
            this.eventEmitter = new EventEmitterImpl(AnnouncementCallback.Phase.SET, new Function1<AnnouncementEnvelope<?>, Boolean>(this){

                @NotNull
                public final Boolean invoke(@NotNull AnnouncementEnvelope<?> p0) {
                    Intrinsics.checkNotNullParameter(p0, "p0");
                    return BaseSubscriptionSetImpl.access$accepts((BaseSubscriptionSetImpl)this.receiver, p0);
                }
            });
            Iterable $this$all$iv = initialSubscriptions;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    BaseSubscriptionImpl it = (BaseSubscriptionImpl)element$iv;
                    boolean bl2 = false;
                    if (Intrinsics.areEqual(it.getPubnub$pubnub_core_impl(), this.pubnub)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        if (!bl) {
            boolean bl3 = false;
            String string = "Adding Subscriptions from another PubNub instance to a SubscriptionSet is not allowed.";
            throw new IllegalArgumentException(string.toString());
        }
        this._subscriptions.addAll((Collection)initialSubscriptions);
        this.pubnub.getListenerManager().addAnnouncementCallback$pubnub_core_impl(this.eventEmitter);
    }

    public /* synthetic */ BaseSubscriptionSetImpl(PubNubCore pubNubCore, Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            set = SetsKt.emptySet();
        }
        this(pubNubCore, set);
    }

    @Override
    @NotNull
    public Set<Sub> getSubscriptions() {
        Set set = CollectionsKt.toSet((Iterable)this._subscriptions);
        Intrinsics.checkNotNull(set, "null cannot be cast to non-null type kotlin.collections.Set<Sub of com.pubnub.internal.v2.subscription.BaseSubscriptionSetImpl>");
        return set;
    }

    @NotNull
    protected final EventEmitterImpl getEventEmitter() {
        return this.eventEmitter;
    }

    private final boolean accepts(AnnouncementEnvelope<?> envelope) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.getSubscriptions();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    BaseSubscription subscription2 = (BaseSubscription)element$iv;
                    boolean bl2 = false;
                    if (!envelope.getAcceptedBy().contains(subscription2)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public void add(@NotNull Sub subscription2) {
        Intrinsics.checkNotNullParameter(subscription2, "subscription");
        if (!(subscription2 instanceof BaseSubscriptionImpl)) {
            boolean $i$a$-require-BaseSubscriptionSetImpl$add$32 = false;
            String $i$a$-require-BaseSubscriptionSetImpl$add$32 = "Only Subscriptions returned from objects createdthrough the PubNub instance and their methods, such as channel(...).subscriptions() are supported.";
            throw new IllegalArgumentException($i$a$-require-BaseSubscriptionSetImpl$add$32.toString());
        }
        if (!Intrinsics.areEqual(((BaseSubscriptionImpl)subscription2).getPubnub$pubnub_core_impl(), this.pubnub)) {
            boolean bl = false;
            String string = "Adding Subscriptions from another PubNub instance to a SubscriptionSet is not allowed.";
            throw new IllegalArgumentException(string.toString());
        }
        this._subscriptions.add((BaseSubscriptionImpl)subscription2);
    }

    @Override
    public void remove(@NotNull Sub subscription2) {
        Intrinsics.checkNotNullParameter(subscription2, "subscription");
        Collection collection = this._subscriptions;
        BaseSubscriptionImpl baseSubscriptionImpl = (BaseSubscriptionImpl)subscription2;
        TypeIntrinsics.asMutableCollection(collection).remove(baseSubscriptionImpl);
    }

    @Override
    public void subscribe(@NotNull SubscriptionCursor cursor) {
        Intrinsics.checkNotNullParameter(cursor, "cursor");
        Iterable $this$forEach$iv = this._subscriptions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BaseSubscriptionImpl it = (BaseSubscriptionImpl)element$iv;
            boolean bl = false;
            it.onSubscriptionActive$pubnub_core_impl(cursor);
        }
        Collection $this$toTypedArray$iv = this._subscriptions;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        BaseSubscriptionImpl[] baseSubscriptionImplArray = thisCollection$iv.toArray(new BaseSubscriptionImpl[0]);
        this.pubnub.subscribe$pubnub_core_impl(Arrays.copyOf(baseSubscriptionImplArray, baseSubscriptionImplArray.length), cursor);
    }

    @Override
    public void unsubscribe() {
        Iterable $this$forEach$iv = this._subscriptions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BaseSubscriptionImpl it = (BaseSubscriptionImpl)element$iv;
            boolean bl = false;
            it.onSubscriptionInactive$pubnub_core_impl();
        }
        Collection $this$toTypedArray$iv = this._subscriptions;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        BaseSubscriptionImpl[] baseSubscriptionImplArray = thisCollection$iv.toArray(new BaseSubscriptionImpl[0]);
        this.pubnub.unsubscribe$pubnub_core_impl(Arrays.copyOf(baseSubscriptionImplArray, baseSubscriptionImplArray.length));
    }

    @Override
    public void close() {
        this.unsubscribe();
        this.pubnub.getListenerManager().removeAnnouncementCallback$pubnub_core_impl(this.eventEmitter);
    }

    @Override
    protected final void addListener(@NotNull EventListenerCore listener2) {
        Intrinsics.checkNotNullParameter(listener2, "listener");
        this.eventEmitter.addListener(listener2);
    }

    @Override
    public void removeListener(@NotNull Listener listener2) {
        Intrinsics.checkNotNullParameter(listener2, "listener");
        this.eventEmitter.removeListener(listener2);
    }

    @Override
    public void removeAllListeners() {
        this.eventEmitter.removeAllListeners();
    }

    public static final /* synthetic */ boolean access$accepts(BaseSubscriptionSetImpl $this, AnnouncementEnvelope envelope) {
        return $this.accepts(envelope);
    }
}

