/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pubnub;

import com.pubnub.api.PubNub;
import com.pubnub.api.builder.SubscribeBuilder;
import com.pubnub.api.callbacks.SubscribeCallback;
import com.pubnub.api.enums.PNStatusCategory;
import com.pubnub.api.models.consumer.PNStatus;
import com.pubnub.api.models.consumer.objects_api.channel.PNChannelMetadataResult;
import com.pubnub.api.models.consumer.objects_api.membership.PNMembershipResult;
import com.pubnub.api.models.consumer.objects_api.uuid.PNUUIDMetadataResult;
import com.pubnub.api.models.consumer.pubsub.PNMessageResult;
import com.pubnub.api.models.consumer.pubsub.PNPresenceEventResult;
import com.pubnub.api.models.consumer.pubsub.PNSignalResult;
import com.pubnub.api.models.consumer.pubsub.files.PNFileEventResult;
import com.pubnub.api.models.consumer.pubsub.message_actions.PNMessageActionResult;
import java.util.Arrays;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.pubnub.PubNubConfiguration;
import org.apache.camel.component.pubnub.PubNubEndpoint;
import org.apache.camel.support.DefaultConsumer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PubNubConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(PubNubConsumer.class);
    private final PubNubEndpoint endpoint;
    private final PubNubConfiguration pubNubConfiguration;

    public PubNubConsumer(PubNubEndpoint endpoint, Processor processor, PubNubConfiguration pubNubConfiguration) {
        super(endpoint, processor);
        this.endpoint = endpoint;
        this.pubNubConfiguration = pubNubConfiguration;
    }

    private void initCommunication() {
        this.endpoint.getPubnub().addListener(new PubNubCallback());
        if (this.pubNubConfiguration.isWithPresence()) {
            ((SubscribeBuilder)this.endpoint.getPubnub().subscribe().channels((List)Arrays.asList(this.pubNubConfiguration.getChannel()))).withPresence().execute();
        } else {
            ((SubscribeBuilder)this.endpoint.getPubnub().subscribe().channels((List)Arrays.asList(this.pubNubConfiguration.getChannel()))).execute();
        }
    }

    private void terminateCommunication() {
        try {
            this.endpoint.getPubnub().unsubscribe().channels(Arrays.asList(this.pubNubConfiguration.getChannel())).execute();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.initCommunication();
    }

    @Override
    protected void doResume() throws Exception {
        super.doResume();
        this.initCommunication();
    }

    @Override
    protected void doStop() throws Exception {
        this.terminateCommunication();
        super.doStop();
    }

    @Override
    protected void doSuspend() throws Exception {
        this.terminateCommunication();
        super.doSuspend();
    }

    class PubNubCallback
    extends SubscribeCallback {
        PubNubCallback() {
        }

        @Override
        public void status(PubNub pubnub, PNStatus status) {
            if (status.getCategory() == PNStatusCategory.PNUnexpectedDisconnectCategory || status.getCategory() == PNStatusCategory.PNConnectionError) {
                LOG.trace("Got status: {}. Reconnecting to PubNub", (Object)status);
                pubnub.reconnect();
            } else {
                LOG.trace("Status message: {}", (Object)status);
            }
        }

        @Override
        public void message(PubNub pubnub, PNMessageResult message) {
            Exchange exchange = PubNubConsumer.this.createExchange(true);
            Message inmessage = exchange.getIn();
            inmessage.setBody(message);
            inmessage.setHeader("CamelPubNubTimeToken", message.getTimetoken());
            inmessage.setHeader("CamelPubNubChannel", message.getChannel());
            inmessage.setHeader("CamelMessageTimestamp", message.getTimetoken());
            try {
                PubNubConsumer.this.getProcessor().process(exchange);
            }
            catch (Exception e) {
                exchange.setException(e);
            }
            if (exchange.getException() != null) {
                PubNubConsumer.this.getExceptionHandler().handleException("Error processing exchange", exchange.getException());
            }
        }

        @Override
        public void presence(PubNub pubnub, PNPresenceEventResult presence) {
            Exchange exchange = PubNubConsumer.this.createExchange(true);
            Message inmessage = exchange.getIn();
            inmessage.setBody(presence);
            inmessage.setHeader("CamelPubNubTimeToken", presence.getTimetoken());
            inmessage.setHeader("CamelPubNubChannel", presence.getChannel());
            inmessage.setHeader("CamelMessageTimestamp", presence.getTimetoken());
            try {
                PubNubConsumer.this.getProcessor().process(exchange);
            }
            catch (Exception e) {
                PubNubConsumer.this.getExceptionHandler().handleException("Error processing exchange", e);
            }
        }

        @Override
        public void signal(@NotNull PubNub pubnub, @NotNull PNSignalResult pnSignalResult) {
            LOG.trace("signal: {}.", (Object)pnSignalResult);
        }

        @Override
        public void uuid(@NotNull PubNub pubnub, @NotNull PNUUIDMetadataResult pnUUIDMetadataResult) {
            LOG.trace("uuid: {}.", (Object)pnUUIDMetadataResult);
        }

        @Override
        public void channel(@NotNull PubNub pubnub, @NotNull PNChannelMetadataResult pnChannelMetadataResult) {
            LOG.trace("uuid: {}.", (Object)pnChannelMetadataResult);
        }

        @Override
        public void membership(@NotNull PubNub pubnub, @NotNull PNMembershipResult pnMembershipResult) {
            LOG.trace("membership: {}.", (Object)pnMembershipResult);
        }

        @Override
        public void messageAction(@NotNull PubNub pubnub, @NotNull PNMessageActionResult pnMessageActionResult) {
            LOG.trace("messageAction: {}.", (Object)pnMessageActionResult);
        }

        @Override
        public void file(@NotNull PubNub pubnub, @NotNull PNFileEventResult pnFileEventResult) {
            LOG.trace("file: {}.", (Object)pnFileEventResult);
        }
    }
}

