/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pubnub;

import com.pubnub.api.PubNubException;
import com.pubnub.api.models.consumer.PNPublishResult;
import com.pubnub.api.models.consumer.history.PNHistoryResult;
import com.pubnub.api.models.consumer.presence.PNGetStateResult;
import com.pubnub.api.models.consumer.presence.PNHereNowResult;
import com.pubnub.api.models.consumer.presence.PNSetStateResult;
import java.util.List;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelException;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.pubnub.PubNubConfiguration;
import org.apache.camel.component.pubnub.PubNubEndpoint;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PubNubProducer
extends DefaultAsyncProducer {
    private static final Logger LOG = LoggerFactory.getLogger(PubNubProducer.class);
    private final PubNubEndpoint endpoint;
    private final PubNubConfiguration pubnubConfiguration;

    public PubNubProducer(PubNubEndpoint endpoint, PubNubConfiguration pubNubConfiguration) {
        super(endpoint);
        this.endpoint = endpoint;
        this.pubnubConfiguration = pubNubConfiguration;
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        Operation operation = this.getOperation(exchange);
        LOG.debug("Executing {} operation", (Object)operation);
        try {
            switch (operation.ordinal()) {
                case 4: {
                    this.doPublish(exchange, callback);
                    break;
                }
                case 5: {
                    this.doFire(exchange, callback);
                    break;
                }
                case 3: {
                    this.doGetHistory(exchange, callback);
                    break;
                }
                case 1: {
                    this.doGetState(exchange, callback);
                    break;
                }
                case 0: {
                    this.doHereNow(exchange, callback);
                    break;
                }
                case 2: {
                    this.doSetState(exchange, callback);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(operation.toString());
                }
            }
        }
        catch (Exception e) {
            exchange.setException(e);
            callback.done(true);
            return true;
        }
        return false;
    }

    private void doPublish(Exchange exchange, AsyncCallback callback) {
        Object body = exchange.getIn().getBody();
        if (ObjectHelper.isEmpty(body)) {
            throw new RuntimeCamelException("Cannot publish empty message");
        }
        LOG.debug("Sending message [{}] to channel [{}]", body, (Object)this.getChannel(exchange));
        this.endpoint.getPubnub().publish().message(body).channel(this.getChannel(exchange)).usePOST(true).async(result -> {
            LOG.debug("Got publish message [{}]", result);
            if (result.isFailure()) {
                PubNubException ex = result.exceptionOrNull();
                if (ex != null) {
                    exchange.setException(ex);
                }
                callback.done(false);
            } else {
                PNPublishResult r = (PNPublishResult)result.getOrNull();
                if (r != null) {
                    exchange.getIn().setHeader("CamelPubNubTimeToken", r.getTimetoken());
                }
                this.processMessage(exchange, callback, null);
            }
        });
    }

    private void doFire(Exchange exchange, AsyncCallback callback) {
        Object body = exchange.getIn().getBody();
        if (ObjectHelper.isEmpty(body)) {
            exchange.setException(new CamelException("Can not fire empty message"));
            callback.done(true);
        }
        LOG.debug("Sending message [{}] to channel [{}]", body, (Object)this.getChannel(exchange));
        this.endpoint.getPubnub().fire().message(body).channel(this.getChannel(exchange)).async(result -> {
            LOG.debug("Got fire message [{}]", result);
            if (result.isFailure()) {
                PubNubException ex = result.exceptionOrNull();
                if (ex != null) {
                    exchange.setException(ex);
                }
                callback.done(false);
            } else {
                PNPublishResult r = (PNPublishResult)result.getOrNull();
                if (r != null) {
                    exchange.getIn().setHeader("CamelPubNubTimeToken", r.getTimetoken());
                }
                this.processMessage(exchange, callback, null);
            }
        });
    }

    private void doGetHistory(Exchange exchange, AsyncCallback callback) {
        this.endpoint.getPubnub().history().channel(this.getChannel(exchange)).async(result -> {
            LOG.debug("Got history message [{}]", result);
            if (result.isFailure()) {
                PubNubException ex = result.exceptionOrNull();
                if (ex != null) {
                    exchange.setException(ex);
                }
                callback.done(false);
            } else {
                PNHistoryResult r = (PNHistoryResult)result.getOrNull();
                this.processMessage(exchange, callback, r != null ? r.getMessages() : null);
            }
        });
    }

    private void doSetState(Exchange exchange, AsyncCallback callback) {
        Object body = exchange.getIn().getBody();
        if (ObjectHelper.isEmpty(body)) {
            exchange.setException(new CamelException("Can not publish empty message"));
            callback.done(true);
        }
        LOG.debug("Sending setState [{}] to channel [{}]", body, (Object)this.getChannel(exchange));
        this.endpoint.getPubnub().setPresenceState().channels(List.of(this.getChannel(exchange))).state(body).uuid(this.getUUID(exchange)).async(result -> {
            LOG.debug("Got setState response [{}]", result);
            if (result.isFailure()) {
                PubNubException ex = result.exceptionOrNull();
                if (ex != null) {
                    exchange.setException(ex);
                }
                callback.done(false);
            } else {
                PNSetStateResult r = (PNSetStateResult)result.getOrNull();
                this.processMessage(exchange, callback, r);
            }
        });
    }

    private void doGetState(Exchange exchange, AsyncCallback callback) {
        this.endpoint.getPubnub().getPresenceState().channels(List.of(this.getChannel(exchange))).uuid(this.getUUID(exchange)).async(result -> {
            LOG.debug("Got state [{}]", result);
            if (result.isFailure()) {
                PubNubException ex = result.exceptionOrNull();
                if (ex != null) {
                    exchange.setException(ex);
                }
                callback.done(false);
            } else {
                PNGetStateResult r = (PNGetStateResult)result.getOrNull();
                this.processMessage(exchange, callback, r);
            }
        });
    }

    private void doHereNow(Exchange exchange, AsyncCallback callback) {
        this.endpoint.getPubnub().hereNow().channels(List.of(this.getChannel(exchange))).includeState(true).includeUUIDs(true).async(result -> {
            LOG.debug("Got herNow message [{}]", result);
            if (result.isFailure()) {
                PubNubException ex = result.exceptionOrNull();
                if (ex != null) {
                    exchange.setException(ex);
                }
                callback.done(false);
            } else {
                PNHereNowResult r = (PNHereNowResult)result.getOrNull();
                this.processMessage(exchange, callback, r);
            }
        });
    }

    private void processMessage(Exchange exchange, AsyncCallback callback, Object body) {
        if (body != null) {
            ExchangeHelper.setInOutBodyPatternAware(exchange, body);
        }
        callback.done(false);
    }

    private Operation getOperation(Exchange exchange) {
        String operation = exchange.getIn().getHeader("CamelPubNubOperation", String.class);
        if (operation == null) {
            operation = this.pubnubConfiguration.getOperation();
        }
        return operation != null ? Operation.valueOf(operation.toUpperCase()) : Operation.PUBLISH;
    }

    private String getChannel(Exchange exchange) {
        String channel = exchange.getIn().getHeader("CamelPubNubChannel", String.class);
        return channel != null ? channel : this.pubnubConfiguration.getChannel();
    }

    private String getUUID(Exchange exchange) {
        String uuid = exchange.getIn().getHeader("CamelPubNubUUID", String.class);
        return uuid != null ? uuid : this.pubnubConfiguration.getUuid();
    }

    private static enum Operation {
        HERENOW,
        GETSTATE,
        SETSTATE,
        GETHISTORY,
        PUBLISH,
        FIRE;

    }
}

