/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pulsar.utils.message;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.RuntimeCamelException;

public final class PulsarMessageUtils {
    private PulsarMessageUtils() {
    }

    public static Exchange updateExchange(org.apache.pulsar.client.api.Message<byte[]> message, Exchange input) {
        Exchange output = input.copy();
        Message msg = output.getIn();
        msg.setHeader("event_time", message.getEventTime());
        msg.setHeader("message_id", message.getMessageId());
        msg.setHeader("key", message.getKey());
        msg.setHeader("key_bytes", message.getKeyBytes());
        msg.setHeader("producer_name", message.getProducerName());
        msg.setHeader("topic_name", message.getTopicName());
        msg.setHeader("sequence_id", message.getSequenceId());
        msg.setHeader("publish_time", message.getPublishTime());
        msg.setHeader("CamelPulsarRedeliveryCount", message.getRedeliveryCount());
        msg.setHeader("properties", message.getProperties());
        msg.setHeader("CamelMessageTimestamp", message.getPublishTime());
        msg.setBody(message.getValue());
        output.setIn(msg);
        return output;
    }

    public static Exchange updateExchangeWithException(Exception exception, Exchange input) {
        Exchange output = input.copy();
        output.setException(exception);
        return output;
    }

    public static byte[] serialize(Object body) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream outputStream = new ObjectOutputStream(byteArrayOutputStream);
        try {
            outputStream.writeObject(body);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (NotSerializableException exception) {
            throw new RuntimeCamelException(exception);
        }
        finally {
            byteArrayOutputStream.close();
            outputStream.close();
        }
    }
}

