/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.Schemas;
import org.apache.pulsar.client.admin.internal.BaseResource;
import org.apache.pulsar.client.admin.internal.WebTargets;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.internal.DefaultImplementation;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.protocol.schema.DeleteSchemaResponse;
import org.apache.pulsar.common.protocol.schema.GetAllVersionsSchemaResponse;
import org.apache.pulsar.common.protocol.schema.GetSchemaResponse;
import org.apache.pulsar.common.protocol.schema.IsCompatibilityResponse;
import org.apache.pulsar.common.protocol.schema.LongSchemaVersionResponse;
import org.apache.pulsar.common.protocol.schema.PostSchemaPayload;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaInfoWithVersion;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.shade.javax.ws.rs.client.Entity;
import org.apache.pulsar.shade.javax.ws.rs.client.InvocationCallback;
import org.apache.pulsar.shade.javax.ws.rs.client.WebTarget;

public class SchemasImpl
extends BaseResource
implements Schemas {
    private final WebTarget adminV2;
    private final WebTarget adminV1;

    public SchemasImpl(WebTarget web, Authentication auth, long requestTimeoutMs) {
        super(auth, requestTimeoutMs);
        this.adminV1 = web.path("/admin/schemas");
        this.adminV2 = web.path("/admin/v2/schemas");
    }

    @Override
    public SchemaInfo getSchemaInfo(String topic) throws PulsarAdminException {
        return (SchemaInfo)this.sync(() -> this.getSchemaInfoAsync(topic));
    }

    @Override
    public CompletableFuture<SchemaInfo> getSchemaInfoAsync(String topic) {
        TopicName tn = TopicName.get(topic);
        return this.asyncGetRequest(this.schemaPath(tn), new BaseResource.FutureCallback<GetSchemaResponse>(){}).thenApply(response -> SchemasImpl.convertGetSchemaResponseToSchemaInfo(tn, response));
    }

    @Override
    public SchemaInfoWithVersion getSchemaInfoWithVersion(String topic) throws PulsarAdminException {
        return (SchemaInfoWithVersion)this.sync(() -> this.getSchemaInfoWithVersionAsync(topic));
    }

    @Override
    public CompletableFuture<SchemaInfoWithVersion> getSchemaInfoWithVersionAsync(String topic) {
        TopicName tn = TopicName.get(topic);
        return this.asyncGetRequest(this.schemaPath(tn), new BaseResource.FutureCallback<GetSchemaResponse>(){}).thenApply(response -> SchemasImpl.convertGetSchemaResponseToSchemaInfoWithVersion(tn, response));
    }

    @Override
    public SchemaInfo getSchemaInfo(String topic, long version) throws PulsarAdminException {
        return (SchemaInfo)this.sync(() -> this.getSchemaInfoAsync(topic, version));
    }

    @Override
    public CompletableFuture<SchemaInfo> getSchemaInfoAsync(String topic, long version) {
        TopicName tn = TopicName.get(topic);
        WebTarget path = this.schemaPath(tn).path(Long.toString(version));
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<GetSchemaResponse>(){}).thenApply(response -> SchemasImpl.convertGetSchemaResponseToSchemaInfo(tn, response));
    }

    @Override
    public void deleteSchema(String topic) throws PulsarAdminException {
        this.deleteSchema(topic, false);
    }

    @Override
    public CompletableFuture<Void> deleteSchemaAsync(String topic) {
        return this.deleteSchemaAsync(topic, false);
    }

    @Override
    public void deleteSchema(String topic, boolean force) throws PulsarAdminException {
        this.sync(() -> this.deleteSchemaAsync(topic, force));
    }

    @Override
    public CompletableFuture<Void> deleteSchemaAsync(String topic, boolean force) {
        WebTarget path = this.schemaPath(TopicName.get(topic)).queryParam("force", Boolean.toString(force));
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            this.request(path).async().delete(new InvocationCallback<DeleteSchemaResponse>(){

                @Override
                public void completed(DeleteSchemaResponse deleteSchemaResponse) {
                    future.complete(null);
                }

                @Override
                public void failed(Throwable throwable) {
                    future.completeExceptionally(BaseResource.getApiException(throwable.getCause()));
                }
            });
        }
        catch (PulsarAdminException cae) {
            future.completeExceptionally(cae);
        }
        return future;
    }

    @Override
    public void createSchema(String topic, SchemaInfo schemaInfo) throws PulsarAdminException {
        this.createSchema(topic, SchemasImpl.convertSchemaInfoToPostSchemaPayload(schemaInfo));
    }

    @Override
    public CompletableFuture<Void> createSchemaAsync(String topic, SchemaInfo schemaInfo) {
        return this.createSchemaAsync(topic, SchemasImpl.convertSchemaInfoToPostSchemaPayload(schemaInfo));
    }

    @Override
    public void createSchema(String topic, PostSchemaPayload payload) throws PulsarAdminException {
        this.sync(() -> this.createSchemaAsync(topic, payload));
    }

    @Override
    public CompletableFuture<Void> createSchemaAsync(String topic, PostSchemaPayload payload) {
        TopicName tn = TopicName.get(topic);
        return this.asyncPostRequest(this.schemaPath(tn), Entity.json(payload));
    }

    @Override
    public IsCompatibilityResponse testCompatibility(String topic, PostSchemaPayload payload) throws PulsarAdminException {
        return (IsCompatibilityResponse)this.sync(() -> this.testCompatibilityAsync(topic, payload));
    }

    @Override
    public CompletableFuture<IsCompatibilityResponse> testCompatibilityAsync(String topic, PostSchemaPayload payload) {
        TopicName tn = TopicName.get(topic);
        final CompletableFuture<IsCompatibilityResponse> future = new CompletableFuture<IsCompatibilityResponse>();
        try {
            this.request(this.compatibilityPath(tn)).async().post(Entity.json(payload), new InvocationCallback<IsCompatibilityResponse>(){

                @Override
                public void completed(IsCompatibilityResponse isCompatibilityResponse) {
                    future.complete(isCompatibilityResponse);
                }

                @Override
                public void failed(Throwable throwable) {
                    future.completeExceptionally(BaseResource.getApiException(throwable.getCause()));
                }
            });
        }
        catch (PulsarAdminException cae) {
            future.completeExceptionally(cae);
        }
        return future;
    }

    @Override
    public Long getVersionBySchema(String topic, PostSchemaPayload payload) throws PulsarAdminException {
        return (Long)this.sync(() -> this.getVersionBySchemaAsync(topic, payload));
    }

    @Override
    public CompletableFuture<Long> getVersionBySchemaAsync(String topic, PostSchemaPayload payload) {
        final CompletableFuture<Long> future = new CompletableFuture<Long>();
        try {
            this.request(this.versionPath(TopicName.get(topic))).async().post(Entity.json(payload), new InvocationCallback<LongSchemaVersionResponse>(){

                @Override
                public void completed(LongSchemaVersionResponse longSchemaVersionResponse) {
                    future.complete(longSchemaVersionResponse.getVersion());
                }

                @Override
                public void failed(Throwable throwable) {
                    future.completeExceptionally(BaseResource.getApiException(throwable.getCause()));
                }
            });
        }
        catch (PulsarAdminException cae) {
            future.completeExceptionally(cae);
        }
        return future;
    }

    @Override
    public IsCompatibilityResponse testCompatibility(String topic, SchemaInfo schemaInfo) throws PulsarAdminException {
        return (IsCompatibilityResponse)this.sync(() -> this.testCompatibilityAsync(topic, schemaInfo));
    }

    @Override
    public CompletableFuture<IsCompatibilityResponse> testCompatibilityAsync(String topic, SchemaInfo schemaInfo) {
        final CompletableFuture<IsCompatibilityResponse> future = new CompletableFuture<IsCompatibilityResponse>();
        try {
            this.request(this.compatibilityPath(TopicName.get(topic))).async().post(Entity.json(SchemasImpl.convertSchemaInfoToPostSchemaPayload(schemaInfo)), new InvocationCallback<IsCompatibilityResponse>(){

                @Override
                public void completed(IsCompatibilityResponse isCompatibilityResponse) {
                    future.complete(isCompatibilityResponse);
                }

                @Override
                public void failed(Throwable throwable) {
                    future.completeExceptionally(BaseResource.getApiException(throwable.getCause()));
                }
            });
        }
        catch (PulsarAdminException cae) {
            future.completeExceptionally(cae);
        }
        return future;
    }

    @Override
    public Long getVersionBySchema(String topic, SchemaInfo schemaInfo) throws PulsarAdminException {
        return (Long)this.sync(() -> this.getVersionBySchemaAsync(topic, schemaInfo));
    }

    @Override
    public CompletableFuture<Long> getVersionBySchemaAsync(String topic, SchemaInfo schemaInfo) {
        final CompletableFuture<Long> future = new CompletableFuture<Long>();
        try {
            this.request(this.versionPath(TopicName.get(topic))).async().post(Entity.json(SchemasImpl.convertSchemaInfoToPostSchemaPayload(schemaInfo)), new InvocationCallback<LongSchemaVersionResponse>(){

                @Override
                public void completed(LongSchemaVersionResponse longSchemaVersionResponse) {
                    future.complete(longSchemaVersionResponse.getVersion());
                }

                @Override
                public void failed(Throwable throwable) {
                    future.completeExceptionally(BaseResource.getApiException(throwable.getCause()));
                }
            });
        }
        catch (PulsarAdminException cae) {
            future.completeExceptionally(cae);
        }
        return future;
    }

    @Override
    public List<SchemaInfo> getAllSchemas(String topic) throws PulsarAdminException {
        return (List)this.sync(() -> this.getAllSchemasAsync(topic));
    }

    @Override
    public CompletableFuture<List<SchemaInfo>> getAllSchemasAsync(String topic) {
        WebTarget path = this.schemasPath(TopicName.get(topic));
        TopicName topicName = TopicName.get(topic);
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<GetAllVersionsSchemaResponse>(){}).thenApply(response -> response.getGetSchemaResponses().stream().map(getSchemaResponse -> SchemasImpl.convertGetSchemaResponseToSchemaInfo(topicName, getSchemaResponse)).collect(Collectors.toList()));
    }

    private WebTarget schemaPath(TopicName topicName) {
        return this.topicPath(topicName, "schema");
    }

    private WebTarget versionPath(TopicName topicName) {
        return this.topicPath(topicName, "version");
    }

    private WebTarget schemasPath(TopicName topicName) {
        return this.topicPath(topicName, "schemas");
    }

    private WebTarget compatibilityPath(TopicName topicName) {
        return this.topicPath(topicName, "compatibility");
    }

    private WebTarget topicPath(TopicName topic, String ... parts) {
        WebTarget base = topic.isV2() ? this.adminV2 : this.adminV1;
        WebTarget topicPath = base.path(topic.getRestPath(false));
        topicPath = WebTargets.addParts(topicPath, parts);
        return topicPath;
    }

    static SchemaInfo convertGetSchemaResponseToSchemaInfo(TopicName tn, GetSchemaResponse response) {
        byte[] schema;
        if (response.getType() == SchemaType.KEY_VALUE) {
            try {
                schema = DefaultImplementation.getDefaultImplementation().convertKeyValueDataStringToSchemaInfoSchema(response.getData().getBytes(StandardCharsets.UTF_8));
            }
            catch (IOException conversionError) {
                throw new RuntimeException(conversionError);
            }
        } else {
            schema = response.getData().getBytes(StandardCharsets.UTF_8);
        }
        return SchemaInfo.builder().schema(schema).type(response.getType()).timestamp(response.getTimestamp()).properties(response.getProperties()).name(tn.getLocalName()).build();
    }

    static SchemaInfoWithVersion convertGetSchemaResponseToSchemaInfoWithVersion(TopicName tn, GetSchemaResponse response) {
        return SchemaInfoWithVersion.builder().schemaInfo(SchemasImpl.convertGetSchemaResponseToSchemaInfo(tn, response)).version(response.getVersion()).build();
    }

    static String convertSchemaDataToStringLegacy(SchemaInfo schemaInfo) throws IOException {
        byte[] schemaData = schemaInfo.getSchema();
        if (null == schemaInfo.getSchema()) {
            return "";
        }
        if (schemaInfo.getType() == SchemaType.KEY_VALUE) {
            return DefaultImplementation.getDefaultImplementation().convertKeyValueSchemaInfoDataToString(DefaultImplementation.getDefaultImplementation().decodeKeyValueSchemaInfo(schemaInfo));
        }
        return new String(schemaData, StandardCharsets.UTF_8);
    }

    static PostSchemaPayload convertSchemaInfoToPostSchemaPayload(SchemaInfo schemaInfo) {
        try {
            PostSchemaPayload payload = new PostSchemaPayload();
            payload.setType(schemaInfo.getType().name());
            payload.setProperties(schemaInfo.getProperties());
            payload.setSchema(SchemasImpl.convertSchemaDataToStringLegacy(schemaInfo));
            return payload;
        }
        catch (IOException conversionError) {
            throw new RuntimeException(conversionError);
        }
    }
}

