/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import org.apache.avro.Schema;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;

public class NativeAvroBytesSchema<T>
implements org.apache.pulsar.client.api.Schema<byte[]> {
    private final Schema nativeSchema;
    private final SchemaInfo schemaInfo;

    public NativeAvroBytesSchema(Schema schema) {
        Objects.requireNonNull(schema, "Avro schema cannot be null");
        this.nativeSchema = schema;
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("__alwaysAllowNull", "true");
        properties.put("__jsr310ConversionEnabled", "false");
        this.schemaInfo = SchemaInfo.builder().name("").schema(schema.toString().getBytes(StandardCharsets.UTF_8)).properties(properties).type(SchemaType.AVRO).build();
    }

    public NativeAvroBytesSchema(Object schema) {
        this(NativeAvroBytesSchema.validateSchema(schema));
    }

    private static Schema validateSchema(Object schema) {
        if (!(schema instanceof Schema)) {
            throw new IllegalArgumentException("The input schema is not of type 'org.apache.avro.Schema'.");
        }
        return (Schema)schema;
    }

    @Override
    public byte[] encode(byte[] message) {
        return message;
    }

    @Override
    public byte[] decode(byte[] bytes, byte[] schemaVersion) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SchemaInfo getSchemaInfo() {
        return this.schemaInfo;
    }

    @Override
    public Optional<Object> getNativeSchema() {
        return Optional.of(this.nativeSchema);
    }

    @Override
    public org.apache.pulsar.client.api.Schema<byte[]> clone() {
        return new NativeAvroBytesSchema<T>(this.nativeSchema);
    }
}

