/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pulsar;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.pulsar.DefaultPulsarMessageReceiptFactory;
import org.apache.camel.component.pulsar.PulsarConfiguration;
import org.apache.camel.component.pulsar.PulsarEndpoint;
import org.apache.camel.component.pulsar.PulsarMessageReceiptFactory;
import org.apache.camel.component.pulsar.utils.AutoConfiguration;
import org.apache.camel.component.pulsar.utils.PulsarPath;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.pulsar.client.api.PulsarClient;

@Component(value="pulsar")
public class PulsarComponent
extends DefaultComponent {
    @Metadata(label="advanced")
    private AutoConfiguration autoConfiguration;
    @Metadata(label="advanced", autowired=true)
    private PulsarClient pulsarClient;
    @Metadata(label="consumer,advanced")
    private PulsarMessageReceiptFactory pulsarMessageReceiptFactory = new DefaultPulsarMessageReceiptFactory();
    @Metadata
    private PulsarConfiguration configuration = new PulsarConfiguration();

    public PulsarComponent() {
    }

    public PulsarComponent(CamelContext context) {
        super(context);
    }

    @Override
    protected Endpoint createEndpoint(String uri, String path, Map<String, Object> parameters) throws Exception {
        if (this.autoConfiguration != null && this.autoConfiguration.isAutoConfigurable()) {
            this.autoConfiguration.ensureNameSpaceAndTenant(path);
        }
        PulsarConfiguration copy = this.configuration.copy();
        PulsarEndpoint answer = new PulsarEndpoint(uri, this);
        answer.setPulsarConfiguration(copy);
        answer.setPulsarClient(this.pulsarClient);
        this.setProperties(answer, parameters);
        PulsarPath pp = new PulsarPath(path);
        if (!pp.isAutoConfigurable()) {
            throw new IllegalArgumentException("Pulsar name structure is invalid: was " + path);
        }
        answer.setPersistence(pp.getPersistence());
        answer.setTenant(pp.getTenant());
        answer.setNamespace(pp.getNamespace());
        answer.setTopic(pp.getTopic());
        return answer;
    }

    public PulsarConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(PulsarConfiguration configuration) {
        this.configuration = configuration;
    }

    public AutoConfiguration getAutoConfiguration() {
        return this.autoConfiguration;
    }

    public void setAutoConfiguration(AutoConfiguration autoConfiguration) {
        this.autoConfiguration = autoConfiguration;
    }

    public PulsarClient getPulsarClient() {
        return this.pulsarClient;
    }

    public void setPulsarClient(PulsarClient pulsarClient) {
        this.pulsarClient = pulsarClient;
    }

    public PulsarMessageReceiptFactory getPulsarMessageReceiptFactory() {
        return this.pulsarMessageReceiptFactory;
    }

    public void setPulsarMessageReceiptFactory(PulsarMessageReceiptFactory pulsarMessageReceiptFactory) {
        this.pulsarMessageReceiptFactory = pulsarMessageReceiptFactory;
    }
}

