/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.EncodedAuthenticationParameterSupport;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.auth.AuthenticationDisabled;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.shade.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.ObjectReader;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;

public class AuthenticationUtil {
    private static final ObjectReader HASHMAP_READER = ObjectMapperFactory.getMapper().reader().forType(new TypeReference<HashMap<String, String>>(){});

    public static Map<String, String> configureFromJsonString(String authParamsString) throws IOException {
        return (Map)HASHMAP_READER.readValue(authParamsString);
    }

    public static Map<String, String> configureFromPulsar1AuthParamString(String authParamsString) {
        HashMap<String, String> authParams = new HashMap<String, String>();
        if (StringUtils.isNotBlank(authParamsString)) {
            String[] params;
            for (String p : params = authParamsString.split(",")) {
                String key;
                int index = p.indexOf(58);
                if (index < 0 || (key = p.substring(0, index)).isEmpty()) continue;
                authParams.put(key, p.substring(index + 1));
            }
        }
        return authParams;
    }

    public static final Authentication create(String authPluginClassName, String authParamsString) throws PulsarClientException.UnsupportedAuthenticationException {
        try {
            if (StringUtils.isNotBlank(authPluginClassName)) {
                Class<?> authClass = Class.forName(authPluginClassName);
                Authentication auth = (Authentication)authClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (auth instanceof EncodedAuthenticationParameterSupport) {
                    ((EncodedAuthenticationParameterSupport)((Object)auth)).configure(authParamsString);
                } else {
                    auth.configure(AuthenticationUtil.configureFromPulsar1AuthParamString(authParamsString));
                }
                return auth;
            }
            return new AuthenticationDisabled();
        }
        catch (Throwable t2) {
            throw new PulsarClientException.UnsupportedAuthenticationException(t2);
        }
    }

    public static final Authentication create(String authPluginClassName, Map<String, String> authParams) throws PulsarClientException.UnsupportedAuthenticationException {
        try {
            if (StringUtils.isNotBlank(authPluginClassName)) {
                Class<?> authClass = Class.forName(authPluginClassName);
                Authentication auth = (Authentication)authClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                auth.configure(authParams);
                return auth;
            }
            return new AuthenticationDisabled();
        }
        catch (Throwable t2) {
            throw new PulsarClientException.UnsupportedAuthenticationException(t2);
        }
    }
}

