/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.cfg;

import com.mchange.v2.c3p0.cfg.C3P0Config;
import com.mchange.v2.c3p0.cfg.C3P0ConfigFinder;
import com.mchange.v2.c3p0.cfg.C3P0ConfigUtils;
import com.mchange.v2.c3p0.cfg.C3P0ConfigXmlUtils;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;

public class DefaultC3P0ConfigFinder
implements C3P0ConfigFinder {
    static final String XML_CFG_FILE_KEY = "com.mchange.v2.c3p0.cfg.xml";
    static final String XML_CFG_EXPAND_ENTITY_REFS_KEY = "com.mchange.v2.c3p0.cfg.xml.expandEntityReferences";
    static final String XML_CFG_USE_PERMISSIVE_PARSER_KEY = "com.mchange.v2.c3p0.cfg.xml.usePermissiveParser";
    static final String CLASSLOADER_RESOURCE_PREFIX = "classloader:";
    static final MLogger logger = MLog.getLogger(DefaultC3P0ConfigFinder.class);
    final boolean warn_of_xml_overrides;

    public DefaultC3P0ConfigFinder(boolean bl) {
        this.warn_of_xml_overrides = bl;
    }

    public DefaultC3P0ConfigFinder() {
        this(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public C3P0Config findConfig() throws Exception {
        Object object;
        Object object2;
        HashMap hashMap = C3P0ConfigUtils.extractHardcodedC3P0Defaults();
        hashMap.putAll(C3P0ConfigUtils.extractC3P0PropertiesResources());
        String string = C3P0Config.getPropsFileConfigProperty(XML_CFG_FILE_KEY);
        boolean bl = this.findUsePermissiveParser();
        if (string == null) {
            object2 = C3P0ConfigXmlUtils.extractXmlConfigFromDefaultResource(bl);
            if (object2 != null) {
                this.insertDefaultsUnderNascentConfig(hashMap, (C3P0Config)object2);
                object = object2;
                this.mbOverrideWarning("resource", "/c3p0-config.xml");
            } else {
                object = C3P0ConfigUtils.configFromFlatDefaults(hashMap);
            }
        } else {
            string = string.trim();
            object2 = null;
            try {
                Object object3;
                if (string.startsWith(CLASSLOADER_RESOURCE_PREFIX)) {
                    object3 = this.getClass().getClassLoader();
                    String string2 = string.substring(CLASSLOADER_RESOURCE_PREFIX.length());
                    if (string2.startsWith("/")) {
                        string2 = string2.substring(1);
                    }
                    if ((object2 = ((ClassLoader)object3).getResourceAsStream(string2)) == null) {
                        throw new FileNotFoundException("Specified ClassLoader resource '" + string2 + "' could not be found. [ Found in configuration: " + XML_CFG_FILE_KEY + '=' + string + " ]");
                    }
                    this.mbOverrideWarning("resource", string2);
                } else {
                    object2 = new BufferedInputStream(new FileInputStream(string));
                    this.mbOverrideWarning("file", string);
                }
                object3 = C3P0ConfigXmlUtils.extractXmlConfigFromInputStream((InputStream)object2, bl);
                this.insertDefaultsUnderNascentConfig(hashMap, (C3P0Config)object3);
                object = object3;
            }
            finally {
                try {
                    if (object2 != null) {
                        ((InputStream)object2).close();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        object2 = C3P0ConfigUtils.findAllC3P0SystemProperties();
        ((C3P0Config)object).defaultConfig.props.putAll(object2);
        return object;
    }

    private void insertDefaultsUnderNascentConfig(HashMap hashMap, C3P0Config c3P0Config) {
        hashMap.putAll(c3P0Config.defaultConfig.props);
        c3P0Config.defaultConfig.props = hashMap;
    }

    private void mbOverrideWarning(String string, String string2) {
        if (this.warn_of_xml_overrides && logger.isLoggable(MLevel.WARNING)) {
            logger.log(MLevel.WARNING, "Configuation defined in " + string + "'" + string2 + "' overrides all other c3p0 config.");
        }
    }

    private static boolean affirmativelyTrue(String string) {
        return string != null && string.trim().equalsIgnoreCase("true");
    }

    private boolean findUsePermissiveParser() {
        boolean bl;
        boolean bl2 = DefaultC3P0ConfigFinder.affirmativelyTrue(C3P0Config.getPropsFileConfigProperty(XML_CFG_EXPAND_ENTITY_REFS_KEY));
        boolean bl3 = DefaultC3P0ConfigFinder.affirmativelyTrue(C3P0Config.getPropsFileConfigProperty(XML_CFG_USE_PERMISSIVE_PARSER_KEY));
        boolean bl4 = bl = bl3 || bl2;
        if (bl && logger.isLoggable(MLevel.WARNING)) {
            String string;
            if (bl2) {
                logger.log(MLevel.WARNING, "You have set the configuration property 'com.mchange.v2.c3p0.cfg.xml.expandEntityReferences', which has been deprecated, to true. Please use 'com.mchange.v2.c3p0.cfg.xml.usePermissiveParser' instead. Please be aware that permissive parsing enables inline document type definitions, XML inclusions, and other fetures!");
                string = bl3 ? "Configuration property 'com.mchange.v2.c3p0.cfg.xml.usePermissiveParser'" : "Configuration property 'com.mchange.v2.c3p0.cfg.xml.expandEntityReferences' (deprecated)";
            } else {
                string = "Configuration property 'com.mchange.v2.c3p0.cfg.xml.usePermissiveParser'";
            }
            logger.log(MLevel.WARNING, string + " is set to 'true'. Entity references will be resolved in XML c3p0 configuration files, doctypes and xml includes will be permitted, the file will in general be parsed very permissively. This may be a security hazard. Be sure you understand your XML config files, including the full transitive closure of entity references and incusions. See CVE-2018-20433, https://nvd.nist.gov/vuln/detail/CVE-2018-20433 / See also https://github.com/OWASP/CheatSheetSeries/blob/31c94f233c40af4237432008106f42a9c4bff05e/cheatsheets/XML_External_Entity_Prevention_Cheat_Sheet.md / See also https://vsecurity.com//download/papers/XMLDTDEntityAttacks.pdf");
        }
        return bl;
    }
}

