/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.quartz.cron;

import java.util.Collections;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Endpoint;
import org.apache.camel.component.cron.api.CamelCronConfiguration;
import org.apache.camel.component.cron.api.CamelCronService;
import org.apache.camel.component.quartz.QuartzComponent;
import org.apache.camel.util.URISupport;

public class CamelQuartzCronService
implements CamelCronService,
CamelContextAware {
    private CamelContext context;

    public Endpoint createEndpoint(CamelCronConfiguration configuration) throws Exception {
        String schedule = this.convertSchedule(configuration.getSchedule());
        String uriPath = "quartz://" + configuration.getName();
        String query = URISupport.createQueryString(Collections.singletonMap("cron", schedule));
        String uri = uriPath + "?" + query;
        QuartzComponent quartz = this.context.getComponent("quartz", QuartzComponent.class);
        return quartz.createEndpoint(uri);
    }

    private String convertSchedule(String schedule) {
        String[] parts = schedule.split("\\s");
        if (parts.length == 5) {
            return "0 " + schedule;
        }
        return schedule;
    }

    public String getId() {
        return "quartz";
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.context = camelContext;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.context;
    }
}

