/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.routepolicy.quartz;

import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.quartz.QuartzComponent;
import org.apache.camel.routepolicy.quartz.ScheduledRoutePolicy;
import org.apache.camel.routepolicy.quartz.ScheduledRoutePolicyConstants;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.Metadata;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;

@Metadata(label="bean", description="A cron based RoutePolicy that can be used to start/stop routes at specific times.", annotations={"interfaceName=org.apache.camel.spi.RoutePolicy"})
@Configurer(metadataOnly=true)
public class CronScheduledRoutePolicy
extends ScheduledRoutePolicy
implements ScheduledRoutePolicyConstants {
    @Metadata(description="Cron expression for when the route should be started")
    private String routeStartTime;
    @Metadata(description="Cron expression for when the route should be stopped")
    private String routeStopTime;
    @Metadata(label="advanced", description="Cron expression for when the route should be suspended")
    private String routeSuspendTime;
    @Metadata(label="advanced", description="Cron expression for when the route should be resumed")
    private String routeResumeTime;
    @Metadata(description="To use a specific timezone (ID such as CET)")
    private String timeZoneString;
    private TimeZone timeZone;

    @Override
    public void onInit(Route route) {
        try {
            this.doOnInit(route);
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException(e);
        }
    }

    protected void doOnInit(Route route) {
        QuartzComponent quartz = route.getCamelContext().getComponent("quartz", QuartzComponent.class);
        quartz.addScheduleInitTask(scheduler -> {
            this.setScheduler(scheduler);
            if (this.getRouteStopGracePeriod() == 0) {
                this.setRouteStopGracePeriod(10000);
            }
            if (this.getTimeUnit() == null) {
                this.setTimeUnit(TimeUnit.MILLISECONDS);
            }
            if (this.getRouteStartTime() == null && this.getRouteStopTime() == null && this.getRouteSuspendTime() == null && this.getRouteResumeTime() == null) {
                throw new IllegalArgumentException("Scheduled Route Policy for route " + route.getId() + " has no start/stop/suspend/resume times specified");
            }
            this.registerRouteToScheduledRouteDetails(route);
            if (this.getRouteStartTime() != null) {
                this.scheduleRoute(ScheduledRoutePolicyConstants.Action.START, route);
            }
            if (this.getRouteStopTime() != null) {
                this.scheduleRoute(ScheduledRoutePolicyConstants.Action.STOP, route);
            }
            if (this.getRouteSuspendTime() != null) {
                this.scheduleRoute(ScheduledRoutePolicyConstants.Action.SUSPEND, route);
            }
            if (this.getRouteResumeTime() != null) {
                this.scheduleRoute(ScheduledRoutePolicyConstants.Action.RESUME, route);
            }
        });
    }

    @Override
    protected Trigger createTrigger(ScheduledRoutePolicyConstants.Action action, Route route) throws Exception {
        CronTrigger trigger = null;
        CronScheduleBuilder scheduleBuilder = null;
        String triggerPrefix = null;
        if (action == ScheduledRoutePolicyConstants.Action.START) {
            scheduleBuilder = CronScheduleBuilder.cronSchedule(this.getRouteStartTime());
            triggerPrefix = TRIGGER_START;
        } else if (action == ScheduledRoutePolicyConstants.Action.STOP) {
            scheduleBuilder = CronScheduleBuilder.cronSchedule(this.getRouteStopTime());
            triggerPrefix = TRIGGER_STOP;
        } else if (action == ScheduledRoutePolicyConstants.Action.SUSPEND) {
            scheduleBuilder = CronScheduleBuilder.cronSchedule(this.getRouteSuspendTime());
            triggerPrefix = TRIGGER_SUSPEND;
        } else if (action == ScheduledRoutePolicyConstants.Action.RESUME) {
            scheduleBuilder = CronScheduleBuilder.cronSchedule(this.getRouteResumeTime());
            triggerPrefix = TRIGGER_RESUME;
        }
        if (scheduleBuilder != null) {
            if (this.timeZone != null) {
                scheduleBuilder.inTimeZone(this.timeZone);
            }
            TriggerKey triggerKey = new TriggerKey(triggerPrefix + route.getId(), "triggerGroup-" + route.getId());
            trigger = TriggerBuilder.newTrigger().withIdentity(triggerKey).withSchedule(scheduleBuilder).build();
        }
        return trigger;
    }

    public void setRouteStartTime(String routeStartTime) {
        this.routeStartTime = routeStartTime;
    }

    public String getRouteStartTime() {
        return this.routeStartTime;
    }

    public void setRouteStopTime(String routeStopTime) {
        this.routeStopTime = routeStopTime;
    }

    public String getRouteStopTime() {
        return this.routeStopTime;
    }

    public void setRouteSuspendTime(String routeSuspendTime) {
        this.routeSuspendTime = routeSuspendTime;
    }

    public String getRouteSuspendTime() {
        return this.routeSuspendTime;
    }

    public void setRouteResumeTime(String routeResumeTime) {
        this.routeResumeTime = routeResumeTime;
    }

    public String getRouteResumeTime() {
        return this.routeResumeTime;
    }

    public String getTimeZone() {
        return this.timeZoneString;
    }

    public void setTimeZone(String timeZone) {
        this.timeZoneString = timeZone;
        this.timeZone = TimeZone.getTimeZone(timeZone);
    }
}

