/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import quickfix.Field;

public class DoubleField
extends Field<Double> {
    private int padding = 0;

    public DoubleField(int field) {
        super(field, 0.0);
    }

    public DoubleField(int field, Double data) {
        super(field, data);
        this.checkForValidDouble(data);
    }

    public DoubleField(int field, double data) {
        super(field, data);
        this.checkForValidDouble(data);
    }

    public DoubleField(int field, double data, int padding) {
        super(field, data);
        this.checkForValidDouble(data);
        this.padding = padding;
    }

    public void setValue(Double value) {
        this.checkForValidDouble(value);
        this.setObject(value);
    }

    public void setValue(double value) {
        this.checkForValidDouble(value);
        this.setObject(value);
    }

    public double getValue() {
        return (Double)this.getObject();
    }

    public int getPadding() {
        return this.padding;
    }

    public boolean valueEquals(Double value) {
        return ((Double)this.getObject()).equals(value);
    }

    public boolean valueEquals(double value) {
        return ((Double)this.getObject()).equals(value);
    }

    private void checkForValidDouble(Double value) throws NumberFormatException {
        if (Double.isInfinite(value) || Double.isNaN(value)) {
            throw new NumberFormatException("Tried to set NaN or infinite value.");
        }
    }
}

