/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import java.io.Serializable;
import org.quickfixj.CharsetSupport;
import quickfix.MessageUtils;

public class Field<T>
implements Serializable {
    static final long serialVersionUID = 7098326013456432197L;
    private int tag;
    private T object;
    private boolean isCalculated = false;
    private String data;
    private byte[] dataBytes;

    public Field(int field, T object) {
        this.tag = field;
        this.object = object;
    }

    public int getTag() {
        return this.tag;
    }

    public int getField() {
        return this.getTag();
    }

    protected void setObject(T object) {
        this.object = object;
        this.isCalculated = false;
    }

    public T getObject() {
        return this.object;
    }

    public String toString() {
        this.calculate();
        return this.data;
    }

    void toString(StringBuilder buffer) {
        if (this.isCalculated) {
            buffer.append(this.data);
        } else {
            buffer.append(this.tag).append('=').append(this.objectAsString());
        }
    }

    protected String objectAsString() {
        return this.object.toString();
    }

    public boolean equals(Object object) {
        return super.equals(object) || object instanceof Field && this.tag == ((Field)object).getField() && this.getObject().equals(((Field)object).getObject());
    }

    public int hashCode() {
        return this.object.hashCode();
    }

    int getLength() {
        this.calculate();
        return (this.dataBytes != null ? this.dataBytes.length : this.data.length()) + 1;
    }

    int getChecksum() {
        this.calculate();
        return (this.dataBytes != null ? MessageUtils.checksum(this.dataBytes, false) : MessageUtils.checksum(CharsetSupport.getCharsetInstance(), this.data, false)) + 1 & 0xFF;
    }

    private void calculate() {
        if (this.isCalculated) {
            return;
        }
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        this.data = buffer.toString();
        if (!CharsetSupport.isStringEquivalent(CharsetSupport.getCharsetInstance())) {
            this.dataBytes = this.data.getBytes(CharsetSupport.getCharsetInstance());
        }
        this.isCalculated = true;
    }

    public void setTag(int tag) {
        this.tag = tag;
        this.isCalculated = false;
        this.calculate();
    }
}

