/*
 * Decompiled with CFR 0.152.
 */
package quickfix.mina.ssl;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterChain;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.ssl.SslFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLFilter
extends SslFilter {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private boolean useSNI;

    public SSLFilter(SSLContext sslContext, boolean autoStart) {
        super(sslContext, autoStart);
    }

    public SSLFilter(SSLContext sslContext) {
        super(sslContext);
    }

    @Override
    public void setEnabledCipherSuites(String[] cipherSuites) {
    }

    public void setCipherSuites(String[] cipherSuites) {
        super.setEnabledCipherSuites(cipherSuites);
    }

    @Override
    public void onPreAdd(IoFilterChain parent, String name, IoFilter.NextFilter nextFilter) throws SSLException {
        IoSession session;
        SocketAddress remoteAddress;
        if (this.useSNI && (remoteAddress = (session = parent.getSession()).getRemoteAddress()) instanceof InetSocketAddress) {
            this.log.info("Activating TLS SNI support for peer address: {}", (Object)remoteAddress);
            session.setAttribute(PEER_ADDRESS, remoteAddress);
        }
        super.onPreAdd(parent, name, nextFilter);
    }

    public void setUseSNI(boolean useSNI) {
        this.useSNI = useSNI;
    }
}

